/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.PrintStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Node;

public class SaajUtil {
    public static String getSoapProtocol(boolean bl) {
        return bl ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
    }

    public static SOAPElement getFirstChild(SOAPElement sOAPElement) {
        for (Node node = sOAPElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            return (SOAPElement)node;
        }
        return null;
    }

    public static QName qnameFromName(Name name) {
        if (name instanceof QName) {
            return (QName)name;
        }
        return new QName(name.getURI(), name.getLocalName(), name.getPrefix());
    }

    public static void dump(SOAPElement sOAPElement, PrintStream printStream) {
        SaajUtil.dump(sOAPElement, printStream, 0);
    }

    private static void dump(SOAPElement sOAPElement, PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(" ");
        }
        printStream.print("+");
        printStream.println(sOAPElement.getElementName());
        ++n;
        Iterator iterator = sOAPElement.getChildElements();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            SaajUtil.dump((SOAPElement)e, printStream, n);
        }
    }
}

