/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;

public class ServerSecurityHelper {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Map AUTHENTICATORS = new HashMap();

    public static final AuthenticatedSubject getCurrentSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        return authenticatedSubject;
    }

    public static AuthenticatedSubject assertIdentity(String string, String string2, String string3) throws LoginException {
        SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(string, string2);
        return ServerSecurityHelper.getPrincipalAuthenticator(string3).authenticate((CallbackHandler)simpleCallbackHandler);
    }

    public static AuthenticatedSubject assertIdentity(X509Certificate[] x509CertificateArray, String string) throws LoginException {
        try {
            return ServerSecurityHelper.getPrincipalAuthenticator(string).assertIdentity("X.509", (Object)x509CertificateArray);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static void assertAnonymousIdentity() {
        AuthenticatedSubject authenticatedSubject = SubjectUtils.getAnonymousSubject();
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
    }

    public static void assertX509Identity(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
    }

    private static PrincipalAuthenticator getPrincipalAuthenticator(String string) {
        PrincipalAuthenticator principalAuthenticator;
        if (string == null) {
            string = "weblogicDEFAULT";
        }
        if ((principalAuthenticator = (PrincipalAuthenticator)AUTHENTICATORS.get(string)) == null) {
            principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
            AUTHENTICATORS.put(string, principalAuthenticator);
        }
        return principalAuthenticator;
    }

    public static final AuthorizationManager getAuthManager(String string) {
        return (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
    }

    public static final void authenticatedInvoke(AuthenticatedSubject authenticatedSubject, PrivilegedExceptionAction privilegedExceptionAction) throws IOException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            throw new UndeclaredThrowableException(privilegedActionException.getException());
        }
    }
}

