/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SmartNameStore {
    private Class clazz;
    private static HashMap keywords = new HashMap();

    public SmartNameStore(Class clazz) {
        this.clazz = clazz;
    }

    public SmartNameStore() {
        this(null);
    }

    public static String getMangleName(Class clazz) {
        Class clazz2 = SmartNameStore.getComponentType(clazz);
        String string = SmartNameStore.getShortName(clazz2);
        if (clazz.isArray()) {
            string = string + "s";
        }
        string = SmartNameStore.renameKeword(string);
        return string;
    }

    public Iterator getNames(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < classArray.length; ++i) {
            String string = SmartNameStore.getMangleName(classArray[i]);
            string = this.uniqueName(string, arrayList);
            arrayList.add(string);
        }
        return arrayList.iterator();
    }

    private static Class getComponentType(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private String uniqueName(String string, ArrayList arrayList) {
        String string2 = string;
        int n = 0;
        while (arrayList.contains(string2)) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    private static String renameKeword(String string) {
        String string2 = (String)keywords.get(string);
        return string2 == null ? string : string2;
    }

    private static String getShortName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        if (Character.isUpperCase(string.charAt(0))) {
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1, string.length());
        }
        return string;
    }

    static {
        keywords.put("int", "intVal");
        keywords.put("class", "clazz");
        keywords.put("float", "floatVal");
        keywords.put("double", "doubleVal");
        keywords.put("short", "shortVal");
        keywords.put("boolean", "booleanVal");
        keywords.put("long", "longVal");
        keywords.put("char", "charVal");
        keywords.put("byte", "byteVal");
    }
}

