/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.File;
import java.util.Locale;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String getPackage(String string) {
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getSimpleClassName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getRelativeSourcePath(String string) {
        int n;
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("fqn is empty");
        }
        String string2 = string.replace(".", File.separator);
        int n2 = string2.lastIndexOf(File.separator);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.indexOf("$", n2)) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2 + ".java";
    }

    public static boolean isLowerCase(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String must not be null.");
        }
        return string.toLowerCase(Locale.ENGLISH).equals(string);
    }
}

