/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.rpc.JAXRPCException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.VerboseRegistry;

public class Verbose {
    private static boolean verboseOn = false;
    private static HashMap<String, Level> startsWith;
    private static HashMap<String, Level> equals;
    private static HashMap<String, Level> notStartsWith;
    private static HashMap<String, Level> notEquals;
    private static PrintStream out;
    private static DateFormat df;
    private static boolean allwaysOn;
    private static final String WEBSERVICE = "webservice";
    private static DebugLogger logger;
    private static final boolean timestamp;
    private static final boolean threadstamp;
    private static Handler handler;

    private static void init() {
        String string = System.getProperty("weblogic.wsee.verbose");
        String string2 = System.getProperty("weblogic.wsee.verbose.subcomponents");
        if (string == null && string2 == null) {
            verboseOn = Verbose.checkDebugLogger();
            string = "*";
        } else {
            verboseOn = true;
        }
        if (verboseOn) {
            Verbose.banner("Webservice running in Verbose mode " + (timestamp ? " with timestamps enabled" : ""));
            System.out.println("WSEE verbose timestamping = " + timestamp + " in class loader: " + Thread.currentThread().getContextClassLoader());
            System.out.println("WSEE verbose threadstamping = " + threadstamp + " in class loader: " + Thread.currentThread().getContextClassLoader());
            if (string != null) {
                Verbose.parseProperty(string);
            }
            if (string2 != null) {
                Verbose.expandSubcomponentProperty(string2);
            }
        }
        Verbose.setupLogging();
    }

    public static void setupLogging() {
        Verbose.setLoggingLevelsAndAddHandler(handler);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        df = dateFormat;
    }

    private static boolean checkDebugLogger() {
        logger = DebugLogger.getDebugLogger((String)WEBSERVICE);
        return logger.isDebugEnabled();
    }

    public static void setVerbose(boolean bl) {
        allwaysOn = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object object, Throwable throwable) {
        PrintStream printStream = out;
        synchronized (printStream) {
            Verbose.log(object, 2);
            Verbose.log((Object)throwable, 2);
            Verbose.dumpThrowable(throwable);
        }
    }

    public static void log(Object object) {
        object = Verbose.expand(object);
        Verbose.log(object, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logException(Throwable throwable) {
        Verbose.flush();
        PrintStream printStream = out;
        synchronized (printStream) {
            if (throwable == null) {
                return;
            }
            Verbose.log((Object)throwable, 2);
            Verbose.dumpThrowable(throwable);
        }
    }

    private static void dumpThrowable(Throwable throwable) {
        Throwable throwable2;
        throwable.printStackTrace(out);
        out.flush();
        if (throwable instanceof JAXRPCException && (throwable2 = ((JAXRPCException)throwable).getLinkedCause()) != null) {
            Verbose.say("-- Caused by --");
            Verbose.dumpThrowable(throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logArgs(Object ... objectArray) {
        Verbose.flush();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[3];
        String string = Verbose.shortName(stackTraceElement.getClassName());
        String string2 = stackTraceElement.getMethodName();
        PrintStream printStream = out;
        synchronized (printStream) {
            Verbose.writeWSEEStart();
            Verbose.writeTimestamp();
            out.print(string);
            out.print(".");
            out.print(string2);
            out.println("-->");
            for (int i = 0; i < objectArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("  ");
                stringBuffer.append(objectArray[i]);
                if (++i >= objectArray.length) continue;
                stringBuffer.append("= ");
                stringBuffer.append(objectArray[i]);
                out.println(Verbose.fitIn(stringBuffer.toString()));
            }
            Verbose.flush();
        }
    }

    private static String fitIn(Object object) {
        String string;
        String string2 = string = object == null ? "null" : object.toString();
        if (string.length() > 70) {
            string = string.substring(0, 67) + "...";
        }
        return string;
    }

    public static PrintStream getOut() {
        return out;
    }

    public static String expand(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[").append(i).append("]");
                stringBuffer.append(Array.get(object, i));
            }
            return stringBuffer.toString();
        }
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void banner(String string) {
        Verbose.flush();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<WSEE>");
        if (timestamp) {
            stringBuffer.append("[").append(df.format(new Date())).append("]");
        }
        if (threadstamp) {
            stringBuffer.append("[").append(Thread.currentThread().getName()).append("]");
        }
        stringBuffer.append(string);
        string = stringBuffer.toString();
        if (string.length() > 60) {
            string = stringBuffer.substring(0, 58) + "..";
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            int n;
            out.print("  ");
            for (n = 0; n < string.length() + 4; ++n) {
                out.print("-");
            }
            out.println();
            out.print(" |  ");
            out.print(string);
            out.println("  |");
            out.print("  ");
            for (n = 0; n < string.length() + 4; ++n) {
                out.print("-");
            }
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(Object object, int n) {
        Verbose.flush();
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        PrintStream printStream = out;
        synchronized (printStream) {
            Verbose.writeWSEEStart();
            Verbose.writeTimestamp();
            Verbose.writeThreadstamp();
            out.print(object);
            out.print("<");
            out.print(Verbose.shortName(stackTraceElementArray[n].getClassName()));
            out.print(".");
            out.print(stackTraceElementArray[n].getMethodName());
            int n2 = stackTraceElementArray[n].getLineNumber();
            if (n2 > -1) {
                out.print(":");
                out.print(n2);
            }
            out.println(">");
            out.flush();
        }
    }

    private static void writeWSEEStart() {
        out.print("<WSEE:");
        out.print(Thread.currentThread().getId());
        out.print(">");
    }

    private static void writeTimestamp() {
        if (timestamp) {
            out.print("[");
            out.print(df.format(new Date()));
            out.print("]");
        }
    }

    private static void writeThreadstamp() {
        if (threadstamp) {
            out.print("[");
            out.print(Thread.currentThread().getName());
            out.print("]");
        }
    }

    private static void flush() {
        System.out.flush();
        System.err.flush();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void say(String string) {
        Verbose.flush();
        PrintStream printStream = out;
        synchronized (printStream) {
            Verbose.writeTimestamp();
            Verbose.writeThreadstamp();
            out.println(string);
            Verbose.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(LogRecord logRecord) {
        if (logRecord.getThrown() != null) {
            Verbose.logException(logRecord.getThrown());
            return;
        }
        Verbose.flush();
        PrintStream printStream = out;
        synchronized (printStream) {
            Verbose.writeTimestamp();
            Verbose.writeThreadstamp();
            out.print(" ");
            out.print(logRecord.getLevel().getName());
            out.print(" ");
            out.print(logRecord.getLoggerName());
            out.print(" ");
            out.println(logRecord.getMessage());
            Verbose.flush();
        }
    }

    private static String shortName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    private static void parseProperty(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            boolean bl = false;
            if (string2.startsWith("!")) {
                bl = true;
                string2 = string2.substring(1);
            }
            if (string2.startsWith("file=")) {
                Verbose.setOutput(string2.substring("file=".length()));
                continue;
            }
            String string3 = Level.ALL.getName();
            int n = string2.indexOf("=");
            if (n > 0) {
                string3 = string2.substring(n + 1, string2.length());
                string2 = string2.substring(0, n);
            }
            Level level = Level.parse(string3);
            if (string2.endsWith("*")) {
                String string4 = string2.substring(0, string2.length() - 1);
                Verbose.addStartsWith(string4, bl, level);
                continue;
            }
            Verbose.addEquals(string2, bl, level);
        }
    }

    private static void setOutput(String string) {
        File file = new File(string);
        try {
            Object object;
            boolean bl = Boolean.parseBoolean(System.getProperty("weblogic.wsee.verbose.rollFile", "false"));
            if (bl && file.exists()) {
                Object object2 = object = file.getName();
                String string2 = "";
                int n = ((String)object).lastIndexOf(".");
                if (n > 0 && n < ((String)object).length() - 1) {
                    object2 = ((String)object).substring(0, n);
                    string2 = ((String)object).substring(n);
                } else {
                    n = ((String)object).length();
                }
                int n2 = 1;
                while (Verbose.rollFileExists(file.getParentFile(), (String)object2, n2, string2)) {
                    ++n2;
                }
                String string3 = "_" + n2;
                file = new File(file.getParentFile(), (String)object2 + string3 + string2);
                System.out.println("Calculated new WSEE output file with 'rolling' enabled: " + file.getName());
            }
            object = new FileOutputStream(file);
            out = new PrintStream((OutputStream)object, true);
            System.out.println("Set WSEE output to " + file.getAbsoluteFile().getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Verbose.logException(fileNotFoundException);
            Verbose.log("Log to System.out");
            out = System.out;
        }
    }

    private static boolean rollFileExists(File file, String string, int n, String string2) {
        String string3 = "_" + n;
        File file2 = new File(file, string + string3 + string2);
        return file2.exists();
    }

    private static void addEquals(String string, boolean bl, Level level) {
        if (bl) {
            level = Level.OFF;
            if (notEquals == null) {
                notEquals = new HashMap();
            }
            notEquals.put(string, level);
        } else {
            if (equals == null) {
                equals = new HashMap();
            }
            equals.put(string, level);
        }
    }

    private static void addStartsWith(String string, boolean bl, Level level) {
        if (bl) {
            level = Level.OFF;
            if (notStartsWith == null) {
                notStartsWith = new HashMap();
            }
            notStartsWith.put(string, level);
        } else {
            if (startsWith == null) {
                startsWith = new HashMap();
            }
            if ("".equals(string) && level.intValue() < Level.INFO.intValue()) {
                level = Level.INFO;
            }
            startsWith.put(string, level);
        }
    }

    private static void expandSubcomponentProperty(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            boolean bl = false;
            if (string2.startsWith("!")) {
                bl = true;
                string2 = string2.substring(1);
            }
            if (string2.startsWith("file=")) {
                Verbose.setOutput(string2.substring("file=".length()));
                continue;
            }
            String string3 = Level.ALL.getName();
            int n = string2.indexOf("=");
            if (n > 0) {
                string3 = string2.substring(n + 1, string2.length());
                string2 = string2.substring(0, n);
            }
            Level level = Level.parse(string3);
            String[] stringArray = VerboseRegistry.getInstance().getSubcomponent(string2);
            if (stringArray == null) continue;
            for (String string4 : stringArray) {
                if (string4.endsWith("*")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    Verbose.addStartsWith(string4, bl, level);
                    continue;
                }
                Verbose.addEquals(string4, bl, level);
            }
        }
    }

    public static boolean isVerbose(Class clazz) {
        if (allwaysOn) {
            return true;
        }
        if (!verboseOn) {
            return false;
        }
        String string = clazz.getName();
        return Verbose.isVerbose(string);
    }

    public static boolean isVerboseOn() {
        return allwaysOn || verboseOn;
    }

    public static boolean isVerbose(String string) {
        return Verbose.getVerboseLevel(string) != Level.OFF;
    }

    public static Level getVerboseLevel(String string) {
        String string22 = null;
        Level level = Level.OFF;
        if (allwaysOn) {
            return Level.ALL;
        }
        if (!verboseOn) {
            return Level.OFF;
        }
        if (notEquals != null && notEquals.containsKey(string)) {
            return notEquals.get(string);
        }
        if (notStartsWith != null) {
            for (String string22 : notStartsWith.keySet()) {
                if (!string.startsWith(string22)) continue;
                return notStartsWith.get(string22);
            }
        }
        if (equals != null && equals.containsKey(string)) {
            return equals.get(string);
        }
        if (startsWith != null) {
            for (String string22 : startsWith.keySet()) {
                if (!string.startsWith(string22)) continue;
                return startsWith.get(string22);
            }
        }
        return level;
    }

    public static void hookUpUserLogger(Logger logger) {
        Verbose.addHandler(handler, logger);
    }

    public static void setLoggingLevelsAndAddHandler(Handler handler) {
        Level level;
        if (startsWith != null) {
            for (String string : startsWith.keySet()) {
                level = startsWith.get(string);
                if (string.endsWith(".")) {
                    string = string.substring(0, string.length() - 1);
                }
                Verbose.setLogLevelForLogger(handler, string, level);
            }
        }
        if (equals != null) {
            for (String string : equals.keySet()) {
                level = equals.get(string);
                Verbose.setLogLevelForLogger(handler, string, level);
            }
        }
        if (notStartsWith != null) {
            for (String string : notStartsWith.keySet()) {
                if (string.endsWith(".")) {
                    string = string.substring(0, string.length() - 1);
                }
                Verbose.setLogLevelForLogger(null, string, Level.OFF);
            }
        }
        if (notEquals != null) {
            for (String string : notEquals.keySet()) {
                Verbose.setLogLevelForLogger(null, string, Level.OFF);
            }
        }
    }

    private static void setLogLevelForLogger(Handler handler, String string, Level level) {
        if (verboseOn) {
            Verbose.say("#!#! - Setting LogLevel for " + string + " to " + level + " and handler: " + handler);
        }
        Logger logger = Logger.getLogger(string);
        logger.setLevel(level);
        if (handler != null) {
            Verbose.addHandler(handler, logger);
        }
    }

    private static void addHandler(Handler handler, Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        if (!Arrays.asList(handlerArray).contains(handler)) {
            logger.addHandler(handler);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    public static void here() {
        Verbose.log((Object)"Called ........", 2);
    }

    static {
        out = System.out;
        df = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS");
        allwaysOn = false;
        timestamp = Boolean.getBoolean("weblogic.wsee.verbose.timestamp");
        threadstamp = Boolean.getBoolean("weblogic.wsee.verbose.threadstamp");
        handler = new Handler(){

            public void publish(LogRecord logRecord) {
                Verbose.log(logRecord);
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        };
        Verbose.init();
    }
}

