/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class VerboseRegistry {
    private static final VerboseRegistry _instance = new VerboseRegistry();
    private HashMap<String, String[]> _subcomponents;
    private ReentrantReadWriteLock _subcomponentsLock = new ReentrantReadWriteLock(false);

    public static VerboseRegistry getInstance() {
        return _instance;
    }

    private VerboseRegistry() {
        this._subcomponents = new HashMap();
        this.addSubcomponent("soapRouting", new String[][]{{"weblogic.wsee.jaxws.cluster.*", "weblogic.wsee.mc.cluster.*", "weblogic.wsee.reliability2.tube.SequenceIDRoutingInfoFinder", "weblogic.wsee.wstx.wsat.cluster.*"}});
        this.addSubcomponent("soapJaxRpc", new String[][]{{"weblogic.wsee.connection.soap.*", "!weblogic.wsee.connection.soap.SoapConnectionMessage*"}});
        this.addSubcomponent("rmJaxRpc", new String[][]{{"weblogic.wsee.reliability.WsrmSAFManager", "weblogic.wsee.reliability.WsrmSAFSendingManager", "weblogic.wsee.reliability.WsrmSAFReceivingManager", "weblogic.wsee.reliability.WsrmSequenceSender", "weblogic.wsee.server.jms.WsDispatchMessageListener", "weblogic.wsee.reliability.WsrmSAFEndpoint", "weblogic.wsee.jws.container.ServerResponsePathDispatcher", "weblogic.wsee.async.AbstractAsyncResponseBean", "weblogic.wsee.async.AsyncResponseHandler", "weblogic.wsee.ws.dispatch.server.ServerDispatcher", "weblogic.wsee.handler.HandlerIteratorHistory", "weblogic.wsee.async.AsyncInvokeState", "weblogic.wsee.buffer.BufferManager"}});
        this.addSubcomponent("runtime", new String[][]{{"weblogic.wsee.runtime.*", "weblogic.wsee.config.*", "weblogic.wsee.monitoring.*"}});
        this.addSubcomponent("security", new String[][]{{"weblogic.wsee.security.wssc.*"}});
        this.addSubcomponent("jaxWsRuntime", new String[][]{{"weblogic.wsee.jaxws.*", "com.oracle.xml.ws.client.async.*", "com.sun.xml.ws.client.*", "com.sun.xml.ws.server.WSEndpointImpl", "com.sun.xml.ws.api.pipe.Fiber"}});
        this.addSubcomponent("soapJaxWs", new String[][]{{"com.sun.xml.ws.transport.http.client.HttpTransportPipe", "com.sun.xml.ws.transport.http.HttpAdapter"}});
        this.addSubcomponent("persistence", new String[][]{{"weblogic.wsee.persistence.*"}});
        this.addSubcomponent("sender", new String[][]{{"weblogic.wsee.sender.*"}});
        this.addSubcomponent("bufferingJaxWs", new String[][]{{"weblogic.wsee.buffer2.*"}});
        this.addSubcomponent("rmJaxWs", this.getSubcomponent("jaxWsRuntime", true), this.getSubcomponent("runtime", true), this.getSubcomponent("persistence", true), this.getSubcomponent("sender", true), this.getSubcomponent("bufferingJaxWs", true), {"weblogic.wsee.reliability2.*"});
        this.addSubcomponent("mc", this.getSubcomponent("jaxWsRuntime", true), this.getSubcomponent("runtime", true), this.getSubcomponent("persistence", true), {"weblogic.wsee.mc.*"});
        this.addSubcomponent("rsp", this.getSubcomponent("rmJaxWs", true), this.getSubcomponent("mc", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubcomponent(String string, String[] ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray2 : stringArray) {
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        String[][] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
        try {
            int n;
            this._subcomponentsLock.writeLock().lock();
            if (this._subcomponents.containsKey(string)) {
                n = 0;
                return n != 0;
            }
            this._subcomponents.put(string, (String[])stringArray3);
            n = 1;
            return n != 0;
        }
        finally {
            this._subcomponentsLock.writeLock().unlock();
        }
    }

    public String[] getSubcomponent(String string) {
        return this.getSubcomponent(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubcomponent(String string, boolean bl) {
        try {
            this._subcomponentsLock.readLock().lock();
            if (string.endsWith("*")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = string.substring(0, string.length() - 1);
                for (String string3 : this._subcomponents.keySet()) {
                    if (string2.length() != 0 && !string3.startsWith(string2)) continue;
                    String[] stringArray = this.getSubcomponent(string3, true);
                    arrayList.addAll(Arrays.asList(stringArray));
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return stringArray;
            }
            if (bl && !this._subcomponents.containsKey(string)) {
                throw new IllegalArgumentException("Unknown subcomponent: " + string);
            }
            String[] stringArray = this._subcomponents.get(string);
            return stringArray;
        }
        finally {
            this._subcomponentsLock.readLock().unlock();
        }
    }
}

