/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import javax.xml.rpc.JAXRPCException;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.local.LocalDelegateServerTransport;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;

public class VersionRedirectUtil {
    private static final String LOCAL_TRANSPORT = "local";
    private static final String SOAP_VERSION = "SOAP11";
    private static final boolean verbose = Verbose.isVerbose(VersionRedirectUtil.class);

    public static void redirect(WlMessageContext wlMessageContext, String string) throws Throwable {
        Object object;
        WsPort wsPort;
        SoapMessageContext soapMessageContext = new SoapMessageContext(AsyncUtil.isSoap12(wlMessageContext));
        Transport transport = wlMessageContext.getDispatcher().getConnection().getTransport();
        String string2 = WsRegistry.getURL(transport.getServiceURI());
        if (verbose) {
            Verbose.log("VersionRedirectUtil redirect - uri = " + string2);
        }
        if ((wsPort = WsRegistry.instance().lookup(string2, string)) == null) {
            throw new JAXRPCException("The application version used by the current conversation is no longer available.Please start a new conversation with the new version of the application");
        }
        soapMessageContext.setMessage(((SoapMessageContext)wlMessageContext).getMessage());
        Object object2 = wlMessageContext.getPropertyNames();
        while (object2.hasNext()) {
            object = (String)object2.next();
            soapMessageContext.setProperty((String)object, wlMessageContext.getProperty((String)object));
        }
        object2 = wsPort.getWsdlPort().getBinding().getBindingType();
        object = ConnectionFactory.instance().createServerConnection(new LocalDelegateServerTransport((ServerTransport)transport), (String)object2);
        WsSkel wsSkel = (WsSkel)wsPort.getEndpoint();
        wlMessageContext.setProperty("weblogic.wsee.util.VersionRedirectUtil.redirected", new String("true"));
        wsSkel.invoke((Connection)object, wsPort, soapMessageContext);
    }
}

