/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.util.SaajUtil;
import weblogic.xml.saaj.MessageFactoryImpl;
import weblogic.xml.saaj.SAAJMetaFactoryImpl;

public class WLMessageFactory {
    private static WLMessageFactory wlMessageFactory = new WLMessageFactory();
    private SAAJMetaFactoryImpl metaFactory = new SAAJMetaFactoryImpl();

    private WLMessageFactory() {
    }

    public static WLMessageFactory getInstance() {
        return wlMessageFactory;
    }

    public MessageFactory getMessageFactory(boolean bl) {
        try {
            return this.metaFactory.newMessageFactory(SaajUtil.getSoapProtocol(bl));
        }
        catch (SOAPException sOAPException) {
            throw new ExceptionInInitializerError(sOAPException);
        }
    }

    public static SOAPMessage createMessageWithStreamingAttachments() throws SOAPException {
        MessageFactoryImpl messageFactoryImpl = (MessageFactoryImpl)WLMessageFactory.getInstance().getMessageFactory(false);
        try {
            return messageFactoryImpl.createMessage(true, false);
        }
        catch (IOException iOException) {
            throw new SOAPException((Throwable)iOException);
        }
    }

    public static SOAPMessage createMessageWithStreamingAttachments(MimeHeaders mimeHeaders, InputStream inputStream, boolean bl) throws SOAPException {
        MessageFactoryImpl messageFactoryImpl = (MessageFactoryImpl)WLMessageFactory.getInstance().getMessageFactory(bl);
        try {
            return messageFactoryImpl.createMessage(mimeHeaders, inputStream, true, false);
        }
        catch (IOException iOException) {
            throw new SOAPException((Throwable)iOException);
        }
    }

    public static SOAPMessage createMessageWithStreamingAttachments(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPException {
        return WLMessageFactory.createMessageWithStreamingAttachments(mimeHeaders, inputStream, false);
    }
}

