/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import weblogic.application.ApplicationFileManager;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.JarFileObject;
import weblogic.utils.jars.VirtualJarFile;

public abstract class WebServiceJarFile {
    protected static final boolean debug = System.getProperty(WebServiceJarFile.DEBUG_PROPERTY()) != null;
    private File exploded;
    private VirtualJarFile vJarFile;
    protected ApplicationFileManager appFileManager;
    protected File dest;

    protected static String DEBUG_PROPERTY() {
        return "wsjar.debug";
    }

    public WebServiceJarFile(File file, File file2) throws IOException {
        this.dest = file2;
        if (file2.exists()) {
            if (debug) {
                System.out.println("Extracting previous contents...");
            }
            if (file2.isDirectory()) {
                this.exploded = file2;
            } else {
                this.createExploded(file, file2);
                JarFileObject jarFileObject = new JarFileObject(file2);
                jarFileObject.extract(this.exploded);
            }
        } else {
            this.createExploded(file, file2);
            if (file2.getParentFile() != null) {
                file2.getParentFile().mkdirs();
            }
        }
        this.appFileManager = ApplicationFileManager.newInstance(this.exploded);
        this.vJarFile = this.appFileManager.getVirtualJarFile();
        if (debug) {
            System.out.println("*** Creating " + this.toString());
        }
    }

    public void remove() throws IOException {
        if (debug) {
            System.out.println("*** Removing " + this.toString());
        }
        this.vJarFile.close();
        if (this.exploded != this.dest && this.exploded != null) {
            FileUtils.remove((File)this.exploded);
        }
    }

    public void save() throws IOException {
        if (this.dest == this.exploded) {
            return;
        }
        JarFileObject jarFileObject = JarFileObject.makeJar((String)this.dest.getCanonicalPath(), (File)this.exploded);
        jarFileObject.save();
    }

    public File getExploded() {
        return this.exploded;
    }

    public VirtualJarFile getVirtualJarFile() {
        return this.vJarFile;
    }

    public File getDestJar() {
        return this.dest;
    }

    public static String stripDriveLetter(String string) {
        String string2 = string.trim();
        if (string == null || string.length() <= 1 || string2.charAt(1) != ':') {
            return string2;
        }
        return string2.substring(2);
    }

    private void createExploded(File file, File file2) throws IOException {
        Random random = new Random(System.identityHashCode(file2));
        do {
            this.exploded = new File(file, file2.getName() + random.nextInt());
        } while (this.exploded.exists());
        this.exploded.mkdirs();
    }

    public String toString() {
        return this.dest + ":" + this.exploded;
    }
}

