/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.staxb.buildtime.BindingCompiler;
import com.bea.xbean.xb.xsdschema.ImportDocument;
import com.bea.xbean.xb.xsdschema.IncludeDocument;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xbean.xb.xsdschema.TopLevelComplexType;
import com.bea.xbean.xb.xsdschema.TopLevelElement;
import com.bea.xbean.xb.xsdschema.TopLevelSimpleType;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlObject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.XBeanUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlSchemaImport;
import weblogic.wsee.wsdl.WsdlTypes;
import weblogic.wsee.wsdl.internal.WsdlSchemaImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBeanSchemaProcessor {
    private static final boolean verbose = Verbose.isVerbose(XBeanSchemaProcessor.class);
    private final BindingCompiler compiler;
    private final ClassLoader xmlObjectClassLoader;
    private final Set<String> processedXsdPaths = new HashSet<String>();
    private final Set<SchemaDocument> globalCandidateSet = new HashSet<SchemaDocument>();
    private final Set<SchemaDocument> globalResultSet = new HashSet<SchemaDocument>();
    private final Set<SchemaDocument> globalIncludedSchemaDocuments = new HashSet<SchemaDocument>();

    public XBeanSchemaProcessor(BindingCompiler bindingCompiler, ClassLoader classLoader) {
        this.compiler = bindingCompiler;
        this.xmlObjectClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getNamespaces(SchemaDocument schemaDocument) {
        HashMap hashMap = new HashMap();
        XmlCursor xmlCursor = schemaDocument.getSchema().newCursor();
        try {
            xmlCursor.getAllNamespaces(hashMap);
        }
        finally {
            xmlCursor.dispose();
        }
        return hashMap;
    }

    private void processAllSchemas(SchemaDocument schemaDocument, List<SchemaDocument> list) {
        Map map = this.getNamespaces(schemaDocument);
        if (verbose) {
            Verbose.log(" +++ all Namespaces on primary : " + map);
        }
        for (SchemaDocument schemaDocument2 : list) {
            if (schemaDocument2 == schemaDocument) continue;
            String string = this.getXsdPathForSchemaDocument(schemaDocument2);
            this.includeSchema(schemaDocument2, map, string);
        }
    }

    private String getXsdPathForSchemaDocument(SchemaDocument schemaDocument) {
        String string = schemaDocument.documentProperties().getSourceName();
        try {
            URL uRL = new URL(string);
            string = new File(uRL.getPath()).getName();
        }
        catch (MalformedURLException malformedURLException) {
            string = new File(string).getName();
        }
        return string;
    }

    private void includeSchema(SchemaDocument schemaDocument, Map map, String string) {
        Map map2 = this.buildPrefixMap(map, schemaDocument);
        if (verbose) {
            Verbose.log(" +++ prefixMap : " + map2);
        }
        if (verbose) {
            Verbose.log(" compiler.includeSchema for schema at '" + string + "'");
        }
        XBeanSchemaProcessor.stripIncludesAndStripSchemaLocFromImports(schemaDocument);
        this.compiler.includeSchema(schemaDocument, string, map2);
    }

    private static void stripIncludesAndStripSchemaLocFromImports(SchemaDocument schemaDocument) {
        int n;
        for (n = schemaDocument.getSchema().sizeOfIncludeArray() - 1; n >= 0; --n) {
            schemaDocument.getSchema().removeInclude(n);
        }
        for (n = schemaDocument.getSchema().sizeOfImportArray() - 1; n >= 0; --n) {
            ImportDocument.Import import_ = schemaDocument.getSchema().getImportArray(n);
            if (!import_.isSetSchemaLocation()) continue;
            import_.unsetSchemaLocation();
        }
    }

    private Map buildPrefixMap(Map map, SchemaDocument schemaDocument) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (!ObjectUtil.equals(schemaDocument.getSchema().getTargetNamespace(), string2)) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private static XBeanInfo getXBeanInfo(Class clazz) {
        if (XmlObject.class.isAssignableFrom(clazz)) {
            SchemaType schemaType = XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz);
            QName qName = (schemaType = XBeanUtil.transformST(schemaType)).isDocumentType() ? schemaType.getDocumentElementName() : schemaType.getName();
            String string = new File(schemaType.getSourceName()).getName();
            return new XBeanInfo(string, qName);
        }
        if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
            org.apache.xmlbeans.SchemaType schemaType = XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz);
            QName qName = (schemaType = XBeanUtil.transformST(schemaType)).isDocumentType() ? schemaType.getDocumentElementName() : schemaType.getName();
            String string = new File(schemaType.getSourceName()).getName();
            return new XBeanInfo(string, qName);
        }
        throw new IllegalArgumentException(clazz.getName() + " must be either a bea xml bean or an apache xml bean");
    }

    private List<SchemaDocument> getSchemaDocumentsFor(String string) throws WsdlException {
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>();
        try {
            WsdlSchema wsdlSchema = WsdlSchemaImpl.parse(string);
            XBeanSchemaProcessor.addSchemas(wsdlSchema, arrayList);
        }
        catch (WsdlException wsdlException) {
            WsdlDefinitions wsdlDefinitions = WsdlFactory.getInstance().parse(string);
            WsdlTypes wsdlTypes = wsdlDefinitions.getTypes();
            SchemaDocument[] schemaDocumentArray = wsdlTypes.getSchemaArray();
            String string2 = new File(wsdlDefinitions.getWsdlLocation()).getName();
            this.processedXsdPaths.add(string2);
            for (SchemaDocument schemaDocument : schemaDocumentArray) {
                arrayList.add(schemaDocument);
                String string3 = this.getXsdPathForSchemaDocument(schemaDocument);
                String string4 = this.getAbsolutePathForSchemaDocument(schemaDocument);
                if (string2.equals(string3)) {
                    this.globalCandidateSet.add(schemaDocument);
                    continue;
                }
                if (this.processedXsdPaths.contains(string4)) continue;
                this.processedXsdPaths.add(string4);
                this.globalCandidateSet.add(schemaDocument);
            }
        }
        return arrayList;
    }

    private static void addSchemas(WsdlSchema wsdlSchema, List<SchemaDocument> list) {
        list.add(wsdlSchema.getSchema());
        for (WsdlSchemaImport wsdlSchemaImport : wsdlSchema.getImports()) {
            XBeanSchemaProcessor.addSchemas(wsdlSchemaImport.getSchema(), list);
        }
    }

    private List<SchemaDocument> getBeaSchemaDocumentsForXmlBean(Class clazz) {
        List<Object> list = new ArrayList();
        String string = XBeanUtil.getXsdPathForXmlBean(this.xmlObjectClassLoader, clazz, false);
        if (string == null) {
            Verbose.log(" WARNING !  could not getXsdPath for XmlBean '" + clazz.getName() + "'");
            return list;
        }
        URL uRL = this.xmlObjectClassLoader.getResource(string);
        try {
            list = uRL != null ? this.getSchemaDocumentsFor(uRL.toString()) : this.getSchemaDocumentsFor(string);
        }
        catch (WsdlException wsdlException) {
            String string2 = string;
            string = XBeanUtil.getXsdPathForXmlBean(this.xmlObjectClassLoader, clazz, true);
            String string3 = " WARNING !  could not get WsdlSchema from xsdPath '" + string2 + "'   try qualified xsdPath path '" + string + "'";
            uRL = this.xmlObjectClassLoader.getResource(string);
            try {
                list = uRL != null ? this.getSchemaDocumentsFor(uRL.toString()) : this.getSchemaDocumentsFor(string);
            }
            catch (WsdlException wsdlException2) {
                Verbose.log(string3 + " WARNING !  could not get WsdlSchema from " + "xsdPath '" + string + "'");
            }
        }
        if (verbose) {
            Verbose.log(" +++ found schemas are : " + list);
        }
        if (list.isEmpty()) {
            Verbose.log(" WARNING !  could not get SchemaDocument for xmlBean '" + clazz.getName() + "'");
            throw new IllegalArgumentException("null xsd");
        }
        return list;
    }

    private SchemaDocument findRelevantSchemaDocument(List<SchemaDocument> list, Class clazz) {
        SchemaDocument schemaDocument = null;
        if (list.size() == 1) {
            schemaDocument = list.get(0);
        } else if (list.size() > 1) {
            QName qName = XBeanUtil.getQNameFromXmlBean(this.xmlObjectClassLoader, clazz.getName());
            if (qName != null) {
                List<SchemaDocument> list2;
                if (verbose) {
                    Verbose.log(" +++ QName for '" + clazz + "' is " + qName);
                    Verbose.log(" +++ NamespaceURI from QName : " + qName.getNamespaceURI());
                    Verbose.log(" +++ localPart of QName : " + qName.getLocalPart());
                }
                if ((list2 = XBeanSchemaProcessor.findSchemaDocumentsForNamespace(list, qName.getNamespaceURI())).size() == 1) {
                    schemaDocument = list2.get(0);
                } else {
                    block0: for (SchemaDocument schemaDocument2 : list2) {
                        TopLevelSimpleType[] topLevelSimpleTypeArray;
                        Object object;
                        SchemaDocument.Schema schema = schemaDocument2.getSchema();
                        TopLevelComplexType[] topLevelComplexTypeArray = schema.getComplexTypeArray();
                        if (topLevelComplexTypeArray != null && topLevelComplexTypeArray.length != 0) {
                            for (int i = 0; i < topLevelComplexTypeArray.length; ++i) {
                                object = topLevelComplexTypeArray[i].getName();
                                if (verbose) {
                                    Verbose.log(" +++ ComplexType name : " + (String)object);
                                }
                                if (!((String)object).equals(qName.getLocalPart())) continue;
                                schemaDocument = schemaDocument2;
                                break;
                            }
                        }
                        if ((topLevelSimpleTypeArray = schema.getSimpleTypeArray()) != null && topLevelSimpleTypeArray.length != 0) {
                            for (int i = 0; i < topLevelSimpleTypeArray.length; ++i) {
                                String string = topLevelSimpleTypeArray[i].getName();
                                if (verbose) {
                                    Verbose.log(" +++ SimpleType name : " + string);
                                }
                                if (!string.equals(qName.getLocalPart())) continue;
                                schemaDocument = schemaDocument2;
                                break;
                            }
                        }
                        if ((object = schema.getElementArray()) == null || ((TopLevelElement[])object).length == 0) continue;
                        for (int i = 0; i < ((TopLevelElement[])object).length; ++i) {
                            String string = object[i].getName();
                            if (verbose) {
                                Verbose.log(" +++ Element name : " + string);
                            }
                            if (!string.equals(qName.getLocalPart())) continue;
                            schemaDocument = schemaDocument2;
                            continue block0;
                        }
                    }
                }
            } else {
                Verbose.log(" WARNING : Could not find QName for xml bean '" + clazz.getName());
            }
        }
        if (schemaDocument == null) {
            Verbose.log(" WARNING : Could not find SchemaDocument for " + clazz.getName());
        }
        return schemaDocument;
    }

    private static List<SchemaDocument> findSchemaDocumentsForNamespace(List<SchemaDocument> list, String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            bl = true;
        }
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>();
        for (SchemaDocument schemaDocument : list) {
            SchemaDocument.Schema schema = schemaDocument.getSchema();
            String string2 = schema.getTargetNamespace();
            if (verbose) {
                Verbose.log(" +++ targetnamespace : " + string2);
            }
            if (!ObjectUtil.equals(string2, string) && (!bl || string2 != null)) continue;
            arrayList.add(schemaDocument);
        }
        if (verbose) {
            Verbose.log(" +++ found SchemaDocuments for namespace '" + string + "' are : " + arrayList);
        }
        return arrayList;
    }

    public void includeAllRelevantSchemas(Set set) {
        Class clazz;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (Object object : set) {
            String object2 = XBeanUtil.getSchemaTypeSourceName(this.xmlObjectClassLoader, (String)object);
            if (object2 == null) continue;
            if (verbose) {
                Verbose.log("\n includeSchema  javaClassName='" + (String)object + "'");
            }
            if ((clazz = XBeanUtil.loadXmlBean(this.xmlObjectClassLoader, (String)object)) == null) {
                throw new IllegalArgumentException((String)object);
            }
            arrayList.add(clazz);
            XBeanInfo xBeanInfo = XBeanSchemaProcessor.getXBeanInfo(clazz);
            if (this.processedXsdPaths.contains(xBeanInfo.getXsdPath())) continue;
            List<SchemaDocument> list = this.getBeaSchemaDocumentsForXmlBean(clazz);
            for (SchemaDocument schemaDocument : list) {
                String string = this.getAbsolutePathForSchemaDocument(schemaDocument);
                if (this.processedXsdPaths.contains(string)) continue;
                this.globalCandidateSet.add(schemaDocument);
                this.processedXsdPaths.add(string);
            }
        }
        if (verbose) {
            Verbose.log("\n globalCandidateSet=" + this.globalCandidateSet);
        }
        for (Class clazz2 : arrayList) {
            clazz = this.findRelevantSchemaDocument(Arrays.asList(this.globalCandidateSet.toArray(new SchemaDocument[0])), clazz2);
            if (clazz == null) {
                this.compiler.logWarning(" WARNING: Could not find SchemaDocument for " + clazz2.getName());
                continue;
            }
            this.addRelevantSchemas((SchemaDocument)clazz, clazz2);
        }
        if (verbose) {
            Verbose.log("\n globalResultSet=" + this.globalResultSet);
        }
    }

    private void insertNamespaces(XmlCursor xmlCursor, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            try {
                xmlCursor.push();
                xmlCursor.toNextToken();
                xmlCursor.insertNamespace((String)entry.getKey(), (String)entry.getValue());
                xmlCursor.pop();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelevantSchemas(SchemaDocument schemaDocument, Class clazz) {
        if (schemaDocument == null) {
            return;
        }
        if (!this.contains(this.globalResultSet, schemaDocument)) {
            HashSet<SchemaDocument> hashSet = new HashSet<SchemaDocument>();
            XBeanInfo xBeanInfo = XBeanSchemaProcessor.getXBeanInfo(clazz);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(xBeanInfo.getQName().getNamespaceURI(), xBeanInfo.getQName().getPrefix());
            if (verbose) {
                Verbose.log(" compiler.includeSchema for qName='" + xBeanInfo.getQName() + "' and schema at '" + xBeanInfo.getXsdPath() + "'");
            }
            this.recursiveAddRelevantSchemas(schemaDocument, this.getNamespaces(schemaDocument), hashSet, this.globalIncludedSchemaDocuments);
            if (hashSet.isEmpty()) {
                if (!this.contains(this.globalResultSet, schemaDocument)) {
                    this.globalResultSet.add(schemaDocument);
                    this.includeSchema(schemaDocument, hashMap, xBeanInfo.getXsdPath());
                }
            } else {
                Map map = this.getNamespaces(schemaDocument);
                XmlCursor xmlCursor = schemaDocument.getSchema().newCursor();
                String string = schemaDocument.getSchema().getTargetNamespace();
                try {
                    xmlCursor.toEndToken();
                    for (SchemaDocument schemaDocument2 : hashSet) {
                        if (ObjectUtil.equals(string, schemaDocument2.getSchema().getTargetNamespace()) || schemaDocument2.getSchema().getTargetNamespace() == null) {
                            XmlCursor xmlCursor2;
                            HashMap<String, String> hashMap2 = new HashMap<String, String>();
                            if (schemaDocument2.getSchema().getTargetNamespace() == null) {
                                if (!map.containsKey("")) {
                                    xmlCursor2 = schemaDocument.getSchema().newCursor();
                                    xmlCursor2.toNextToken();
                                    xmlCursor2.insertNamespace("", string);
                                    xmlCursor2.dispose();
                                    map.put("", string);
                                } else if (!ObjectUtil.equals((String)map.get(""), string)) {
                                    hashMap2.put("", string);
                                }
                            }
                            schemaDocument.getSchema().setImportArray(schemaDocument2.getSchema().getImportArray());
                            for (int i = schemaDocument2.getSchema().sizeOfImportArray() - 1; i >= 0; --i) {
                                schemaDocument2.getSchema().removeImport(i);
                            }
                            xmlCursor2 = schemaDocument2.getSchema().newCursor();
                            HashMap hashMap3 = new HashMap();
                            try {
                                xmlCursor2.getAllNamespaces(hashMap3);
                                if (!hashMap3.isEmpty()) {
                                    XmlCursor xmlCursor3 = schemaDocument.getSchema().newCursor();
                                    xmlCursor3.toNextToken();
                                    for (Map.Entry entry : hashMap3.entrySet()) {
                                        String string2 = (String)entry.getKey();
                                        String string3 = (String)entry.getValue();
                                        if (!map.containsKey(string2)) {
                                            xmlCursor3.insertNamespace(string2, string3);
                                            map.put(string2, string3);
                                            continue;
                                        }
                                        if (ObjectUtil.equals((String)map.get(string2), string3)) continue;
                                        hashMap2.put(string2, string3);
                                    }
                                    xmlCursor3.dispose();
                                }
                                if (hashMap2.isEmpty()) {
                                    xmlCursor2.copyXmlContents(xmlCursor);
                                    continue;
                                }
                                if (verbose) {
                                    Verbose.log(" +++ conflictedNamespaces: " + hashMap2);
                                }
                                xmlCursor2.toChild("http://www.w3.org/2001/XMLSchema", "schema");
                                if (!xmlCursor2.toFirstChild()) continue;
                                this.insertNamespaces(xmlCursor2, hashMap2);
                                xmlCursor2.copyXml(xmlCursor);
                                while (xmlCursor2.toNextSibling()) {
                                    this.insertNamespaces(xmlCursor2, hashMap2);
                                    xmlCursor2.copyXml(xmlCursor);
                                }
                                continue;
                            }
                            finally {
                                xmlCursor2.dispose();
                                continue;
                            }
                        }
                        Verbose.log(" WARNING !  Included schema has a target namespace \"" + schemaDocument2.getSchema().getTargetNamespace() + "\" that does not match the including namespace \"" + string + "\" ");
                        throw new IllegalArgumentException("illegal include: included schema in wrong namespace.");
                    }
                }
                finally {
                    xmlCursor.dispose();
                }
                this.includeSchema(schemaDocument, hashMap, xBeanInfo.getXsdPath());
                this.globalResultSet.add(schemaDocument);
            }
        }
    }

    private void recursiveAddRelevantSchemas(SchemaDocument schemaDocument, Map map, Set<SchemaDocument> set, Set<SchemaDocument> set2) {
        for (IncludeDocument.Include include : schemaDocument.getSchema().getIncludeArray()) {
            for (SchemaDocument schemaDocument2 : this.globalCandidateSet) {
                if (this.contains(this.globalResultSet, schemaDocument2) || this.contains(set2, schemaDocument2) || this.contains(set, schemaDocument2) || !ObjectUtil.equals(new File(include.getSchemaLocation()).getName(), this.getXsdPathForSchemaDocument(schemaDocument2)) || !ObjectUtil.equals(schemaDocument.getSchema().getTargetNamespace(), schemaDocument2.getSchema().getTargetNamespace()) && schemaDocument2.getSchema().getTargetNamespace() != null) continue;
                this.globalResultSet.add(schemaDocument2);
                set2.add(schemaDocument2);
                set.add(schemaDocument2);
                this.recursiveAddRelevantSchemas(schemaDocument2, map, set, set2);
            }
        }
        for (IncludeDocument.Include include : schemaDocument.getSchema().getImportArray()) {
            for (SchemaDocument schemaDocument2 : this.globalCandidateSet) {
                if (this.contains(this.globalResultSet, schemaDocument2) || !ObjectUtil.equals(include.getNamespace(), schemaDocument2.getSchema().getTargetNamespace())) continue;
                this.globalResultSet.add(schemaDocument2);
                this.includeSchema(schemaDocument2, map, this.getXsdPathForSchemaDocument(schemaDocument2));
                this.recursiveAddRelevantSchemas(schemaDocument2, map, set, set2);
            }
        }
    }

    private String getAbsolutePathForSchemaDocument(SchemaDocument schemaDocument) {
        String string = schemaDocument.documentProperties().getSourceName();
        try {
            return new URL(string).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            try {
                return new URL("file:" + string).toExternalForm();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }

    private boolean contains(Set<SchemaDocument> set, SchemaDocument schemaDocument) {
        Iterator<SchemaDocument> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!ObjectUtil.equals(iterator.next().toString(), schemaDocument.toString())) continue;
            return true;
        }
        return false;
    }

    private static class XBeanInfo {
        private final String xsdPath;
        private final QName qName;

        XBeanInfo(String string, QName qName) {
            this.xsdPath = string;
            this.qName = qName;
        }

        private String getXsdPath() {
            return this.xsdPath;
        }

        private QName getQName() {
            return this.qName;
        }
    }
}

