/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util;

import com.bea.util.jam.JClass;
import com.bea.xbean.schema.SchemaTypeImpl;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlObject;
import java.lang.reflect.Field;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.Util;

public class XBeanUtil {
    private static final boolean verbose = Verbose.isVerbose(XBeanUtil.class);
    private static final String XMLOBJECT_SCHEMATYPE_FIELD = "type";
    private static final String APACHE_XSDPATH_PREFIX = "schemaorg_apache_xmlbeans";
    private static final String BEA_XSDPATH_PREFIX = "schemacom_bea_xml";
    public static final String SOAPFAULTS_CONTAIN_XMLBEANS = "com.bea.SOAPFAULTS_CONTAIN_XMLBEANS";

    private XBeanUtil() {
    }

    public static Element createXMLFragmentFromElement(Element element) {
        Element element2;
        Node node;
        if (element == null) {
            return null;
        }
        Element element3 = element.getOwnerDocument().createElement("xml-fragment");
        if (element.hasChildNodes() && (node = (element2 = (Element)element.cloneNode(true)).getFirstChild()) != null) {
            Node node2 = node.getNextSibling();
            element3.appendChild(node);
            while (node2 != null) {
                node = node2;
                node2 = node.getNextSibling();
                element3.appendChild(node);
            }
        }
        if (verbose) {
            Verbose.log("created xmlFragment \n" + Util.printNode(element3));
        }
        return element3;
    }

    public static boolean isXmlBean(JClass jClass) {
        JClass jClass2 = jClass.forName("org.apache.xmlbeans.XmlObject");
        if (!jClass2.isUnresolvedType() && jClass2.isAssignableFrom(jClass)) {
            return true;
        }
        jClass2 = jClass.getClassLoader().loadClass(XmlObject.class.getName());
        if (jClass2.isAssignableFrom(jClass)) {
            Verbose.log("WARNING: Detected use of an XMLBean derived from com.bea.xml.XmlObject: '" + jClass.getQualifiedName() + "'.  " + "Use of com.bea.xml XMLBeans is deprecated.  " + "Apache XMLBeans should be used instead.");
            return true;
        }
        return false;
    }

    public static boolean isXmlBean(Class clazz) {
        try {
            Class<?> clazz2 = Class.forName("org.apache.xmlbeans.XmlObject");
            if (clazz2.isAssignableFrom(clazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return XmlObject.class.isAssignableFrom(clazz);
    }

    public static QName getQNameFromXmlBean(ClassLoader classLoader, String string) {
        QName qName = null;
        Class clazz = XBeanUtil.loadXmlBean(classLoader, string);
        if (clazz != null) {
            if (XmlObject.class.isAssignableFrom(clazz)) {
                SchemaType schemaType = XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz);
                if (schemaType == null) {
                    return null;
                }
                qName = schemaType.isDocumentType() ? schemaType.getDocumentElementName() : schemaType.getName();
            } else if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
                org.apache.xmlbeans.SchemaType schemaType = XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz);
                if (schemaType == null) {
                    return null;
                }
                qName = schemaType.isDocumentType() ? schemaType.getDocumentElementName() : schemaType.getName();
            }
        }
        return qName;
    }

    public static boolean xmlBeanIsDocumentType(ClassLoader classLoader, String string) {
        return XBeanUtil.xmlBeanIsDocumentType(classLoader, string, false);
    }

    public static boolean xmlBeanIsDocumentType(ClassLoader classLoader, String string, boolean bl) throws RuntimeException {
        Class clazz = XBeanUtil.loadXmlBean(classLoader, string, true);
        if (clazz == null) {
            return false;
        }
        return XBeanUtil.xmlBeanIsDocumentType(clazz, bl);
    }

    public static boolean xmlBeanIsDocumentType(Class clazz) {
        return XBeanUtil.xmlBeanIsDocumentType(clazz, false);
    }

    public static SchemaType transformST(SchemaType schemaType) {
        if (schemaType == null) {
            return null;
        }
        if (schemaType.toString().startsWith("E=") && schemaType instanceof SchemaTypeImpl) {
            ((SchemaTypeImpl)schemaType).setDocumentType(true);
        }
        return schemaType;
    }

    public static org.apache.xmlbeans.SchemaType transformST(org.apache.xmlbeans.SchemaType schemaType) {
        if (schemaType == null) {
            return null;
        }
        if (schemaType.toString().startsWith("E=") && schemaType instanceof org.apache.xmlbeans.impl.schema.SchemaTypeImpl) {
            ((org.apache.xmlbeans.impl.schema.SchemaTypeImpl)schemaType).setDocumentType(true);
        }
        return schemaType;
    }

    public static boolean xmlBeanIsDocumentType(Class clazz, boolean bl) throws RuntimeException {
        if (clazz != null) {
            if (XmlObject.class.isAssignableFrom(clazz)) {
                SchemaType schemaType = XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz, bl);
                if (schemaType == null) {
                    return false;
                }
                return schemaType.isDocumentType();
            }
            if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
                org.apache.xmlbeans.SchemaType schemaType = XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz, bl);
                if (schemaType == null) {
                    return false;
                }
                return schemaType.isDocumentType();
            }
        }
        return false;
    }

    public static boolean isArrayOfXmlBean(JClass jClass) {
        if (jClass == null) {
            return false;
        }
        if (!jClass.isArrayType()) {
            return false;
        }
        JClass jClass2 = jClass.getArrayComponentType();
        if (jClass2 == null) {
            return false;
        }
        return XBeanUtil.isXmlBean(jClass2);
    }

    static Class loadXmlBean(ClassLoader classLoader, String string) {
        return XBeanUtil.loadXmlBean(classLoader, string, false);
    }

    static Class loadXmlBean(ClassLoader classLoader, String string, boolean bl) throws RuntimeException {
        Class<?> clazz;
        block3: {
            clazz = null;
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    throw new RuntimeException(classNotFoundException.toString(), classNotFoundException);
                }
                if (!verbose) break block3;
                Verbose.log((Object)("Unable to load " + string + " as an XmlBean"), classNotFoundException);
            }
        }
        return clazz;
    }

    public static boolean isXmlBeanSchemaCompiled(ClassLoader classLoader, String string) {
        Class clazz = XBeanUtil.loadXmlBean(classLoader, string);
        if (clazz == null) {
            return false;
        }
        SchemaType schemaType = null;
        if (XmlObject.class.isAssignableFrom(clazz)) {
            schemaType = XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz);
        } else if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
            schemaType = XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz);
        }
        return schemaType != null;
    }

    public static String getSchemaTypeSourceName(ClassLoader classLoader, String string) {
        Class clazz = XBeanUtil.loadXmlBean(classLoader, string);
        if (clazz == null) {
            return null;
        }
        return XBeanUtil.getXsdPathForXmlBean(classLoader, clazz, false);
    }

    public static boolean isBuiltInTypeXmlBean(ClassLoader classLoader, String string) {
        Class clazz = XBeanUtil.loadXmlBean(classLoader, string);
        if (clazz == null) {
            Verbose.log("WARNING !  could NOT load xmlBean '" + string + "'");
            return true;
        }
        return XBeanUtil.isBuiltInTypeXmlBean(clazz);
    }

    public static boolean isBuiltInTypeXmlBean(Class clazz) {
        if (clazz == null) {
            Verbose.log("WARNING !  cannot check is Class is BuiltIn Type XmlBean.  Input class is NULL !");
            return true;
        }
        boolean bl = false;
        if (XmlObject.class.isAssignableFrom(clazz)) {
            SchemaType schemaType = XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz);
            bl = schemaType.isBuiltinType();
        } else if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
            org.apache.xmlbeans.SchemaType schemaType = XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz);
            bl = schemaType.isBuiltinType();
        }
        return bl;
    }

    static String getXsdPathForXmlBean(ClassLoader classLoader, Class clazz, boolean bl) {
        String string = null;
        if (verbose) {
            Verbose.log(" +++ getXsdPathForXmlBean('" + classLoader + "', '" + clazz + "', '" + bl + "')...");
        }
        if (clazz == null) {
            if (verbose) {
                Verbose.log(" Returning null...");
            }
            return string;
        }
        if (XmlObject.class.isAssignableFrom(clazz)) {
            if (verbose) {
                Verbose.log(" is bea-xml-bean...");
            }
            SchemaType schemaType = XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz);
            string = schemaType.getSourceName();
            if (bl && string != null) {
                string = "schemacom_bea_xml/src/" + string;
            }
        } else if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
            if (verbose) {
                Verbose.log(" is apache-xml-bean...");
            }
            org.apache.xmlbeans.SchemaType schemaType = XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz);
            if (verbose) {
                Verbose.log(" +++ SchemaType : " + schemaType);
            }
            string = schemaType.getSourceName();
            if (verbose) {
                Verbose.log(" +++ xsdPath from SchemaType : " + string);
            }
            if (bl && string != null) {
                string = "schemaorg_apache_xmlbeans/src/" + string;
            }
        }
        if (verbose) {
            Verbose.log(" +++ for xmlBeanClass '" + clazz.getName() + "', xsdPath is '" + string + "'");
        }
        return string;
    }

    static org.apache.xmlbeans.SchemaType getApacheSchemaTypeForApacheXmlBean(Class clazz) {
        return XBeanUtil.getApacheSchemaTypeForApacheXmlBean(clazz, false);
    }

    static org.apache.xmlbeans.SchemaType getApacheSchemaTypeForApacheXmlBean(Class clazz, boolean bl) throws RuntimeException {
        org.apache.xmlbeans.SchemaType schemaType = null;
        if (clazz == null) {
            Verbose.log("  WARNING !  getApacheSchemaTypeForApacheXmlBean called with NULL xmlBeanClass ! ");
            return schemaType;
        }
        assert (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz));
        if (org.apache.xmlbeans.XmlObject.class.isAssignableFrom(clazz)) {
            Field field;
            try {
                field = clazz.getField(XMLOBJECT_SCHEMATYPE_FIELD);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (bl) {
                    throw new RuntimeException(noSuchFieldException.toString(), noSuchFieldException);
                }
                noSuchFieldException.printStackTrace();
                return schemaType;
            }
            if (field != null) {
                try {
                    schemaType = (org.apache.xmlbeans.SchemaType)field.get(null);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    if (bl) {
                        throw new RuntimeException(exceptionInInitializerError.toString(), exceptionInInitializerError);
                    }
                    return schemaType;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (bl) {
                        throw new RuntimeException(illegalAccessException.toString(), illegalAccessException);
                    }
                    return schemaType;
                }
            }
        }
        return schemaType;
    }

    static SchemaType getBeaSchemaTypeForBeaXmlBean(Class clazz) {
        return XBeanUtil.getBeaSchemaTypeForBeaXmlBean(clazz, false);
    }

    static SchemaType getBeaSchemaTypeForBeaXmlBean(Class clazz, boolean bl) {
        SchemaType schemaType = null;
        if (clazz == null) {
            Verbose.log("  WARNING !  getBeaSchemaTypeForBeaXmlBean called with NULL xmlBeanClass ! ");
            return schemaType;
        }
        assert (XmlObject.class.isAssignableFrom(clazz));
        if (XmlObject.class.isAssignableFrom(clazz)) {
            Field field;
            try {
                field = clazz.getField(XMLOBJECT_SCHEMATYPE_FIELD);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (bl) {
                    throw new RuntimeException(noSuchFieldException.toString(), noSuchFieldException);
                }
                noSuchFieldException.printStackTrace();
                return schemaType;
            }
            if (field != null) {
                try {
                    schemaType = (SchemaType)field.get(null);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    if (bl) {
                        throw new RuntimeException(exceptionInInitializerError.toString(), exceptionInInitializerError);
                    }
                    return schemaType;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (bl) {
                        throw new RuntimeException(illegalAccessException.toString(), illegalAccessException);
                    }
                    illegalAccessException.printStackTrace();
                    return schemaType;
                }
            }
        }
        return schemaType;
    }
}

