/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import weblogic.wsee.util.bytecode.ConstantPool;

public class AttributeInfo {
    private static HashMap attInfos = new HashMap();
    private AttInfo attInfo;
    private short nameIndex;
    private ArrayList parameterNames;

    public AttributeInfo() {
        this(null);
    }

    public AttributeInfo(ArrayList arrayList) {
        this.parameterNames = arrayList;
    }

    private void addParameterName(String string) {
        if (this.parameterNames != null) {
            this.parameterNames.add(string);
        }
    }

    public String toString() {
        return "" + this.attInfo;
    }

    private AttInfo getAttInfoInstance(Class clazz) throws IOException {
        try {
            Constructor constructor = clazz.getConstructor(AttributeInfo.class);
            return (AttInfo)constructor.newInstance(this);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("new failed: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("access failed: " + illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("constructor not found: " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("target not found: " + invocationTargetException.getMessage());
        }
    }

    public String getName() {
        return this.attInfo.getName();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.nameIndex);
        this.attInfo.write(dataOutput);
    }

    public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this.nameIndex = dataInput.readShort();
        String string = constantPool.getValue(this.nameIndex);
        this.attInfo = new DefaultAttInfo();
        this.attInfo.setName(string);
        this.attInfo.read(dataInput, constantPool);
    }

    public byte[] getAttributeBytes() {
        if (this.attInfo == null || !(this.attInfo instanceof DefaultAttInfo)) {
            throw new RuntimeException("attInfo error: " + this.attInfo);
        }
        return ((DefaultAttInfo)this.attInfo).getBytes();
    }

    public void setCustomAttribute(String string, short s, byte[] byArray) {
        this.nameIndex = s;
        this.attInfo = new DefaultAttInfo();
        this.attInfo.setName(string);
        ((DefaultAttInfo)this.attInfo).setBytes(byArray);
    }

    static {
        attInfos.put("SourceFile", SourceFile.class);
        attInfos.put("ConstantValue", ConstantValue.class);
        attInfos.put("Code", Code.class);
        attInfos.put("Exceptions", Exceptions.class);
        attInfos.put("LineNumberTable", LineNumberTable.class);
        attInfos.put("LocalVariableTable", LocalVariableTable.class);
    }

    public class LocalVariableTable
    extends AttInfo {
        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n = dataInput.readInt();
            int n2 = dataInput.readShort();
            for (int i = 0; i < n2; ++i) {
                short s = dataInput.readShort();
                short s2 = dataInput.readShort();
                String string = constantPool.getValue(dataInput.readShort());
                if (s == 0) {
                    AttributeInfo.this.addParameterName(string);
                }
                String string2 = constantPool.getValue(dataInput.readShort());
                short s3 = dataInput.readShort();
            }
        }

        public void write(DataOutput dataOutput) throws IOException {
        }
    }

    public class LineNumberTable
    extends AttInfo {
        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n = dataInput.readInt();
            int n2 = dataInput.readShort();
            for (int i = 0; i < n2; ++i) {
                short s = dataInput.readShort();
                short s2 = dataInput.readShort();
            }
        }

        public void write(DataOutput dataOutput) throws IOException {
        }
    }

    public class Exceptions
    extends AttInfo {
        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n = dataInput.readInt();
            int n2 = dataInput.readShort();
            for (int i = 0; i < n2; ++i) {
                String string = constantPool.getValue(dataInput.readShort());
            }
        }

        public void write(DataOutput dataOutput) throws IOException {
        }
    }

    public class Code
    extends AttInfo {
        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n;
            int n2;
            int n3 = dataInput.readInt();
            short s = dataInput.readShort();
            short s2 = dataInput.readShort();
            int n4 = dataInput.readInt();
            byte[] byArray = new byte[n4];
            dataInput.readFully(byArray);
            int n5 = dataInput.readShort();
            for (n2 = 0; n2 < n5; ++n2) {
                n = dataInput.readShort();
                short s3 = dataInput.readShort();
                short s4 = dataInput.readShort();
                short s5 = dataInput.readShort();
            }
            n2 = dataInput.readShort();
            for (n = 0; n < n2; ++n) {
                AttributeInfo attributeInfo = new AttributeInfo(AttributeInfo.this.parameterNames);
                attributeInfo.read(dataInput, constantPool);
            }
        }

        public void write(DataOutput dataOutput) throws IOException {
        }
    }

    public class ConstantValue
    extends AttInfo {
        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n = dataInput.readInt();
            String string = constantPool.getValue(dataInput.readShort());
        }

        public void write(DataOutput dataOutput) throws IOException {
        }
    }

    public class SourceFile
    extends AttInfo {
        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n = dataInput.readInt();
            String string = constantPool.getValue(dataInput.readShort());
        }

        public void write(DataOutput dataOutput) throws IOException {
        }
    }

    public class DefaultAttInfo
    extends AttInfo {
        byte[] bytes;

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] byArray) {
            this.bytes = byArray;
        }

        public String toString() {
            return "AttInfo[" + this.getName() + "] : " + new String(this.bytes);
        }

        public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
            int n = dataInput.readInt();
            this.bytes = new byte[n];
            dataInput.readFully(this.bytes);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.bytes.length);
            dataOutput.write(this.bytes);
        }
    }

    public abstract class AttInfo {
        private String name;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public abstract void read(DataInput var1, ConstantPool var2) throws IOException;

        public abstract void write(DataOutput var1) throws IOException;
    }
}

