/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ConstantPool {
    static HashMap cpInfos = new HashMap();
    private int constantPoolCount;
    private ArrayList cpInfoInstances = new ArrayList();

    public ConstantPool() {
        this.cpInfoInstances.add(Object.class);
    }

    public String getValue(int n) {
        return this.cpInfoInstances.get(n).toString();
    }

    public Iterator getConstants() {
        return this.cpInfoInstances.iterator();
    }

    public CpInfo getConstant(int n) {
        return (CpInfo)this.cpInfoInstances.get(n);
    }

    public short addUtf8Constant(String string) {
        ConstantUtf8Info constantUtf8Info = new ConstantUtf8Info();
        constantUtf8Info.setTag((byte)1);
        constantUtf8Info.setString(string);
        this.cpInfoInstances.add(constantUtf8Info);
        return (short)(this.cpInfoInstances.size() - 1);
    }

    private CpInfo getCpInfoInstance(Class clazz) throws IOException {
        try {
            Constructor constructor = clazz.getConstructor(ConstantPool.class);
            return (CpInfo)constructor.newInstance(this);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("new failed: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("access failed: " + illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("constructor not found: " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("target not found: " + invocationTargetException.getMessage());
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.constantPoolCount);
        Iterator iterator = this.cpInfoInstances.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            CpInfo cpInfo = (CpInfo)iterator.next();
            if (cpInfo == null) continue;
            cpInfo.write(dataOutput);
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.constantPoolCount = dataInput.readUnsignedShort();
        for (int i = 0; i < this.constantPoolCount - 1; ++i) {
            Byte by = new Byte(dataInput.readByte());
            Class clazz = (Class)cpInfos.get(by);
            CpInfo cpInfo = this.getCpInfoInstance(clazz);
            cpInfo.read(dataInput);
            cpInfo.setTag(by);
            this.cpInfoInstances.add(cpInfo);
            if (!(cpInfo instanceof ConstantDoubleInfo) && !(cpInfo instanceof ConstantLongInfo)) continue;
            ++i;
            this.cpInfoInstances.add(null);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Iterator iterator = this.cpInfoInstances.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n: " + n + " ").append(iterator.next());
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        cpInfos.put(new Byte(7), ConstantClassInfo.class);
        cpInfos.put(new Byte(9), ConstantRefInfo.class);
        cpInfos.put(new Byte(10), ConstantRefInfo.class);
        cpInfos.put(new Byte(11), ConstantRefInfo.class);
        cpInfos.put(new Byte(8), ConstantStringInfo.class);
        cpInfos.put(new Byte(3), ConstantIntFloatInfo.class);
        cpInfos.put(new Byte(4), ConstantIntFloatInfo.class);
        cpInfos.put(new Byte(6), ConstantDoubleInfo.class);
        cpInfos.put(new Byte(5), ConstantLongInfo.class);
        cpInfos.put(new Byte(12), ConstantNameTypeInfo.class);
        cpInfos.put(new Byte(1), ConstantUtf8Info.class);
    }

    public class ConstantUtf8Info
    extends CpInfo {
        private String string;

        public void setString(String string) {
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        public void read(DataInput dataInput) throws IOException {
            this.string = dataInput.readUTF();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeUTF(this.string);
        }

        public String toString() {
            return "utf-8: " + this.string;
        }
    }

    public class ConstantNameTypeInfo
    extends CpInfo {
        short nameIndex;
        short descriptorIndex;

        public void read(DataInput dataInput) throws IOException {
            this.nameIndex = dataInput.readShort();
            this.descriptorIndex = dataInput.readShort();
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeShort(this.nameIndex);
            dataOutput.writeShort(this.descriptorIndex);
        }

        public String toString() {
            return "name_type_info:" + ConstantPool.this.getValue(this.nameIndex) + "," + ConstantPool.this.getValue(this.descriptorIndex);
        }
    }

    public class ConstantDoubleInfo
    extends CpInfo {
        double value;

        public void read(DataInput dataInput) throws IOException {
            this.value = dataInput.readDouble();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeDouble(this.value);
        }

        public String toString() {
            return "double_info:" + this.value;
        }
    }

    public class ConstantLongInfo
    extends CpInfo {
        long value;

        public void read(DataInput dataInput) throws IOException {
            this.value = dataInput.readLong();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeLong(this.value);
        }

        public String toString() {
            return "long_info:" + this.value;
        }
    }

    public class ConstantIntFloatInfo
    extends CpInfo {
        int value;

        public void read(DataInput dataInput) throws IOException {
            this.value = dataInput.readInt();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeInt(this.value);
        }

        public String toString() {
            return "float_int_info:" + this.value;
        }
    }

    public class ConstantStringInfo
    extends CpInfo {
        short stringIndex;

        public void read(DataInput dataInput) throws IOException {
            this.stringIndex = dataInput.readShort();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeShort(this.stringIndex);
        }

        public String toString() {
            return "String_info:" + ConstantPool.this.getValue(this.stringIndex);
        }
    }

    public class ConstantRefInfo
    extends CpInfo {
        short classIndex;
        short nameAndTypeIndex;

        public void read(DataInput dataInput) throws IOException {
            this.classIndex = dataInput.readShort();
            this.nameAndTypeIndex = dataInput.readShort();
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeShort(this.classIndex);
            dataOutput.writeShort(this.nameAndTypeIndex);
        }

        public String toString() {
            return "ref_info:" + ConstantPool.this.getValue(this.classIndex) + "," + ConstantPool.this.getValue(this.nameAndTypeIndex);
        }
    }

    public class ConstantClassInfo
    extends CpInfo {
        short nameIndex;

        public short getIndex() {
            return this.nameIndex;
        }

        public void read(DataInput dataInput) throws IOException {
            this.nameIndex = dataInput.readShort();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeShort(this.nameIndex);
        }

        public String toString() {
            return "class_info: " + ConstantPool.this.getValue(this.nameIndex);
        }
    }

    public abstract class CpInfo {
        private byte tag;

        public void setTag(byte by) {
            this.tag = by;
        }

        public abstract void read(DataInput var1) throws IOException;

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.tag);
        }
    }
}

