/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.bytecode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.wsee.util.bytecode.AttributeInfo;
import weblogic.wsee.util.bytecode.ConstantPool;
import weblogic.wsee.util.bytecode.SField;
import weblogic.wsee.util.bytecode.SMethod;

public class SClass {
    private int magic = -889275714;
    private short minorVersion = (short)3;
    private short majorVersion = (short)45;
    private ConstantPool pool;
    private short accessFlag;
    private short thisClassIndex;
    private short superClassIndex;
    private short[] interfaceIndexes;
    private ArrayList fields = new ArrayList();
    private ArrayList methods = new ArrayList();
    private ArrayList attributes = new ArrayList();

    public ConstantPool getConstantPool() {
        return this.pool;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SClass[\n");
        stringBuffer.append("magic=").append(this.magic);
        stringBuffer.append("\nminorVersion=").append(this.minorVersion);
        stringBuffer.append("\nmajorVersion=").append(this.majorVersion);
        stringBuffer.append("\nconstantPool=").append(this.pool);
        stringBuffer.append("\naccessFlag=").append(this.accessFlag);
        stringBuffer.append("\nthisClass=").append(this.pool.getValue(this.thisClassIndex));
        stringBuffer.append("\nsuperClass=").append(this.pool.getValue(this.superClassIndex));
        stringBuffer.append("\ninterfaces=");
        for (int i = 0; i < this.interfaceIndexes.length; ++i) {
            stringBuffer.append("\n>>").append(this.pool.getValue(this.interfaceIndexes[i]));
        }
        stringBuffer.append("\nfields=");
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n>>").append(iterator.next());
        }
        stringBuffer.append("\nmethods=");
        iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n>>").append(iterator.next());
        }
        stringBuffer.append("\nattributes=");
        iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n>>").append(iterator.next());
        }
        stringBuffer.append("\n]\n");
        return stringBuffer.toString();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.magic);
        dataOutput.writeShort(this.minorVersion);
        dataOutput.writeShort(this.majorVersion);
        this.pool.write(dataOutput);
        dataOutput.writeShort(this.accessFlag);
        dataOutput.writeShort(this.thisClassIndex);
        dataOutput.writeShort(this.superClassIndex);
        dataOutput.writeShort(this.interfaceIndexes.length);
        for (int i = 0; i < this.interfaceIndexes.length; ++i) {
            dataOutput.writeShort(this.interfaceIndexes[i]);
        }
        dataOutput.writeShort(this.fields.size());
        for (Object object : this.fields) {
            ((SField)object).write(dataOutput);
        }
        dataOutput.writeShort(this.methods.size());
        for (Object object : this.methods) {
            ((SField)object).write(dataOutput);
        }
        dataOutput.writeShort(this.attributes.size());
        for (Object object : this.attributes) {
            ((AttributeInfo)object).write(dataOutput);
        }
    }

    public void addMethod(SMethod sMethod) {
        this.methods.add(sMethod);
    }

    public void addField(SField sField) {
        this.fields.add(sField);
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.add(attributeInfo);
    }

    public Iterator getAttributes() {
        return this.attributes.iterator();
    }

    public AttributeInfo getAttribute(String string) {
        Iterator iterator = this.getAttributes();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator.next();
            if (!string.equals(attributeInfo.getName())) continue;
            return attributeInfo;
        }
        return null;
    }

    public byte[] getAttributeBytes(String string) {
        AttributeInfo attributeInfo = this.getAttribute(string);
        if (attributeInfo == null) {
            throw new RuntimeException("Custom Attribute not found");
        }
        return attributeInfo.getAttributeBytes();
    }

    public void addCustomAttribute(String string, byte[] byArray) {
        short s = this.pool.addUtf8Constant(string);
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.setCustomAttribute(string, s, byArray);
        this.addAttribute(attributeInfo);
    }

    public void read(DataInput dataInput) throws IOException {
        int n;
        int n2;
        int n3;
        if (this.magic != dataInput.readInt()) {
            throw new IOException("wrong magic");
        }
        if (this.minorVersion != dataInput.readShort()) {
            // empty if block
        }
        if (this.majorVersion != dataInput.readShort()) {
            // empty if block
        }
        this.pool = new ConstantPool();
        this.pool.read(dataInput);
        this.accessFlag = dataInput.readShort();
        this.thisClassIndex = dataInput.readShort();
        this.superClassIndex = dataInput.readShort();
        int n4 = dataInput.readShort();
        this.interfaceIndexes = new short[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.interfaceIndexes[n3] = dataInput.readShort();
        }
        n3 = dataInput.readShort();
        for (n2 = 0; n2 < n3; ++n2) {
            SField sField = new SField();
            sField.read(dataInput, this.pool);
            this.addField(sField);
        }
        n2 = dataInput.readShort();
        for (n = 0; n < n2; ++n) {
            SMethod sMethod = new SMethod();
            sMethod.read(dataInput, this.pool);
            this.addMethod(sMethod);
        }
        n = dataInput.readShort();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = new AttributeInfo();
            attributeInfo.read(dataInput, this.pool);
            this.addAttribute(attributeInfo);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("usage: SClass [file].class");
            return;
        }
        SClass sClass = new SClass();
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        sClass.read(new DataInputStream(fileInputStream));
        fileInputStream.close();
        System.out.println("clazz:" + sClass);
    }
}

