/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.wsee.util.bytecode.AttributeInfo;
import weblogic.wsee.util.bytecode.ConstantPool;

public class SField {
    private short accessFlag;
    private short nameIndex;
    private short descriptorIndex;
    private ArrayList attributes = new ArrayList();
    private ConstantPool pool;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getElementName()).append("[\n");
        stringBuffer.append("\naccessFlag=").append(this.accessFlag);
        stringBuffer.append("\nname=").append(this.pool.getValue(this.nameIndex));
        stringBuffer.append("\ndescriptor=").append(this.pool.getValue(this.descriptorIndex));
        stringBuffer.append("\nattributes=");
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n>>").append(iterator.next());
        }
        stringBuffer.append("\n]\n");
        return stringBuffer.toString();
    }

    protected String getElementName() {
        return "Field";
    }

    public void read(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this.pool = constantPool;
        this.accessFlag = dataInput.readShort();
        this.nameIndex = dataInput.readShort();
        this.descriptorIndex = dataInput.readShort();
        int n = dataInput.readShort();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = new AttributeInfo();
            attributeInfo.read(dataInput, constantPool);
            this.attributes.add(attributeInfo);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.accessFlag);
        dataOutput.writeShort(this.nameIndex);
        dataOutput.writeShort(this.descriptorIndex);
        dataOutput.writeShort(this.attributes.size());
        for (AttributeInfo attributeInfo : this.attributes) {
            attributeInfo.write(dataOutput);
        }
    }
}

