/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.cow;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import weblogic.utils.FileUtils;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;

public class CowFile {
    private final File cowFile;

    public CowFile(File file) {
        assert (file != null);
        if (!file.exists()) {
            throw new IllegalArgumentException("compiledWsdl file " + file.getAbsolutePath() + " does not exist.");
        }
        this.cowFile = file;
    }

    public void extract(File file, Logger logger) throws IOException {
        this.extract(file, logger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File file, Logger logger, boolean bl) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.cowFile);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName().replace('/', File.separatorChar);
                if (jarEntry.isDirectory() || (bl || !string.endsWith(".java")) && !string.startsWith("wsdls" + File.separatorChar) && (!bl || string.toUpperCase(Locale.ENGLISH).endsWith(".MF") || string.endsWith(".java"))) continue;
                InputStream inputStream = null;
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                    String string2 = "meta-inf" + File.separatorChar + "src" + File.separatorChar;
                    if (string.toLowerCase(Locale.ENGLISH).startsWith(string2) && string.endsWith(".java")) {
                        string = string.substring(string2.length());
                    }
                    File file2 = new File(file, string);
                    FileUtils.writeToFile((InputStream)inputStream, (File)file2);
                    logger.log(EventLevel.VERBOSE, "Extracted file to " + file2.getAbsolutePath() + " from compiledWsdl.");
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }
}

