/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.cow;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import weblogic.wsee.util.cow.CowReader;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;

class CowReaderImpl
implements CowReader {
    private ClassLoader cl = null;
    private File cowFile;
    private Map<String, WsdlDefinitions> definitions = new HashMap<String, WsdlDefinitions>();

    CowReaderImpl(File file) {
        this.cowFile = file;
        this.cl = CowReaderImpl.getCowClassLoader(file);
    }

    private static URLClassLoader getCowClassLoader(File file) {
        URL uRL = null;
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("compileWsdl file " + file.getAbsolutePath() + "is invalid.", malformedURLException);
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
        return uRLClassLoader;
    }

    public WsdlDefinitions getWsdl(String string) throws WsdlException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.definitions.containsKey(string)) {
            return this.definitions.get(string);
        }
        URL uRL = this.cl.getResource(string);
        if (uRL == null) {
            throw new WsdlException("wsdl was not found in compiledWsdl file at: " + string);
        }
        WsdlDefinitions wsdlDefinitions = WsdlFactory.getInstance().parse(uRL.toExternalForm());
        this.definitions.put(string, wsdlDefinitions);
        return wsdlDefinitions;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public File getCowFile() {
        return this.cowFile;
    }

    public void cleanup() {
        this.cl = null;
    }
}

