/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.cow;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.JarFileUtils;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.util.cow.CowWriter;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CowWriterImpl
implements CowWriter {
    private File destJwsDir;
    private File jwsGeneratedDir;
    private String srcWsdl;
    private String jar;
    private boolean explode = false;

    public CowWriterImpl(String string, File file, boolean bl) {
        this.srcWsdl = string;
        this.destJwsDir = file;
        this.explode = bl;
        if (bl) {
            this.jwsGeneratedDir = file;
        } else {
            this.jwsGeneratedDir = new File(file, "/generated");
            this.jar = new File(string).getName().replace('.', '_') + ".jar";
        }
    }

    @Override
    public void writeWsdl(WsdlDefinitions wsdlDefinitions) throws IOException, WsdlException {
        File file = new File(this.jwsGeneratedDir, "/wsdls");
        ((WsdlDefinitionsBuilder)wsdlDefinitions).writeToFile(new File(file, this.srcWsdl), wsdlDefinitions.getEncoding());
    }

    @Override
    public void writeCow() throws IOException {
        if (!this.explode) {
            JarFileUtils.createJarFileFromDirectory((File)new File(this.destJwsDir, this.jar), (File)this.jwsGeneratedDir);
            FileUtils.remove((File)this.jwsGeneratedDir);
        }
    }

    @Override
    public File getGeneratedDir() {
        return this.jwsGeneratedDir;
    }

    @Override
    public String getOutputWsdl() {
        return "/wsdls/" + this.srcWsdl;
    }

    @Override
    public void writeFiles(List<FileSet> list) {
        if (list.isEmpty()) {
            return;
        }
        Project project = list.get(0).getProject();
        AntUtil.copyFiles(project, list, this.getGeneratedDir());
    }
}

