/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.dom.DocumentLookup;
import weblogic.wsee.util.is.InputSourceUtil;
import weblogic.xml.domimpl.Loader;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMParser {
    private static final boolean disableWLSDomImpl = Boolean.getBoolean("weblogic.wsee.disableWLSDOMImpl");
    private static final ThreadLocal<DocumentLookup> urlDocMap = new ThreadLocal();

    public static ThreadLocal<DocumentLookup> getURLDocumentMap() {
        return urlDocMap;
    }

    public static Document getDocument(String string) throws IOException {
        return DOMParser.getDocument(null, string);
    }

    public static Document getDocument(TransportInfo transportInfo, String string) throws IOException {
        if (disableWLSDomImpl) {
            return DOMParser.getDefaultDocumentImpl(string);
        }
        return DOMParser.getWebLogicDocumentImpl(transportInfo, string);
    }

    public static Document getDocument(InputSource inputSource) throws IOException {
        if (disableWLSDomImpl) {
            return DOMParser.getDefaultDocumentImpl(inputSource);
        }
        return DOMParser.getWebLogicDocumentImpl(inputSource);
    }

    private static Document getWebLogicDocumentImpl(InputSource inputSource) throws IOException {
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            return Loader.load((InputStream)inputStream);
        }
        if (inputSource.getCharacterStream() != null) {
            return Loader.load((Reader)inputSource.getCharacterStream());
        }
        String string = inputSource.getSystemId();
        if (!StringUtil.isEmpty(string)) {
            return DOMParser.getWebLogicDocumentImpl(null, string);
        }
        return null;
    }

    private static Document checkURLDocMap(String string) {
        DocumentLookup documentLookup = urlDocMap.get();
        if (documentLookup != null) {
            return documentLookup.lookup(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getWebLogicDocumentImpl(TransportInfo transportInfo, String string) throws IOException {
        Document document = DOMParser.checkURLDocMap(string);
        if (document != null) {
            return document;
        }
        InputSource inputSource = InputSourceUtil.loadURL(transportInfo, string);
        InputStream inputStream = inputSource.getByteStream();
        try {
            Document document2 = Loader.load((InputStream)inputStream);
            return document2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Document getDefaultDocumentImpl(InputSource inputSource) throws IOException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = WebLogicDocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IOException("Failed to create XML document from InputSource due to -- " + exception);
        }
        return document;
    }

    public static Document getDefaultDocumentImpl(String string) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = WebLogicDocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = null;
        try {
            document = !StringUtil.isEmpty(string) && string.startsWith("jar:") ? DOMParser.loadWSDL(string, documentBuilderFactory) : documentBuilderFactory.newDocumentBuilder().parse(string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IOException("Failed to create XML document from URL '" + string + "' due to -- " + exception);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadWSDL(String string, DocumentBuilderFactory documentBuilderFactory) throws Exception {
        InputSource inputSource = InputSourceUtil.loadURL(string);
        InputStream inputStream = inputSource.getByteStream();
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            return document;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

