/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.jspgen;

import java.util.ArrayList;
import java.util.Iterator;
import weblogic.wsee.util.jspgen.Comment;
import weblogic.wsee.util.jspgen.Declaration;
import weblogic.wsee.util.jspgen.Directive;
import weblogic.wsee.util.jspgen.Expression;
import weblogic.wsee.util.jspgen.ResourceProvider;
import weblogic.wsee.util.jspgen.ScriptException;
import weblogic.wsee.util.jspgen.Scriptlet;
import weblogic.wsee.util.jspgen.Tag;
import weblogic.wsee.util.jspgen.Text;

public class LightJspParser {
    private String page;
    private ResourceProvider provider;
    private String packageName;
    private String base;

    public LightJspParser(String string, ResourceProvider resourceProvider) {
        this.page = string;
        this.provider = resourceProvider;
    }

    String getPackageName() {
        return this.packageName;
    }

    public void setPackage(String string) {
        this.packageName = string;
    }

    public void parse(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws ScriptException {
        stringBuffer.append("  public void generate() \n");
        stringBuffer.append("   throws weblogic.wsee.util");
        stringBuffer.append(".jspgen.ScriptException{\n");
        this.generate(stringBuffer, stringBuffer2, stringBuffer3);
        stringBuffer.append("  }\n");
    }

    public void generate(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws ScriptException {
        Iterator iterator = this.getTags();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            tag.generate(stringBuffer, stringBuffer2, stringBuffer3);
        }
    }

    private Iterator getTags() throws ScriptException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        Iterator iterator = this.split(this.page);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Tag tag = this.createTag(string);
            tag.setContent(string);
            arrayList.add(tag);
        }
        return arrayList.iterator();
    }

    private Iterator split(String string) throws ScriptException {
        String string2 = "<%";
        String string3 = "%>";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            int n2;
            int n3 = string.indexOf(string2, n);
            if (n3 == -1) {
                arrayList.add(string.substring(n, string.length()));
                bl = true;
                continue;
            }
            if (n != n3) {
                arrayList.add(string.substring(n, n3));
            }
            if ((n2 = string.indexOf(string3, n = n3)) == -1) {
                throw new ScriptException("unable to find the end tag " + n + " " + (arrayList.size() == 0 ? "at start" : arrayList.get(arrayList.size() - 1)));
            }
            arrayList.add(string.substring(n, n2 + 2));
            n = n2 + 2;
        }
        return arrayList.iterator();
    }

    private Tag createTag(String string) {
        if (string.startsWith("<%--")) {
            return new Comment();
        }
        if (string.startsWith("<%=")) {
            return new Expression();
        }
        if (string.startsWith("<%!")) {
            return new Declaration();
        }
        if (string.startsWith("<%@")) {
            return new Directive(this.provider, this);
        }
        if (string.startsWith("<%")) {
            return new Scriptlet();
        }
        return new Text();
    }

    public void setBaseClass(String string) {
        this.base = string;
    }

    String getBaseClass() {
        return this.base;
    }
}

