/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.util.jspgen;

import java.io.File;
import java.io.IOException;
import weblogic.wsee.util.jspgen.JspGenBase;
import weblogic.wsee.util.jspgen.LightJspParser;
import weblogic.wsee.util.jspgen.ResourceProvider;
import weblogic.wsee.util.jspgen.ScriptException;
import weblogic.wsee.util.jspgen.Util;

public class Main
implements ResourceProvider {
    private String jspfile;
    private String outputFileName;
    private String className;
    private String packageName;
    private String outputDir;
    private File root;

    public Main(String string, String string2) throws IOException, ScriptException {
        int n;
        this.jspfile = string;
        this.outputDir = string2;
        this.root = new File(string).getParentFile();
        if (this.root == null) {
            this.root = new File(".");
        }
        String string3 = (n = string.lastIndexOf(".")) == -1 ? string : string.substring(0, n);
        n = string3.lastIndexOf("/");
        this.className = n == -1 ? string3 : string3.substring(n + 1, string3.length());
    }

    public Main(String string, String string2, boolean bl) throws IOException {
        this(string, string2);
        if (bl) {
            this.generate();
        }
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    public String getJavaFileName() {
        return this.outputFileName;
    }

    public String getResource(String string) throws ScriptException {
        File file = string.startsWith(File.separator) ? new File(string) : new File(this.root, string);
        return Util.fileToString(file.getPath());
    }

    private void generate() throws ScriptException {
        String string = Util.fileToString(this.jspfile);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        LightJspParser lightJspParser = new LightJspParser(string, this);
        lightJspParser.parse(stringBuffer, stringBuffer3, stringBuffer2);
        StringBuffer stringBuffer4 = new StringBuffer();
        String string2 = lightJspParser.getBaseClass();
        if (string2 == null) {
            string2 = JspGenBase.class.getName();
        }
        stringBuffer4.append(stringBuffer2);
        stringBuffer4.append("public class ").append(this.className).append(" ");
        stringBuffer4.append("extends ");
        stringBuffer4.append(string2).append("{\n");
        stringBuffer4.append(stringBuffer3);
        stringBuffer4.append(stringBuffer);
        stringBuffer4.append("}");
        this.packageName = lightJspParser.getPackageName();
        if (this.packageName == null) {
            throw new ScriptException("Package name not specified in " + this.jspfile);
        }
        this.outputFileName = this.outputDir + File.separator + this.packageName.replace('.', File.separatorChar) + File.separator + this.className + ".java";
        Util.stringToFile(this.outputFileName, stringBuffer4.toString());
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage: java Main <output-dir> <jspgen-files>");
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                Main main = new Main(stringArray[i], stringArray[0]);
                main.generate();
            }
        }
    }
}

