/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.workarea;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.workarea.WorkAreaClientHandler;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class WorkAreaClientDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(WorkAreaClientDeploymentListener.class);
    private static final List BEFORE = Collections.EMPTY_LIST;
    private static final List AFTER = Arrays.asList((Object[])new String[]{"CODEC_HANDLER"});
    private static final String HANDLER_NAME = "WorkAreaClientHandler";

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("Running WorkAreaClientDeploymentListener");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            try {
                if (!wsPort.getInternalHandlerList().contains(HANDLER_NAME)) {
                    if (verbose) {
                        Verbose.log("Adding workarea handler");
                    }
                    HandlerInfo handlerInfo = new HandlerInfo(WorkAreaClientHandler.class, null, null);
                    wsPort.getInternalHandlerList().insert(HANDLER_NAME, handlerInfo, AFTER, BEFORE);
                    continue;
                }
                if (!verbose) continue;
                Verbose.log("Workarea handler is already added");
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert workarea server handler", handlerException);
            }
        }
    }
}

