/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.workarea;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.workarea.WorkAreaServerHandler;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class WorkAreaDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(WorkAreaDeploymentListener.class);
    private static final List BEFORE = Arrays.asList((Object[])new String[]{"PRE_INVOKE_HANDLER"});
    private static final List AFTER = Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER"});
    private static final String HANDLER_NAME = "WorkAreaHandler";

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("WorkAreaDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerInfo handlerInfo = new HandlerInfo(WorkAreaServerHandler.class, null, null);
            if (verbose) {
                Verbose.log("Adding workarea handlers for " + wsDeploymentContext.getServiceURIs()[0]);
            }
            try {
                wsPort.getInternalHandlerList().insert(HANDLER_NAME, handlerInfo, AFTER, BEFORE);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert workarea server handler", handlerException);
            }
        }
    }
}

