/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.workarea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.workarea.WorkAreaConstants;
import weblogic.wsee.workarea.WorkAreaHeaderType;
import weblogic.xml.dom.DOMUtils;
import weblogic.xml.dom.Util;
import weblogic.xml.domimpl.Loader;
import weblogic.xml.domimpl.Saver;

public class WorkAreaHeader
extends MsgHeader {
    private Element content;
    public static final QName NAME = WorkAreaConstants.WORK_AREA_HEADER;
    public static final MsgHeaderType TYPE = new WorkAreaHeaderType();

    public QName getName() {
        return NAME;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public void parse(InputStream inputStream) {
        try {
            Document document = Loader.load((InputStream)inputStream);
            this.content = document.getDocumentElement();
            if (this.content != null) {
                this.content.removeAttribute("version");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public InputStream getInputStream() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Saver.save((OutputStream)byteArrayOutputStream, (Element)this.content);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public void read(Element element) throws MsgHeaderException {
        if (element != null) {
            this.content = this.firstElementChild(element);
        }
    }

    private Element firstElementChild(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public void write(Element element) throws MsgHeaderException {
        DOMUtils.addNamespaceDeclaration(element, "work", "http://bea.com/2004/06/soap/workarea/");
        element.appendChild(element.getOwnerDocument().importNode(this.content, true));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name:[" + this.getName() + "]\n");
        stringBuffer.append("Content:[");
        if (this.content != null) {
            stringBuffer.append(Util.printNode(this.content));
        } else {
            stringBuffer.append("<null>");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        super.toString(toStringWriter);
    }
}

