/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.workarea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.workarea.WorkAreaHandler;
import weblogic.wsee.workarea.WorkAreaHeader;
import weblogic.wsee.workarea.WorkContextXmlInputAdapter;
import weblogic.wsee.workarea.WorkContextXmlOutputAdapter;

public class WorkAreaServerHandler
extends WorkAreaHandler {
    private static final boolean verbose = Verbose.isVerbose(WorkAreaServerHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        try {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            MsgHeaders msgHeaders = wlMessageContext.getHeaders();
            WorkAreaHeader workAreaHeader = (WorkAreaHeader)msgHeaders.getHeader(WorkAreaHeader.TYPE);
            if (workAreaHeader != null) {
                WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getInterceptor();
                workContextMapInterceptor.receiveRequest((WorkContextInput)new WorkContextXmlInputAdapter(workAreaHeader.getInputStream()));
                if (verbose) {
                    Verbose.log("Received WorkAreaHeader " + workAreaHeader);
                }
            }
        }
        catch (IOException iOException) {
            throw new JAXRPCException("Unable to procees WorkContext:" + iOException);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        try {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            WorkContextMapInterceptor workContextMapInterceptor = WorkAreaServerHandler.getContext();
            if (workContextMapInterceptor != null && this.hasContext(64, true)) {
                WorkAreaHeader workAreaHeader = new WorkAreaHeader();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                WorkContextXmlOutputAdapter workContextXmlOutputAdapter = new WorkContextXmlOutputAdapter(byteArrayOutputStream);
                workContextMapInterceptor.sendResponse((WorkContextOutput)workContextXmlOutputAdapter, 64);
                workContextXmlOutputAdapter.close();
                workAreaHeader.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                if (verbose) {
                    Verbose.log("Preparing to Send -> [" + workAreaHeader + "]");
                }
                wlMessageContext.getHeaders().addHeader(workAreaHeader);
            }
        }
        catch (IOException iOException) {
            throw new JAXRPCException("Unable to procees WorkContext:" + iOException);
        }
        return true;
    }
}

