/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.workarea;

import java.beans.XMLDecoder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

public final class WorkContextXmlInputAdapter
implements WorkContextInput {
    private final XMLDecoder xmlDecoder;

    public WorkContextXmlInputAdapter(InputStream inputStream) {
        this.xmlDecoder = new XMLDecoder(inputStream);
    }

    public WorkContextXmlInputAdapter(XMLDecoder xMLDecoder) {
        this.xmlDecoder = xMLDecoder;
    }

    public String readASCII() throws IOException {
        return (String)this.xmlDecoder.readObject();
    }

    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(this.readASCII());
        try {
            WorkContext workContext = (WorkContext)clazz.newInstance();
            workContext.readContext((WorkContextInput)this);
            return workContext;
        }
        catch (InstantiationException instantiationException) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(illegalAccessException);
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        byte[] byArray2 = (byte[])this.xmlDecoder.readObject();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = (byte[])this.xmlDecoder.readObject();
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean readBoolean() throws IOException {
        return (Boolean)this.xmlDecoder.readObject();
    }

    public byte readByte() throws IOException {
        return (Byte)this.xmlDecoder.readObject();
    }

    public int readUnsignedByte() throws IOException {
        return (Integer)this.xmlDecoder.readObject();
    }

    public short readShort() throws IOException {
        return (Short)this.xmlDecoder.readObject();
    }

    public int readUnsignedShort() throws IOException {
        return (Integer)this.xmlDecoder.readObject();
    }

    public char readChar() throws IOException {
        return ((Character)this.xmlDecoder.readObject()).charValue();
    }

    public int readInt() throws IOException {
        return (Integer)this.xmlDecoder.readObject();
    }

    public long readLong() throws IOException {
        return (Long)this.xmlDecoder.readObject();
    }

    public float readFloat() throws IOException {
        return ((Float)this.xmlDecoder.readObject()).floatValue();
    }

    public double readDouble() throws IOException {
        return (Double)this.xmlDecoder.readObject();
    }

    public String readLine() throws IOException {
        return (String)this.xmlDecoder.readObject();
    }

    public String readUTF() throws IOException {
        return (String)this.xmlDecoder.readObject();
    }

    public static void main(String[] stringArray) throws Exception {
        XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(stringArray[0]));
        WorkContextXmlInputAdapter workContextXmlInputAdapter = new WorkContextXmlInputAdapter(xMLDecoder);
        System.out.println(workContextXmlInputAdapter.readASCII());
        System.out.println(workContextXmlInputAdapter.readInt());
        byte[] byArray = new byte[20];
        workContextXmlInputAdapter.readFully(byArray);
        System.out.println(byArray);
        System.out.println(workContextXmlInputAdapter.readBoolean());
        System.out.println(workContextXmlInputAdapter.readByte());
        System.out.println(workContextXmlInputAdapter.readShort());
        System.out.println(workContextXmlInputAdapter.readChar());
        System.out.println(workContextXmlInputAdapter.readInt());
        System.out.println(workContextXmlInputAdapter.readLong());
        System.out.println(workContextXmlInputAdapter.readFloat());
        System.out.println(workContextXmlInputAdapter.readDouble());
        System.out.println(workContextXmlInputAdapter.readUTF());
        System.out.println(workContextXmlInputAdapter.readUTF());
        System.out.println(workContextXmlInputAdapter.readUTF());
    }
}

