/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.workarea;

import java.beans.XMLEncoder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextOutput;

public class WorkContextXmlOutputAdapter
implements WorkContextOutput {
    private final XMLEncoder xmlOutput;

    public WorkContextXmlOutputAdapter(OutputStream outputStream) {
        this.xmlOutput = new XMLEncoder(outputStream);
    }

    public WorkContextXmlOutputAdapter(XMLEncoder xMLEncoder) {
        this.xmlOutput = xMLEncoder;
    }

    public void close() {
        this.xmlOutput.close();
    }

    public void writeASCII(String string) throws IOException {
        this.writeBytes(string);
    }

    public void writeContext(WorkContext workContext) throws IOException {
        this.writeASCII(workContext.getClass().getName());
        workContext.writeContext((WorkContextOutput)this);
    }

    public void write(int n) throws IOException {
        this.xmlOutput.writeObject(new Integer(n));
    }

    public void write(byte[] byArray) throws IOException {
        this.xmlOutput.writeObject(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.xmlOutput.writeObject(byArray2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.xmlOutput.writeObject(new Boolean(bl));
    }

    public void writeByte(int n) throws IOException {
        this.xmlOutput.writeObject(new Byte((byte)n));
    }

    public void writeShort(int n) throws IOException {
        this.xmlOutput.writeObject(new Short((short)n));
    }

    public void writeChar(int n) throws IOException {
        this.xmlOutput.writeObject(new Character((char)n));
    }

    public void writeInt(int n) throws IOException {
        this.xmlOutput.writeObject(new Integer(n));
    }

    public void writeLong(long l) throws IOException {
        this.xmlOutput.writeObject(new Long(l));
    }

    public void writeFloat(float f) throws IOException {
        this.xmlOutput.writeObject(new Float(f));
    }

    public void writeDouble(double d) throws IOException {
        this.xmlOutput.writeObject(new Double(d));
    }

    public void writeBytes(String string) throws IOException {
        this.xmlOutput.writeObject(string);
    }

    public void writeChars(String string) throws IOException {
        this.xmlOutput.writeObject(string);
    }

    public void writeUTF(String string) throws IOException {
        this.xmlOutput.writeObject(string);
    }

    public static void main(String[] stringArray) throws Exception {
        XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream("Test.xml"));
        WorkContextXmlOutputAdapter workContextXmlOutputAdapter = new WorkContextXmlOutputAdapter(xMLEncoder);
        workContextXmlOutputAdapter.writeASCII("Ascii HelloChris");
        workContextXmlOutputAdapter.write(23);
        byte[] byArray = new byte[]{1, 2, 3, 4};
        workContextXmlOutputAdapter.write(byArray);
        workContextXmlOutputAdapter.writeBoolean(true);
        workContextXmlOutputAdapter.writeByte(25);
        workContextXmlOutputAdapter.writeShort(26);
        workContextXmlOutputAdapter.writeChar(99);
        workContextXmlOutputAdapter.writeInt(27);
        workContextXmlOutputAdapter.writeLong(28L);
        workContextXmlOutputAdapter.writeFloat(29.0f);
        workContextXmlOutputAdapter.writeDouble(30.0);
        workContextXmlOutputAdapter.writeBytes("Foo");
        workContextXmlOutputAdapter.writeChars("Foo2");
        workContextXmlOutputAdapter.writeUTF("UTF");
        xMLEncoder.close();
    }
}

