/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.j2ee.descriptor.ExceptionMappingBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.JavaXmlTypeMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointInterfaceMappingBean;
import weblogic.j2ee.descriptor.ServiceInterfaceMappingBean;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

class NoMappingHelper {
    NoMappingHelper() {
    }

    static boolean isNoMappingCase(JavaWsdlMappingBean javaWsdlMappingBean) {
        ExceptionMappingBean[] exceptionMappingBeanArray = javaWsdlMappingBean.getExceptionMappings();
        JavaXmlTypeMappingBean[] javaXmlTypeMappingBeanArray = javaWsdlMappingBean.getJavaXmlTypeMappings();
        ServiceInterfaceMappingBean[] serviceInterfaceMappingBeanArray = javaWsdlMappingBean.getServiceInterfaceMappings();
        ServiceEndpointInterfaceMappingBean[] serviceEndpointInterfaceMappingBeanArray = javaWsdlMappingBean.getServiceEndpointInterfaceMappings();
        return exceptionMappingBeanArray.length == 0 && javaXmlTypeMappingBeanArray.length == 0 && serviceInterfaceMappingBeanArray.length == 0 && serviceEndpointInterfaceMappingBeanArray.length == 0;
    }

    static QName[] getXmlTypes(WsdlDefinitions wsdlDefinitions) throws WsException {
        HashSet hashSet = new HashSet();
        WsdlPort wsdlPort = NoMappingHelper.getWsdlPort(wsdlDefinitions);
        NoMappingHelper.checkBinding(wsdlPort.getBinding());
        for (WsdlOperation wsdlOperation : wsdlPort.getPortType().getOperations().values()) {
            if (wsdlOperation.getInput() != null) {
                NoMappingHelper.fillParamTypes(wsdlOperation.getInput(), hashSet);
            }
            if (wsdlOperation.getOutput() == null) continue;
            NoMappingHelper.fillParamTypes(wsdlOperation.getOutput(), hashSet);
        }
        return hashSet.toArray(new QName[hashSet.size()]);
    }

    private static void checkBinding(WsdlBinding wsdlBinding) throws WsException {
    }

    private static void fillParamTypes(WsdlMessage wsdlMessage, Set set) throws WsException {
        for (WsdlPart wsdlPart : wsdlMessage.getParts().values()) {
            QName qName = wsdlPart.getType();
            if (qName == null) {
                throw new WsException("Wsdl message " + wsdlMessage.getName() + " part" + " " + wsdlPart.getName() + " uses a xml element type " + " A full feature JAXRPC mapping file is required.");
            }
            set.add(qName);
        }
    }

    private static WsdlPort getWsdlPort(WsdlDefinitions wsdlDefinitions) throws WsException {
        Iterator<WsdlExtensible> iterator = wsdlDefinitions.getServices().values().iterator();
        if (!iterator.hasNext()) {
            throw new WsException("Wsdl doesn't have any service defined.  A full feature JAXRPC mapping file is required.");
        }
        WsdlService wsdlService = iterator.next();
        if (iterator.hasNext()) {
            throw new WsException("Wsdl doesn't have more than one service defined.  A full feature JAXRPC mapping file is required.");
        }
        iterator = wsdlService.getPorts().values().iterator();
        if (!iterator.hasNext()) {
            throw new WsException("Wsdl service " + wsdlService.getName() + " doesn't have any port defined. " + "A full feature JAXRPC mapping file is required.");
        }
        WsdlPort wsdlPort = (WsdlPort)iterator.next();
        if (iterator.hasNext()) {
            throw new WsException("Wsdl service " + wsdlService.getName() + " has more than one port defined. " + "A full feature JAXRPC mapping file is required.");
        }
        return wsdlPort;
    }
}

