/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.ByteArrayHolder;
import weblogic.j2ee.descriptor.ConstructorParameterOrderBean;
import weblogic.j2ee.descriptor.ExceptionMappingBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.JavaXmlTypeMappingBean;
import weblogic.j2ee.descriptor.MethodParamPartsMappingBean;
import weblogic.j2ee.descriptor.PackageMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointInterfaceMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointMethodMappingBean;
import weblogic.j2ee.descriptor.ServiceInterfaceMappingBean;
import weblogic.j2ee.descriptor.WsdlMessageMappingBean;
import weblogic.j2ee.descriptor.WsdlReturnValueMappingBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.policy.deployment.UsingPolicy;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsEndpointImpl;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsFault;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsMethodImpl;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.ws.WsServiceImpl;
import weblogic.wsee.ws.WsSkel;
import weblogic.wsee.ws.WsStub;
import weblogic.wsee.ws.WsType;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlMethod;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlParameter;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBindingUtil;
import weblogic.wsee.wsdl.soap12.Soap12Binding;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;
import weblogic.xml.schema.binding.internal.NameUtil;
import weblogic.xml.schema.binding.util.ClassUtil;

public class WSBuilderHelper {
    private static final String XSNS = "http://www.w3.org/2001/XMLSchema";
    private JavaWsdlMappingBean mappingdd;
    private WsServiceImpl wsService;
    private WsPort wsPort;
    private WsEndpoint endpoint;
    private WebAppServletContext wasc;
    private static boolean verbose = Verbose.isVerbose(WSBuilderHelper.class);

    WSBuilderHelper(JavaWsdlMappingBean javaWsdlMappingBean) {
        this.mappingdd = javaWsdlMappingBean;
    }

    public WSBuilderHelper() {
    }

    void setServletContext(ServletContext servletContext) {
        if (servletContext instanceof WebAppServletContext) {
            this.wasc = (WebAppServletContext)servletContext;
        }
    }

    WebAppServletContext getServletContext() {
        return this.wasc;
    }

    public WsServiceImpl buildService(WsdlPort wsdlPort, boolean bl) throws WsException {
        this.wsService = new WsServiceImpl(wsdlPort.getService());
        if (UsingPolicy.narrow(wsdlPort.getService().getDefinitions()) != null) {
            this.wsService.setUsingPolicy(true);
        }
        this.buildWsPort(wsdlPort, bl);
        return this.wsService;
    }

    WsServiceImpl buildService(WsdlService wsdlService, PortInfoBean[] portInfoBeanArray, boolean bl) throws WsException {
        if (portInfoBeanArray == null || portInfoBeanArray.length == 0) {
            return this.buildService(wsdlService, bl);
        }
        if (verbose) {
            Verbose.log("Building web service:" + wsdlService.getName());
        }
        this.wsService = new WsServiceImpl(wsdlService);
        if (UsingPolicy.narrow(wsdlService.getDefinitions()) != null) {
            this.wsService.setUsingPolicy(true);
        }
        int n = 0;
        int n2 = 0;
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            ++n;
            if (!this.hasPort(portInfoBeanArray, wsdlPort)) continue;
            ++n2;
            this.buildWsPort(wsdlPort, bl);
        }
        if (n > 0 && n2 == 0) {
            throw new IllegalStateException("No port-name given in service-reference-description matched any port defined in service " + this.wsService.getWsdlService().getName() + ". You should check that the configuration of service-reference-description in weblogic-ejb-jar.xml is correct");
        }
        return this.wsService;
    }

    private boolean hasPort(PortInfoBean[] portInfoBeanArray, WsdlPort wsdlPort) {
        for (int i = 0; i < portInfoBeanArray.length; ++i) {
            PortInfoBean portInfoBean = portInfoBeanArray[i];
            if (!portInfoBean.getPortName().equals(wsdlPort.getName().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    public WsServiceImpl buildService(WsdlService wsdlService, boolean bl) throws WsException {
        if (verbose) {
            Verbose.log("Building web service:" + wsdlService.getName());
        }
        this.wsService = new WsServiceImpl(wsdlService);
        if (UsingPolicy.narrow(wsdlService.getDefinitions()) != null) {
            this.wsService.setUsingPolicy(true);
        }
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            this.buildWsPort(wsdlPort, bl);
        }
        return this.wsService;
    }

    private void buildWsPort(WsdlPort wsdlPort, boolean bl) throws WsException {
        if (SoapBinding.narrow(wsdlPort.getBinding()) == null && Soap12Binding.narrow(wsdlPort.getBinding()) == null) {
            return;
        }
        if (verbose) {
            Verbose.log("Building port: " + wsdlPort.getName());
        }
        if (bl) {
            this.endpoint = new WsSkel(this.wsService, wsdlPort.getPortType());
            if (this.wasc != null) {
                ((WsSkel)this.endpoint).setContext(this.wasc.getEnvironmentContext());
            }
        } else {
            this.endpoint = new WsStub(this.wsService, wsdlPort.getPortType());
        }
        this.wsService.addEndpoint(wsdlPort.getPortType().getName(), this.endpoint);
        this.wsPort = this.wsService.addPort(wsdlPort.getName().getLocalPart(), wsdlPort, this.endpoint);
        if (this.mappingdd != null) {
            this.populatePort();
        } else {
            this.buildWithoutMappingFile();
        }
    }

    private void populatePort() throws WsException {
        int n;
        ExceptionMappingBean[] exceptionMappingBeanArray = this.mappingdd.getExceptionMappings();
        JavaXmlTypeMappingBean[] javaXmlTypeMappingBeanArray = this.mappingdd.getJavaXmlTypeMappings();
        ServiceInterfaceMappingBean[] serviceInterfaceMappingBeanArray = this.mappingdd.getServiceInterfaceMappings();
        ServiceEndpointInterfaceMappingBean[] serviceEndpointInterfaceMappingBeanArray = this.mappingdd.getServiceEndpointInterfaceMappings();
        if (!(exceptionMappingBeanArray != null && exceptionMappingBeanArray.length != 0 || javaXmlTypeMappingBeanArray != null && javaXmlTypeMappingBeanArray.length != 0 || serviceInterfaceMappingBeanArray != null && serviceInterfaceMappingBeanArray.length != 0 || serviceEndpointInterfaceMappingBeanArray != null && serviceEndpointInterfaceMappingBeanArray.length != 0)) {
            this.buildSimpleCase();
            return;
        }
        WsdlBinding wsdlBinding = this.wsPort.getWsdlPort().getBinding();
        QName qName = this.wsService.getWsdlService().getName();
        QName qName2 = wsdlBinding.getName();
        QName qName3 = wsdlBinding.getPortType().getName();
        for (n = 0; n < serviceInterfaceMappingBeanArray.length; ++n) {
            if (!serviceInterfaceMappingBeanArray[n].getWsdlServiceName().equals(qName)) continue;
        }
        HolderUtil.NameCollisionsFilter.getInstance().reset();
        this.consumeHolders(serviceEndpointInterfaceMappingBeanArray);
        for (n = 0; n < serviceEndpointInterfaceMappingBeanArray.length; ++n) {
            if (!serviceEndpointInterfaceMappingBeanArray[n].getWsdlBinding().equals(qName2) || !serviceEndpointInterfaceMappingBeanArray[n].getWsdlPortType().equals(qName3)) continue;
            String string = serviceEndpointInterfaceMappingBeanArray[n].getServiceEndpointInterface();
            ((WsEndpointImpl)this.endpoint).setEndpointInterface(this.loadClass(string));
            this.populateOperations(serviceEndpointInterfaceMappingBeanArray[n]);
            return;
        }
        throw new WsException("Can't find service-endpoint-interface-mapping for wsdl port:" + this.wsPort.getWsdlPort());
    }

    private void consumeHolders(ServiceEndpointInterfaceMappingBean[] serviceEndpointInterfaceMappingBeanArray) throws WsException {
        WsdlPortType wsdlPortType = this.wsPort.getWsdlPort().getPortType();
        for (int i = 0; i < serviceEndpointInterfaceMappingBeanArray.length; ++i) {
            ServiceEndpointMethodMappingBean[] serviceEndpointMethodMappingBeanArray = serviceEndpointInterfaceMappingBeanArray[i].getServiceEndpointMethodMappings();
            for (int j = 0; j < serviceEndpointMethodMappingBeanArray.length; ++j) {
                QName qName = new QName(wsdlPortType.getName().getNamespaceURI(), serviceEndpointMethodMappingBeanArray[j].getWsdlOperation());
                WsdlOperation wsdlOperation = wsdlPortType.getOperations().get(qName);
                if (wsdlOperation == null) continue;
                MethodParamPartsMappingBean[] methodParamPartsMappingBeanArray = serviceEndpointMethodMappingBeanArray[j].getMethodParamPartsMappings();
                for (int k = 0; k < methodParamPartsMappingBeanArray.length; ++k) {
                    WsdlMessageMappingBean wsdlMessageMappingBean = methodParamPartsMappingBeanArray[k].getWsdlMessageMapping();
                    if (!this.isHolder(wsdlMessageMappingBean)) continue;
                    String string = methodParamPartsMappingBeanArray[k].getParamType();
                    String[] stringArray = this.getTypeHolders(string, wsdlMessageMappingBean, wsdlOperation);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        HolderUtil.NameCollisionsFilter.getInstance().use(stringArray[i2]);
                    }
                }
            }
        }
    }

    private Class loadClass(String string) throws WsException {
        try {
            return ClassUtil.loadClass((String)string);
        }
        catch (ClassUtil.ClassUtilException classUtilException) {
            throw new WsException("Failed to load class " + string + ":" + (Object)((Object)classUtilException), classUtilException);
        }
    }

    private void buildSimpleCase() throws WsException {
        this.buildWithoutMappingFile();
    }

    private void buildWithoutMappingFile() throws WsException {
        WsdlPortType wsdlPortType = this.wsPort.getWsdlPort().getPortType();
        WsdlBinding wsdlBinding = this.wsPort.getWsdlPort().getBinding();
        for (WsdlOperation wsdlOperation : wsdlPortType.getOperations().values()) {
            WsMethodImpl wsMethodImpl = new WsMethodImpl(this.endpoint, wsdlOperation);
            ((WsEndpointImpl)this.endpoint).addMethod(wsdlOperation.getName().getLocalPart(), wsMethodImpl);
            wsMethodImpl.setMethodName(wsdlOperation.getName().getLocalPart());
            this.populateParts(wsMethodImpl, wsdlOperation, wsdlBinding);
        }
    }

    private void populateOperations(ServiceEndpointInterfaceMappingBean serviceEndpointInterfaceMappingBean) throws WsException {
        WsdlPortType wsdlPortType = this.wsPort.getWsdlPort().getPortType();
        WsdlBinding wsdlBinding = this.wsPort.getWsdlPort().getBinding();
        ServiceEndpointMethodMappingBean[] serviceEndpointMethodMappingBeanArray = serviceEndpointInterfaceMappingBean.getServiceEndpointMethodMappings();
        for (int i = 0; i < serviceEndpointMethodMappingBeanArray.length; ++i) {
            QName qName = new QName(wsdlPortType.getName().getNamespaceURI(), serviceEndpointMethodMappingBeanArray[i].getWsdlOperation());
            WsdlOperation wsdlOperation = wsdlPortType.getOperations().get(qName);
            if (wsdlOperation == null) {
                throw new WsException("There is no operation \"" + qName + "\"" + " defined in wsdl.");
            }
            this.populateOperation(wsdlOperation, wsdlBinding, serviceEndpointMethodMappingBeanArray[i]);
        }
    }

    private void populateOperation(WsdlOperation wsdlOperation, WsdlBinding wsdlBinding, ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean) throws WsException {
        if (verbose) {
            Verbose.log("Building operation: " + wsdlOperation.getName());
        }
        WsMethodImpl wsMethodImpl = new WsMethodImpl(this.endpoint, wsdlOperation);
        ((WsEndpointImpl)this.endpoint).addMethod(wsdlOperation.getName().getLocalPart(), wsMethodImpl);
        Method method = this.findSeiMethod(serviceEndpointMethodMappingBean, wsdlOperation);
        wsMethodImpl.setMethodName(serviceEndpointMethodMappingBean.getJavaMethodName());
        if (serviceEndpointMethodMappingBean.getWrappedElement() != null) {
            this.populateWrapedOperation(wsMethodImpl, wsdlOperation, serviceEndpointMethodMappingBean);
            this.populateFaults(wsdlOperation.getFaults(), wsMethodImpl);
        } else {
            this.populateParts(wsMethodImpl, wsdlOperation, wsdlBinding);
        }
        this.matchMethodParams(wsMethodImpl, serviceEndpointMethodMappingBean, wsdlOperation);
        this.matchReturnAndPart(wsMethodImpl, wsdlOperation, method, serviceEndpointMethodMappingBean.getWsdlReturnValueMapping());
        this.matchException(wsMethodImpl, method);
    }

    private void matchMethodParams(WsMethod wsMethod, ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WsdlOperation wsdlOperation) throws WsException {
        MethodParamPartsMappingBean[] methodParamPartsMappingBeanArray = serviceEndpointMethodMappingBean.getMethodParamPartsMappings();
        if (methodParamPartsMappingBeanArray.length == 0) {
            Iterator iterator = wsMethod.getParameters();
            while (iterator.hasNext()) {
                WsParameterType wsParameterType = (WsParameterType)iterator.next();
                if (wsParameterType.getMode() != 0) continue;
                throw new WsException("There is no method-param-parts-mapping defined for method:" + serviceEndpointMethodMappingBean.getJavaMethodName());
            }
        } else {
            Iterator iterator = wsMethod.getParameters();
            for (int i = 0; i < methodParamPartsMappingBeanArray.length; ++i) {
                MethodParamPartsMappingBean methodParamPartsMappingBean = methodParamPartsMappingBeanArray[i];
                if (!iterator.hasNext()) {
                    throw new WsException("For wsdl operation \"" + wsdlOperation.getName() + "\"" + " java method \"" + "\"" + wsMethod.getMethodName() + " wsdl " + "defined less parts than java parameters.");
                }
                iterator.next();
                this.matchParameterAndPart(wsMethod, wsdlOperation, methodParamPartsMappingBean);
            }
            if (iterator.hasNext()) {
                throw new WsException("For wsdl operation \"" + wsdlOperation.getName() + "\"" + " java method \"" + "\"" + wsMethod.getMethodName() + " wsdl " + "defined more parts than java parameters.");
            }
        }
    }

    private void populateWrapedOperation(WsMethodImpl wsMethodImpl, WsdlOperation wsdlOperation, ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean) throws WsException {
        WsType wsType;
        String string;
        WsdlMessageMappingBean wsdlMessageMappingBean;
        MethodParamPartsMappingBean methodParamPartsMappingBean;
        int n;
        MethodParamPartsMappingBean methodParamPartsMappingBean2;
        MethodParamPartsMappingBean[] methodParamPartsMappingBeanArray = serviceEndpointMethodMappingBean.getMethodParamPartsMappings();
        MethodParamPartsMappingBean[] methodParamPartsMappingBeanArray2 = new MethodParamPartsMappingBean[methodParamPartsMappingBeanArray.length];
        for (int i = 0; i < methodParamPartsMappingBeanArray.length; ++i) {
            methodParamPartsMappingBean2 = methodParamPartsMappingBeanArray[i];
            n = methodParamPartsMappingBean2.getParamPosition();
            methodParamPartsMappingBeanArray2[n] = methodParamPartsMappingBean2;
        }
        WsdlMessage wsdlMessage = wsdlOperation.getInput();
        if (wsdlMessage == null) {
            throw new WsException("Wsdl operation " + wsdlOperation.getName() + " is not " + "a wrapped operation as marked in JAXRPC mapping file. There is no" + " input wsdl message.");
        }
        methodParamPartsMappingBean2 = this.getWrapElement(wsdlMessage);
        wsMethodImpl.setWrapperElement(methodParamPartsMappingBean2.getQName());
        for (n = 0; n < methodParamPartsMappingBeanArray2.length; ++n) {
            methodParamPartsMappingBean = methodParamPartsMappingBeanArray2[n];
            wsdlMessageMappingBean = methodParamPartsMappingBean.getWsdlMessageMapping();
            string = wsdlMessageMappingBean.getWsdlMessagePartName();
            wsType = new WsParameterType(string, WSBuilderHelper.getTypeMode(wsdlMessageMappingBean.getParameterMode()));
            this.setSoapHeader(wsdlMessageMappingBean, (WsParameterType)wsType);
            if (wsType.isHeader()) {
                WsdlMessage wsdlMessage2 = wsdlMessage;
                if (wsType.getMode() == 1 && (wsdlMessage2 = wsdlOperation.getOutput()) == null) {
                    throw new WsException("Wsdl operation " + wsdlOperation.getName() + " has no " + "ouput message, but JAXRPC mapping file has an output header defined.");
                }
                WsdlPart wsdlPart = wsdlMessage2.getParts().get(wsdlMessageMappingBean.getWsdlMessagePartName());
                assert (wsdlPart != null);
                wsType.setXmlName(XmlTypeName.forGlobalName((char)'e', (QName)wsdlPart.getElement()));
                wsType.setElementName(wsdlPart.getElement());
            } else {
                wsType.setXmlName((XmlTypeName)methodParamPartsMappingBean2);
            }
            wsMethodImpl.addParameter(string, (WsParameterType)wsType);
        }
        WsdlMessage wsdlMessage3 = wsdlOperation.getOutput();
        methodParamPartsMappingBean = serviceEndpointMethodMappingBean.getWsdlReturnValueMapping();
        if (wsdlMessage3 == null) {
            if (methodParamPartsMappingBean != null) {
                throw new WsException("Wsdl operation " + wsdlOperation.getName() + " has no " + "ouput message, but JAXRPC mapping file has return value mapping.");
            }
        } else {
            wsdlMessageMappingBean = this.getWrapElement(wsdlMessage3);
            wsMethodImpl.setReturnWrapperElement(wsdlMessageMappingBean.getQName());
            if (methodParamPartsMappingBean != null) {
                string = methodParamPartsMappingBean.getWsdlMessagePartName();
                wsType = new WsReturnType(string);
                wsType.setXmlName((XmlTypeName)wsdlMessageMappingBean);
                wsMethodImpl.setReturnType((WsReturnType)wsType);
            }
        }
    }

    private static int getTypeMode(String string) {
        if (string.equals("INOUT")) {
            return 2;
        }
        if (string.equals("OUT")) {
            return 1;
        }
        return 0;
    }

    private XmlTypeName getWrapElement(WsdlMessage wsdlMessage) throws WsException {
        Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
        if (!iterator.hasNext()) {
            throw new WsException("WsdlMessage " + wsdlMessage.getName() + " for a " + "doc-lit-wrap style operation doesn't have any part.");
        }
        WsdlPart wsdlPart = iterator.next();
        QName qName = wsdlPart.getElement();
        if (qName == null) {
            throw new WsException("WsdlMessage " + wsdlMessage.getName() + ", part " + wsdlPart.getName() + ", for a doc-lit-wrap style operation should use " + " global element.");
        }
        return XmlTypeName.forGlobalName((char)'e', (QName)qName);
    }

    private void matchException(WsMethod wsMethod, Method method) throws WsException {
        List<Class<?>> list = Arrays.asList(method.getExceptionTypes());
        Iterator iterator = wsMethod.getExceptions();
        while (iterator.hasNext()) {
            WsFault wsFault = (WsFault)iterator.next();
            WsdlMessage wsdlMessage = wsFault.getFaultMessage();
            ExceptionMappingBean exceptionMappingBean = this.findExceptionMappingBean(wsdlMessage);
            if (exceptionMappingBean == null) {
                iterator.remove();
                continue;
            }
            Class clazz = this.loadClass(exceptionMappingBean.getExceptionType());
            if (list.contains(clazz)) {
                wsFault.setExceptionClass(clazz);
                ConstructorParameterOrderBean constructorParameterOrderBean = exceptionMappingBean.getConstructorParameterOrder();
                if (constructorParameterOrderBean == null || constructorParameterOrderBean.getElementNames().length < 2) {
                    Class<?> clazz2;
                    Class<?>[] classArray;
                    Constructor constructor;
                    if (verbose) {
                        Verbose.log("++++  process single property java exception " + clazz.getName());
                    }
                    if ((constructor = ExceptionUtil.getConstructorForSingleArgClass(clazz)) == null || (classArray = constructor.getParameterTypes()).length <= 0 || (clazz2 = classArray[0]) == null) continue;
                    if (ExceptionUtil.isMarshalPropertyJavaClass(clazz2)) {
                        Method method2 = this.getGetterForClass(clazz2, clazz);
                        if (method2 == null) {
                            Verbose.log(" warning.  In exception " + clazz.getName() + ", could not " + "find getter method that returns the constructor " + "single param class " + clazz2.getName());
                        } else if (verbose) {
                            Verbose.log("++++  found marshalProperty Exception getter method " + method2.getName());
                        }
                        wsFault.setMarshalPropertyGetterMethod(method2);
                        wsFault.setMarshalPropertyClass(clazz2);
                        wsFault.setMarshalPropertyExceptionConstructor(constructor);
                        if (!verbose) continue;
                        Verbose.log("++++  marshalPropertyClass '" + clazz2 + "' on WsFault " + wsFault);
                        continue;
                    }
                    if (!verbose) continue;
                    Verbose.log("++++  single exception parameter class '" + clazz2.getName() + "' is not a marshal property class.  The exception will be marshalled as " + "the actual exception class '" + clazz.getName() + "'");
                    continue;
                }
                if (!verbose) continue;
                Verbose.log("++++  exception " + clazz.getName() + " is NOT a marshal property Exception. ");
                continue;
            }
            throw new WsException("Method " + method.getName() + " doesn't " + " throw " + clazz + " as decribed in exception mapping.");
        }
    }

    private Method getGetterForClass(Class clazz, Class clazz2) {
        int n;
        Method method = null;
        Method[] methodArray = clazz2.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().startsWith("get") || !methodArray[n].getReturnType().equals(clazz)) continue;
            method = methodArray[n];
            break;
        }
        if (method != null) {
            return method;
        }
        methodArray = clazz2.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().startsWith("get") || !methodArray[n].getReturnType().equals(clazz)) continue;
            method = methodArray[n];
            break;
        }
        return method;
    }

    private ExceptionMappingBean findExceptionMappingBean(WsdlMessage wsdlMessage) throws WsException {
        ExceptionMappingBean[] exceptionMappingBeanArray = this.mappingdd.getExceptionMappings();
        for (int i = 0; i < exceptionMappingBeanArray.length; ++i) {
            ExceptionMappingBean exceptionMappingBean = exceptionMappingBeanArray[i];
            if (!wsdlMessage.getName().equals(exceptionMappingBean.getWsdlMessage())) continue;
            String string = exceptionMappingBean.getWsdlMessagePartName();
            if (string != null && wsdlMessage.getParts().get(string) == null) {
                throw new WsException("Exception mapping for WSDL message " + wsdlMessage.getName() + ", part " + string + " is not defined in WSDL.");
            }
            return exceptionMappingBean;
        }
        return null;
    }

    private Method findSeiMethod(ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WsdlOperation wsdlOperation) throws WsException {
        int n;
        Class[] classArray = null;
        MethodParamPartsMappingBean[] methodParamPartsMappingBeanArray = serviceEndpointMethodMappingBean.getMethodParamPartsMappings();
        if (methodParamPartsMappingBeanArray != null && methodParamPartsMappingBeanArray.length != 0) {
            classArray = new Class[methodParamPartsMappingBeanArray.length];
            block4: for (n = 0; n < methodParamPartsMappingBeanArray.length; ++n) {
                int n2 = methodParamPartsMappingBeanArray[n].getParamPosition();
                if (n2 >= methodParamPartsMappingBeanArray.length) {
                    throw new WsException("For method:" + serviceEndpointMethodMappingBean.getJavaMethodName() + " ParamPosition \"" + n2 + "\" is out of range.");
                }
                WsdlMessageMappingBean wsdlMessageMappingBean = methodParamPartsMappingBeanArray[n].getWsdlMessageMapping();
                String string = methodParamPartsMappingBeanArray[n].getParamType();
                if (this.isHolder(wsdlMessageMappingBean)) {
                    String[] stringArray = this.getTypeHolders(string, wsdlMessageMappingBean, wsdlOperation);
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = stringArray[i];
                        string = HolderUtil.NameCollisionsFilter.getInstance().filterFullName(string);
                        try {
                            Class clazz;
                            classArray[n2] = clazz = this.loadClass(string);
                            continue block4;
                        }
                        catch (WsException wsException) {
                            if (i != stringArray.length - 1) continue;
                            throw wsException;
                        }
                    }
                    continue;
                }
                classArray[n2] = this.loadClass(string);
            }
        }
        for (n = 0; n < methodParamPartsMappingBeanArray.length; ++n) {
            if (classArray[n] != null) continue;
            throw new WsException("Method \"" + serviceEndpointMethodMappingBean.getJavaMethodName() + "\"" + "'s paramter #" + n + " is not defined.");
        }
        Class clazz = this.endpoint.getEndpointInterface();
        String string = serviceEndpointMethodMappingBean.getJavaMethodName();
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new WsException("Can't find method \"" + this.methodSig(string, classArray) + "\"" + " in service end point interface '" + clazz.getName() + "'. It must" + "be: " + this.methodDescription(clazz));
        }
    }

    private String[] getTypeHolders(String string, WsdlMessageMappingBean wsdlMessageMappingBean, WsdlOperation wsdlOperation) throws WsException {
        WsdlMessage wsdlMessage = "OUT".equalsIgnoreCase(wsdlMessageMappingBean.getParameterMode()) ? wsdlOperation.getOutput() : wsdlOperation.getInput();
        String string2 = wsdlMessageMappingBean.getWsdlMessagePartName();
        WsdlPart wsdlPart = wsdlMessage.getParts().get(string2);
        if (wsdlPart == null) {
            throw new WsException("Failed to find part " + string2 + " in wsdl message :" + wsdlMessage);
        }
        QName qName = wsdlPart.getType();
        if (qName == null) {
            qName = wsdlPart.getElement();
        }
        return this.getHolderClasses(string, qName);
    }

    private String[] getHolderClasses(String string, QName qName) throws WsException {
        String string2 = HolderUtil.getStandardHolder(string);
        if (string2 != null) {
            return new String[]{string2};
        }
        if (HolderUtil.isStandardHolderClass(string)) {
            return new String[]{string};
        }
        String string3 = qName.getNamespaceURI();
        if (XSNS.equals(string3) || "http://schemas.xmlsoap.org/soap/encoding/".equals(string3) || "http://www.w3.org/2003/05/soap-encoding".equals(string3)) {
            string2 = this.getStandardSchemaHolder(qName);
            return new String[]{string2};
        }
        if (string.startsWith("java.") || string.startsWith("javax.") || HolderUtil.isPrimitiveType(string) || string.startsWith("[") || string.endsWith("[]")) {
            PackageMappingBean[] packageMappingBeanArray = this.mappingdd.getPackageMappings();
            String[] stringArray = this.getPackageNames(qName, packageMappingBeanArray);
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                string4 = StringUtil.isEmpty(string4) ? "holders" : string4 + ".holders";
                String string5 = this.getJaxrpcClassName(qName.getLocalPart());
                stringArray[i] = string2 = string4 + "." + string5 + "Holder";
            }
            return stringArray;
        }
        string2 = HolderUtil.getHolderClass(string);
        return new String[]{string2};
    }

    private String getJaxrpcClassName(String string) {
        return NameUtil.getJAXRPCClassName((String)string);
    }

    private String[] getPackageNames(QName qName, PackageMappingBean[] packageMappingBeanArray) throws WsException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < packageMappingBeanArray.length; ++i) {
            if (!qName.getNamespaceURI().equals(packageMappingBeanArray[i].getNamespaceURI())) continue;
            arrayList.add(packageMappingBeanArray[i].getPackageType());
        }
        if (arrayList.isEmpty()) {
            throw new WsException("unable to find pacakge mapping for: " + qName.getNamespaceURI());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getStandardSchemaHolder(QName qName) throws WsException {
        if ("base64Binary".equals(qName.getLocalPart()) || "hexBinary".equals(qName.getLocalPart()) || "base64".equals(qName.getLocalPart())) {
            return ByteArrayHolder.class.getName();
        }
        throw new WsException("Unknown standard schema type: " + qName);
    }

    private boolean isHolder(WsdlMessageMappingBean wsdlMessageMappingBean) {
        if (wsdlMessageMappingBean == null) {
            return false;
        }
        String string = wsdlMessageMappingBean.getParameterMode();
        return "OUT".equalsIgnoreCase(string) || "INOUT".equalsIgnoreCase(string);
    }

    private String methodSig(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("(");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(classArray[i].getName());
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String methodDescription(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            stringBuffer.append(methodArray[i].getName());
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void matchParameterAndPart(WsMethod wsMethod, WsdlOperation wsdlOperation, MethodParamPartsMappingBean methodParamPartsMappingBean) throws WsException {
        int n = methodParamPartsMappingBean.getParamPosition();
        WsParameterType wsParameterType = wsMethod.getParameter(n);
        if (verbose) {
            Verbose.log("WSDL java type: " + wsParameterType.getJavaType() + " JAX-RPC mapping java type: " + methodParamPartsMappingBean.getParamType());
        }
        wsParameterType.setJavaType(this.loadClass(methodParamPartsMappingBean.getParamType()));
        WsdlMessageMappingBean wsdlMessageMappingBean = methodParamPartsMappingBean.getWsdlMessageMapping();
        this.setSoapHeader(wsdlMessageMappingBean, wsParameterType);
        if ("IN".equals(wsdlMessageMappingBean.getParameterMode())) {
            this.checkInParameter(wsMethod, wsParameterType, wsdlOperation, wsdlMessageMappingBean);
        } else if ("OUT".equals(wsdlMessageMappingBean.getParameterMode())) {
            this.checkOutParameter(wsMethod, wsParameterType, wsdlOperation, wsdlMessageMappingBean);
        } else if ("INOUT".equals(wsdlMessageMappingBean.getParameterMode())) {
            this.checkInOutParameter(wsMethod, wsParameterType, wsdlOperation, wsdlMessageMappingBean);
        } else {
            throw new WsException("Parameter mode \"" + wsdlMessageMappingBean.getParameterMode() + "\"" + "is an invalid value.");
        }
        if (!wsMethod.isWrapped()) {
            WsdlMessage wsdlMessage = this.wsService.getWsdlService().getDefinitions().getMessages().get(wsdlMessageMappingBean.getWsdlMessage());
            if (wsdlMessage == null) {
                throw new WsException("Wsdl message " + wsdlMessageMappingBean.getWsdlMessage() + " for" + " Method " + wsMethod.getMethodName() + " is not found in wsdl.");
            }
            String string = wsdlMessageMappingBean.getWsdlMessagePartName();
            if (wsdlMessage.getParts().get(string) == null) {
                throw new WsException("wsdl part name " + string + " for Method \"" + wsMethod.getMethodName() + "\" is not found in wsdl message." + wsdlMessage.getName() + " Please sync up part name \"" + string + "\" defined in" + " JAXRPC mapping file with part name \"" + wsParameterType.getName() + "\" defined in wsdl.");
            }
        }
    }

    private void setSoapHeader(WsdlMessageMappingBean wsdlMessageMappingBean, WsParameterType wsParameterType) {
        if (wsdlMessageMappingBean.getSoapHeader() != null) {
            wsParameterType.setHeader(true);
        }
    }

    private void checkInOutParameter(WsMethod wsMethod, WsParameterType wsParameterType, WsdlOperation wsdlOperation, WsdlMessageMappingBean wsdlMessageMappingBean) throws WsException {
        if (wsMethod.isWrapped() && !wsParameterType.isHeader()) {
            throw new WsException("Method \"" + wsMethod.getMethodName() + "\"" + " parameter \"" + wsParameterType.getName() + "\"" + " " + " wrap style method can't use INOUT parameter.");
        }
        if (2 != wsParameterType.getMode()) {
            throw new WsException("Method \"" + wsMethod.getMethodName() + "\"" + " parameter \"" + wsParameterType.getName() + "\"" + " " + "Parameter mode is not in-sync with wsdl." + " Expected mode " + wsParameterType.getModeAsString());
        }
        QName qName = wsdlMessageMappingBean.getWsdlMessage();
        QName qName2 = wsdlOperation.getInput().getName();
        QName qName3 = wsdlOperation.getOutput().getName();
        if (!qName.equals(qName2) && !qName.equals(qName3)) {
            throw new WsException("wsdl message name for Method \"" + wsMethod.getMethodName() + "\" parameter \"" + wsParameterType.getName() + "\" is not in-sync with wsdl.");
        }
        String[] stringArray = this.getHolderClasses(wsParameterType.getJavaType().getName(), wsParameterType.getXmlName().getQName());
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = HolderUtil.NameCollisionsFilter.getInstance().filterFullName(string);
            try {
                Class clazz = this.loadClass(string);
                wsParameterType.setJavaHolderType(clazz);
                break;
            }
            catch (WsException wsException) {
                if (i != stringArray.length - 1) continue;
                throw wsException;
            }
        }
    }

    private void checkOutParameter(WsMethod wsMethod, WsParameterType wsParameterType, WsdlOperation wsdlOperation, WsdlMessageMappingBean wsdlMessageMappingBean) throws WsException {
        if (wsMethod.isWrapped() && !wsParameterType.isHeader()) {
            throw new WsException("Method \"" + wsMethod.getMethodName() + "\"" + " parameter \"" + wsParameterType.getName() + "\"" + " " + " wrap style method can't use OUT parameter.");
        }
        if (1 != wsParameterType.getMode()) {
            throw new WsException("Method \"" + wsMethod.getMethodName() + "\"" + " parameter \"" + wsParameterType.getName() + "\"" + " " + "Parameter mode is not in-sync with wsdl." + " Expected mode " + wsParameterType.getModeAsString());
        }
        QName qName = wsdlMessageMappingBean.getWsdlMessage();
        if (!wsdlOperation.getOutput().getName().equals(qName)) {
            throw new WsException("wsdl message name " + qName + " for Method \"" + wsMethod.getMethodName() + "\" parameter \"" + wsParameterType.getName() + "\" is not in-sync with wsdl. Expected message name " + wsdlOperation.getOutput().getName());
        }
        String[] stringArray = this.getHolderClasses(wsParameterType.getJavaType().getName(), wsParameterType.getXmlName().getQName());
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = HolderUtil.NameCollisionsFilter.getInstance().filterFullName(string);
            try {
                Class clazz = this.loadClass(string);
                wsParameterType.setJavaHolderType(clazz);
                break;
            }
            catch (WsException wsException) {
                if (i != stringArray.length - 1) continue;
                throw wsException;
            }
        }
    }

    private void checkInParameter(WsMethod wsMethod, WsParameterType wsParameterType, WsdlOperation wsdlOperation, WsdlMessageMappingBean wsdlMessageMappingBean) throws WsException {
        if (0 != wsParameterType.getMode()) {
            throw new WsException("Method \"" + wsMethod.getMethodName() + "\"" + " parameter \"" + wsParameterType.getName() + "\"" + " " + "Parameter mode is not in-sync with wsdl." + " Expected mode " + wsParameterType.getModeAsString());
        }
        QName qName = wsdlMessageMappingBean.getWsdlMessage();
        if (!wsdlOperation.getInput().getName().equals(qName)) {
            throw new WsException("wsdl message name " + qName + " for Method \"" + wsMethod.getMethodName() + "\" parameter \"" + wsParameterType.getName() + "\" is not in-sync with wsdl. Expected message name " + wsdlOperation.getInput());
        }
    }

    private void matchReturnAndPart(WsMethod wsMethod, WsdlOperation wsdlOperation, Method method, WsdlReturnValueMappingBean wsdlReturnValueMappingBean) throws WsException {
        if (wsMethod.getReturnType() == null) {
            if (method.getReturnType() != Void.TYPE) {
                throw new WsException("There is no return type defined in wsdl for method \"" + wsMethod.getMethodName() + "\", but in Service" + "Endpoint Inteface, there is a return type.");
            }
            if (wsdlReturnValueMappingBean != null && !"void".equals(wsdlReturnValueMappingBean.getMethodReturnValue())) {
                throw new WsException("There is no return type defined in wsdl for method \"" + wsMethod.getMethodName() + "\", but in jaxrpc mapping file, there is a return type mapping," + "with return value : " + wsdlReturnValueMappingBean.getMethodReturnValue());
            }
            return;
        }
        Class clazz = wsdlReturnValueMappingBean == null ? Void.TYPE : this.loadClass(wsdlReturnValueMappingBean.getMethodReturnValue());
        if (clazz != method.getReturnType()) {
            if (verbose) {
                Verbose.log("WSBuilderHelper.matchReturnAndPart - type != seiMethod.getReturnType()");
                Verbose.log("type = " + clazz);
                Verbose.log("classloader: " + clazz.getClassLoader());
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                Verbose.log("domain:" + protectionDomain);
                if (protectionDomain != null && protectionDomain.getCodeSource() != null) {
                    Verbose.log("loaded from :" + protectionDomain.getCodeSource().getLocation());
                }
                Verbose.log("seiMethod.getReturnType() = " + method.getReturnType());
                Verbose.log("classloader: " + method.getReturnType().getClassLoader());
                ProtectionDomain protectionDomain2 = method.getReturnType().getProtectionDomain();
                Verbose.log("domain:" + protectionDomain2);
                if (protectionDomain2 != null && protectionDomain2.getCodeSource() != null) {
                    Verbose.log("loaded from :" + protectionDomain2.getCodeSource().getLocation());
                }
            }
            throw new WsException("Method \"" + method.getName() + "\"" + " has " + clazz + " as return type in DD, and " + method.getReturnType() + " in service endpoint interface.");
        }
        wsMethod.getReturnType().setJavaType(clazz);
        if (wsdlReturnValueMappingBean != null) {
            QName qName = wsdlOperation.getOutput().getName();
            String string = wsdlReturnValueMappingBean.getWsdlMessagePartName();
            if (!qName.equals(wsdlReturnValueMappingBean.getWsdlMessage())) {
                throw new WsException("wsdl message name for Method \"" + wsMethod.getMethodName() + "\" return type \"" + string + "\" is not in-sync with wsdl.");
            }
            if (!wsMethod.isWrapped() && string != null && wsdlOperation.getOutput().getParts().get(string) == null) {
                throw new WsException("wsdl part name for Method \"" + wsMethod.getMethodName() + "\" return type \"" + string + "\" is not found in wsdl <output> message.");
            }
        }
    }

    private void populateParts(WsMethodImpl wsMethodImpl, WsdlOperation wsdlOperation, WsdlBinding wsdlBinding) {
        WsdlBindingOperation wsdlBindingOperation;
        SoapBindingOperation soapBindingOperation;
        SoapBinding soapBinding = SoapBinding.narrow(wsdlBinding);
        if (soapBinding == null) {
            soapBinding = Soap12Binding.narrow(wsdlBinding);
        }
        if ((soapBindingOperation = SoapBindingOperation.narrow(wsdlBindingOperation = wsdlBinding.getOperations().get(wsdlOperation.getName()))) == null) {
            soapBindingOperation = Soap12BindingOperation.narrow(wsdlBindingOperation);
        }
        String string = SoapBindingUtil.getStyle(soapBindingOperation, soapBinding);
        this.populateParts(wsdlOperation, wsMethodImpl, string);
        this.populateFaults(wsdlOperation.getFaults(), wsMethodImpl);
    }

    private void populateFaults(Map map, WsMethodImpl wsMethodImpl) {
        for (Map.Entry entry : map.entrySet()) {
            WsFault wsFault = new WsFault(wsMethodImpl, (String)entry.getKey(), (WsdlMessage)entry.getValue());
            wsMethodImpl.addException(wsFault);
        }
    }

    private void populateParts(WsdlOperation wsdlOperation, WsMethodImpl wsMethodImpl, String string) {
        WsParameterType wsParameterType;
        WsdlMethod wsdlMethod = wsdlOperation.getWsdlMethod(true);
        for (WsdlParameter object2 : wsdlMethod.getParameters()) {
            wsParameterType = this.createWsParameter(object2, string);
            wsMethodImpl.addParameter(wsParameterType.getName(), wsParameterType);
        }
        WsdlPart wsdlPart = wsdlMethod.getResultPart();
        if (wsdlPart != null) {
            wsParameterType = this.getPartXmlTypeName(wsdlPart);
            WsReturnType wsReturnType = new WsReturnType(wsdlPart.getName());
            wsReturnType.setXmlName((XmlTypeName)wsParameterType);
            wsMethodImpl.setReturnType(wsReturnType);
        }
    }

    private WsParameterType createWsParameter(WsdlParameter wsdlParameter, String string) {
        int n = 0;
        WsdlPart wsdlPart = wsdlParameter.getPrimaryPart();
        if (wsdlParameter.getMode() == WebParam.Mode.OUT) {
            n = 1;
        } else if (wsdlParameter.getMode() == WebParam.Mode.INOUT) {
            n = 2;
        }
        XmlTypeName xmlTypeName = this.getPartXmlTypeName(wsdlPart);
        WsParameterType wsParameterType = new WsParameterType(wsdlPart.getName(), n);
        wsParameterType.setXmlName(xmlTypeName);
        return wsParameterType;
    }

    private XmlTypeName getPartXmlTypeName(WsdlPart wsdlPart) {
        XmlTypeName xmlTypeName = wsdlPart.getType() != null ? XmlTypeName.forGlobalName((char)'t', (QName)wsdlPart.getType()) : XmlTypeName.forGlobalName((char)'e', (QName)wsdlPart.getElement());
        return xmlTypeName;
    }
}

