/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import com.bea.staxb.buildtime.WildcardUtil;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xbeanmarshal.buildtime.internal.bts.BindingFile;
import com.bea.xbeanmarshal.buildtime.internal.bts.BindingLoader;
import com.bea.xbeanmarshal.buildtime.internal.bts.BindingType;
import com.bea.xbeanmarshal.buildtime.internal.bts.BindingTypeName;
import com.bea.xbeanmarshal.buildtime.internal.bts.BuiltinBindingLoader;
import com.bea.xbeanmarshal.buildtime.internal.bts.JavaTypeName;
import com.bea.xbeanmarshal.buildtime.internal.bts.WrappedArrayType;
import com.bea.xbeanmarshal.buildtime.internal.bts.XmlBeanDocumentType;
import com.bea.xbeanmarshal.buildtime.internal.bts.XmlBeanType;
import com.bea.xbeanmarshal.buildtime.internal.bts.XmlBeansBuiltinBindingLoader;
import com.bea.xbeanmarshal.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.PortComponentHandlerBean;
import weblogic.j2ee.descriptor.ServiceInterfaceMappingBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.jws.Transactional;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.jws.wlw.WLWRollbackOnCheckedException;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.addressing.ClientAddressingHandler;
import weblogic.wsee.addressing.ServerAddressingHandler;
import weblogic.wsee.async.AsyncClientHandler;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.bind.runtime.RuntimeBindingsBuilder;
import weblogic.wsee.bind.runtime.internal.LiteralArrayHelper;
import weblogic.wsee.bind.runtime.internal.RuntimeBindingsImpl;
import weblogic.wsee.codec.soap11.SoapCodec;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.component.ejb.EjbComponent;
import weblogic.wsee.component.pojo.JavaClassComponent;
import weblogic.wsee.component.pojo.PojoTransactionHandler;
import weblogic.wsee.deploy.ClientDeployInfo;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.deploy.ServletDeployInfo;
import weblogic.wsee.handler.DirectInvokeHandler;
import weblogic.wsee.handler.GlobalHandlerChainHelper;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.handler.JaxrpcHandlerChain;
import weblogic.wsee.handler.MessageContextInitHandler;
import weblogic.wsee.handler.VersionRedirectHandler;
import weblogic.wsee.jaxrpc.Provider;
import weblogic.wsee.jws.wlw.WLWRollbackOnCheckedExceptionHandler;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.reliability.policy.WsrmPolicyClientRuntimeHandler;
import weblogic.wsee.security.AuthorizationHandler;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLSOAPFactory;
import weblogic.wsee.util.XBeanUtil;
import weblogic.wsee.ws.WSBuilderHelper;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsEndpointImpl;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsFault;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsPortImpl;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.WsServiceImpl;
import weblogic.wsee.ws.WsSkel;
import weblogic.wsee.ws.WsType;
import weblogic.wsee.ws.dispatch.client.CodecHandler;
import weblogic.wsee.ws.dispatch.client.MimeHeaderHandler;
import weblogic.wsee.ws.dispatch.server.ComponentHandler;
import weblogic.wsee.ws.dispatch.server.ConnectionHandler;
import weblogic.wsee.ws.dispatch.server.JaxrpcChainHandler;
import weblogic.wsee.ws.dispatch.server.OneWayHandler;
import weblogic.wsee.ws.dispatch.server.OperationLookupHandler;
import weblogic.wsee.ws.dispatch.server.PreinvokeHandler;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBindingUtil;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.wsee.wsdl.soap11.SoapMessageBase;
import weblogic.wsee.wsdl.soap12.Soap12Binding;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;
import weblogic.wsee.wsdl.soap12.Soap12Body;
import weblogic.xml.schema.binding.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WsBuilder {
    private static final boolean verbose = Verbose.isVerbose(WsBuilder.class);
    private static final String APACHE_XMLOBJECT_CLASSNAME = "org.apache.xmlbeans.XmlObject";
    private static final String BEA_XMLOBJECT_CLASSNAME = "com.bea.xml.XmlObject";

    WsBuilder() {
    }

    public WsService buildService(ServletDeployInfo servletDeployInfo) throws WsException {
        boolean bl = servletDeployInfo.getJwsClass().getAnnotation(UseWLW81BindingTypes.class) != null;
        PortComponentBean portComponentBean = servletDeployInfo.getPortComp();
        QName qName = portComponentBean.getWsdlPort();
        WsdlPort wsdlPort = servletDeployInfo.getWsdlDef().getPorts().get(qName);
        if (wsdlPort == null) {
            throw new WsException("There is no wsdl port named \"" + qName + "\" in deployed wsdl.");
        }
        WSBuilderHelper wSBuilderHelper = new WSBuilderHelper(servletDeployInfo.getMappingdd());
        wSBuilderHelper.setServletContext(servletDeployInfo.getServletContext());
        WsServiceImpl wsServiceImpl = wSBuilderHelper.buildService(wsdlPort, true);
        this.createRuntimeBindingProvider(wsServiceImpl, this.getThreadTylar(), servletDeployInfo.getMappingdd(), servletDeployInfo.getWsdlDef(), bl);
        this.verifySEI(wsServiceImpl, portComponentBean);
        this.setInternalServerHandler(wsServiceImpl, portComponentBean, servletDeployInfo);
        this.setComponent(wsServiceImpl.getPort(qName.getLocalPart()), servletDeployInfo);
        ((WsEndpointImpl)wsServiceImpl.getPort(qName.getLocalPart()).getEndpoint()).setJwsClass(servletDeployInfo.getJwsClass());
        wsServiceImpl.setWssPolicyContext(servletDeployInfo.getWssPolicyContext());
        WsBuilder.createSoapDispatchMap((WsPortImpl)wsServiceImpl.getPort(qName.getLocalPart()), portComponentBean);
        WsPort wsPort = wsServiceImpl.getPort(qName.getLocalPart());
        wsPort.setPortComponent(servletDeployInfo.getWlPortComp());
        return wsServiceImpl;
    }

    public WsServiceImpl buildService(EJBDeployInfo eJBDeployInfo) throws WsException {
        PortComponentBean portComponentBean = eJBDeployInfo.getPortComp();
        QName qName = portComponentBean.getWsdlPort();
        WsdlPort wsdlPort = eJBDeployInfo.getWsdlDef().getPorts().get(qName);
        if (wsdlPort == null) {
            throw new WsException("There is no wsdl port named \"" + qName + "\" in deployed wsdl.");
        }
        WSBuilderHelper wSBuilderHelper = new WSBuilderHelper(eJBDeployInfo.getMappingdd());
        WsServiceImpl wsServiceImpl = wSBuilderHelper.buildService(wsdlPort, true);
        this.createRuntimeBindingProvider(wsServiceImpl, null, eJBDeployInfo.getMappingdd(), eJBDeployInfo.getWsdlDef(), false);
        this.verifySEI(wsServiceImpl, portComponentBean);
        this.setInternalServerHandler(wsServiceImpl, portComponentBean, eJBDeployInfo);
        this.setComponent(wsServiceImpl.getPort(qName.getLocalPart()), eJBDeployInfo);
        ((WsEndpointImpl)wsServiceImpl.getPort(qName.getLocalPart()).getEndpoint()).setJwsClass(eJBDeployInfo.getJwsClass());
        wsServiceImpl.setWssPolicyContext(eJBDeployInfo.getWssPolicyContext());
        WsBuilder.createSoapDispatchMap((WsPortImpl)wsServiceImpl.getPort(qName.getLocalPart()), portComponentBean);
        WsPort wsPort = wsServiceImpl.getPort(qName.getLocalPart());
        wsPort.setPortComponent(eJBDeployInfo.getWlPortComp());
        return wsServiceImpl;
    }

    public WsService buildService(ClientDeployInfo clientDeployInfo) throws WsException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        block7: {
            bl = false;
            try {
                object4 = clientDeployInfo.getMappingdd();
                if (object4 != null && (object3 = object4.getServiceInterfaceMappings()) != null && ((ServiceInterfaceMappingBean[])object3).length >= 0) {
                    object2 = object3[0].getServiceInterface();
                    object = JamUtil.loadJClass((String)object2, Thread.currentThread().getContextClassLoader());
                    bl = object.getAnnotation(UseWLW81BindingTypes.class) != null;
                }
            }
            catch (Exception exception) {
                if (!verbose) break block7;
                Verbose.log("Could not determine if UseWLW81BindingTypes is present, assuming false. " + exception);
            }
        }
        object4 = new WSBuilderHelper(clientDeployInfo.getMappingdd());
        object3 = clientDeployInfo.getServiceName();
        assert (object3 != null);
        object2 = clientDeployInfo.getWsdlDef();
        object = object2.getServices().get(object3);
        if (object == null) {
            Verbose.log(object2);
            throw new WsException("Unable to find wsdl service for service name: " + object3);
        }
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = clientDeployInfo.getWlServiceRef();
        WsServiceImpl wsServiceImpl = ((WSBuilderHelper)object4).buildService((WsdlService)object, serviceReferenceDescriptionBean != null ? serviceReferenceDescriptionBean.getPortInfos() : null, false);
        if (clientDeployInfo.getRuntimeBindings() != null) {
            wsServiceImpl.setBindingProvider(clientDeployInfo.getRuntimeBindings());
            this.completeTypeInfo(wsServiceImpl);
        } else {
            this.createRuntimeBindingProvider(wsServiceImpl, null, clientDeployInfo.getMappingdd(), clientDeployInfo.getWsdlDef(), bl);
        }
        WsdlPolicySubject wsdlPolicySubject = new WsdlPolicySubject((WsdlDefinitions)object2);
        WssPolicyContext wssPolicyContext = new WssPolicyContext(false);
        wssPolicyContext.getPolicyServer().addPolicies(wsdlPolicySubject.getPolicies());
        wsServiceImpl.setWssPolicyContext(wssPolicyContext);
        this.setInternalClientHandler(wsServiceImpl, clientDeployInfo.getServiceRef());
        return wsServiceImpl;
    }

    private static void createSoapDispatchMap(WsPortImpl wsPortImpl, PortComponentBean portComponentBean) throws WsException {
        HashMap<Name, QName> hashMap = new HashMap<Name, QName>();
        HashMap<String, Map<Name, QName>> hashMap2 = new HashMap<String, Map<Name, QName>>();
        WsdlPort wsdlPort = wsPortImpl.getWsdlPort();
        SOAPFactory sOAPFactory = WLSOAPFactory.createSOAPFactory();
        for (WsdlOperation wsdlOperation : wsdlPort.getPortType().getOperations().values()) {
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(wsdlOperation.getName());
            SoapBinding soapBinding = SoapBinding.narrow(wsdlBindingOperation.getBinding());
            if (soapBinding == null) {
                soapBinding = Soap12Binding.narrow(wsdlBindingOperation.getBinding());
            }
            if (soapBinding == null) continue;
            SoapBindingOperation soapBindingOperation = SoapBindingOperation.narrow(wsdlBindingOperation);
            if (soapBindingOperation == null) {
                soapBindingOperation = Soap12BindingOperation.narrow(wsdlBindingOperation);
            }
            if (soapBindingOperation == null) continue;
            String string = SoapBindingUtil.getStyle(soapBindingOperation, soapBinding);
            try {
                Name name;
                Serializable serializable;
                Object object;
                Object object2;
                if ("rpc".equals(string)) {
                    object2 = wsdlBindingOperation.getInput();
                    object = SoapBody.narrow((WsdlBindingMessage)object2);
                    if (object == null) {
                        object = Soap12Body.narrow((WsdlBindingMessage)object2);
                    }
                    serializable = wsdlOperation.getName();
                    name = sOAPFactory.createName(serializable.getLocalPart(), null, ((SoapMessageBase)object).getNamespace());
                } else {
                    object2 = wsPortImpl.getEndpoint().getMethod(wsdlOperation.getName().getLocalPart());
                    if (((WsMethod)object2).isWrapped()) {
                        object = ((WsMethod)object2).getWrapperElement();
                        name = sOAPFactory.createName(((QName)object).getLocalPart(), null, ((QName)object).getNamespaceURI());
                    } else if (!((WsMethod)object2).getParameters().hasNext()) {
                        name = SoapCodec.VOID_NAME_KEY;
                    } else {
                        object = ((WsMethod)object2).getParameter(0).getXmlName().getQName();
                        serializable = wsPortImpl.getEndpoint().getEndpointInterface();
                        if (serializable == null) {
                            serializable = WsBuilder.loadClass(portComponentBean.getServiceEndpointInterface());
                        }
                        if (!WsBuilder.isGenericService((Class)serializable) && ((WsMethod)object2).getParameterSize() > 1) {
                            for (int i = 1; i < ((WsMethod)object2).getParameterSize(); ++i) {
                                WsParameterType wsParameterType = ((WsMethod)object2).getParameter(i);
                                if (wsParameterType.isHeader() || wsParameterType.getMode() != 0 || WsBuilder.isAttachmentParam(wsParameterType.getJavaType().getName())) continue;
                                object = wsParameterType.getXmlName().getQName();
                                break;
                            }
                        }
                        name = sOAPFactory.createName(((QName)object).getLocalPart(), null, ((QName)object).getNamespaceURI());
                    }
                }
                WsBuilder.buildActionDispatchMap(wsdlOperation, hashMap2, name);
                hashMap.put(name, wsdlOperation.getName());
            }
            catch (SOAPException sOAPException) {
                throw new WsException(sOAPException.getMessage(), sOAPException);
            }
        }
        hashMap2.put("", hashMap);
        hashMap2.put(null, hashMap);
        wsPortImpl.setActionDispatchMap(hashMap2);
        wsPortImpl.setSoapDispatchMap(hashMap);
    }

    private static void buildActionDispatchMap(WsdlOperation wsdlOperation, Map<String, Map<Name, QName>> map, Name name) {
        String string = wsdlOperation.getInputAction();
        if (!StringUtil.isEmpty(string)) {
            Map<Name, QName> map2 = map.get(string);
            if (map2 == null) {
                map2 = new HashMap<Name, QName>();
                map.put(string, map2);
            }
            map2.put(name, wsdlOperation.getName());
        }
    }

    private static boolean isAttachmentParam(String string) {
        return "javax.activation.DataHandler".equals(string) || "[Ljavax.activation.DataHandler;".equals(string) || "javax.xml.transform.Source".equals(string) || "[Ljavax.xml.transform.Source;".equals(string) || "javax.mail.internet.MimeMultipart".equals(string) || "[Ljavax.mail.internet.MimeMultipart;".equals(string) || "java.awt.Image".equals(string) || "[Ljava.awt.Image;".equals(string);
    }

    private void createRuntimeBindingProvider(WsServiceImpl wsServiceImpl, Tylar tylar, JavaWsdlMappingBean javaWsdlMappingBean, WsdlDefinitions wsdlDefinitions, boolean bl) throws WsException {
        Object object;
        RuntimeBindingsBuilder runtimeBindingsBuilder = RuntimeBindingsBuilder.Factory.newInstance();
        if (wsdlDefinitions.getTypes() != null && wsdlDefinitions.getTypes().getSchemaArray() != null) {
            object = wsdlDefinitions.getTypes().getSchemaArrayWithoutImport();
            for (int i = 0; i < ((SchemaDocument[])object).length; ++i) {
                runtimeBindingsBuilder.addSchema(object[i]);
            }
            if (verbose) {
                Verbose.log("Found schema docs: " + ((SchemaDocument[])object).length);
            }
        }
        runtimeBindingsBuilder.set109Mappings(javaWsdlMappingBean);
        runtimeBindingsBuilder.setWsdl(wsdlDefinitions);
        runtimeBindingsBuilder.setTreatEnumsAsSimpleTypes(bl);
        if (tylar != null) {
            runtimeBindingsBuilder.addTylar(tylar);
        }
        this.addTypesToBuilder(wsServiceImpl, runtimeBindingsBuilder);
        try {
            object = runtimeBindingsBuilder.createRuntimeBindings();
            wsServiceImpl.setBindingProvider((RuntimeBindings)object);
        }
        catch (IOException iOException) {
            throw new WsException("Failed to create binding provider " + iOException, iOException);
        }
        catch (XmlException xmlException) {
            throw new WsException("Failed to create binding provider " + (Object)((Object)xmlException), xmlException);
        }
        this.completeTypeInfo(wsServiceImpl);
    }

    private BuiltinBindingLoader getXmlBeansBuiltinBindings() {
        return XmlBeansBuiltinBindingLoader.getInstance();
    }

    private void createXmlBeansBindings(WsServiceImpl wsServiceImpl) throws WsException {
        Set set = this.getAllXmlBeansTypes(wsServiceImpl);
        Iterator iterator = set.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        BindingFile bindingFile = new BindingFile();
        while (iterator.hasNext()) {
            WsType wsType = (WsType)iterator.next();
            if (wsType.isXmlObjectForTypeOrDocument()) {
                this.addXmlObject(wsType, wsServiceImpl, bindingFile);
                continue;
            }
            if (!wsType.isArrayOfXmlObjectForType() && !wsType.isArrayOfXmlObjectForDocument()) continue;
            this.addXmlBeanArray(wsType, bindingFile, wsServiceImpl);
        }
        ((RuntimeBindingsImpl)wsServiceImpl.getBindingProvider()).setXmlBeansBindingLoader((BindingLoader)bindingFile);
    }

    private void addXmlBeanArray(WsType wsType, BindingFile bindingFile, WsServiceImpl wsServiceImpl) throws WsException {
        com.bea.staxb.buildtime.internal.bts.XmlTypeName xmlTypeName = wsType.getXmlName();
        int n = 1;
        Class<?> clazz = wsType.getJavaType().getComponentType();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        String string = clazz.getName();
        if ((string.equals(APACHE_XMLOBJECT_CLASSNAME) || string.equals(BEA_XMLOBJECT_CLASSNAME)) && xmlTypeName.isElementWildcardArrayType()) {
            if (n != 1) {
                throw new IllegalArgumentException("WLS runtime cannot handle arrays of XmlObject mapped to the Element Wildcard <any maxOccurs='unbounded'/> of dimension other than 1.   We've encountered an array of XmlObject of dimension '" + n + "' and most abort deployment.");
            }
            WrappedArrayType wrappedArrayType = WrappedArrayType.wrappedArrayTypeFor(clazz);
            bindingFile.addBindingType((BindingType)wrappedArrayType, true, true);
            return;
        }
        JavaTypeName javaTypeName = JavaTypeName.forClassName((String)wsType.getJavaType().getName());
        SchemaType schemaType = wsServiceImpl.getBindingProvider().getSchemaTypeForXmlTypeName(wsType.getXmlName());
        if (!LiteralArrayHelper.isLiteralArray(schemaType)) {
            throw new IllegalArgumentException(" array of XmlBeans type '" + wsType.getJavaType().getName() + "' is NOT a literal array (perhaps it's a SOAP Encoded array) " + "non-literal arrays are not implemented.");
        }
        this.addLiteralArrayToXBeansBindingFile(bindingFile, wsType.getJavaType(), javaTypeName, schemaType);
    }

    private void addXmlObject(WsType wsType, WsServiceImpl wsServiceImpl, BindingFile bindingFile) {
        XmlTypeName xmlTypeName;
        JavaTypeName javaTypeName = JavaTypeName.forClassName((String)wsType.getJavaType().getName());
        com.bea.staxb.buildtime.internal.bts.XmlTypeName xmlTypeName2 = wsType.getXmlName();
        if (xmlTypeName2.isElement()) {
            xmlTypeName2 = com.bea.staxb.buildtime.internal.bts.XmlTypeName.forNestedAnonymous((char)'t', (com.bea.staxb.buildtime.internal.bts.XmlTypeName)xmlTypeName2);
        }
        SchemaType schemaType = wsServiceImpl.getBindingProvider().getSchemaTypeForXmlTypeName(xmlTypeName2);
        QName qName = xmlTypeName2.getQName();
        if (qName != null && (xmlTypeName = XmlTypeName.forTypeNamed((QName)qName)) != null && this.getXmlBeansBuiltinBindings().lookupPojoFor(xmlTypeName) != null) {
            return;
        }
        this.addXmlObjectToXBeansBindingFile(bindingFile, wsType.getJavaType(), javaTypeName, schemaType);
    }

    private void addLiteralArrayToXBeansBindingFile(BindingFile bindingFile, Class clazz, JavaTypeName javaTypeName, SchemaType schemaType) throws WsException {
        if (!clazz.isArray()) {
            throw new WsException("ERROR !  While creating XmlBeans Binding Types,  attempted to process as a Literal Array Type, the javaClass '" + clazz.getName() + "' which is NOT an array.  " + "The corresponding JavaTypeName is '" + javaTypeName + "'");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        JavaTypeName javaTypeName2 = javaTypeName.getArrayTypeMinus1Dim(javaTypeName.getArrayDepth());
        SchemaType schemaType2 = LiteralArrayHelper.getLiteralArrayItemType(schemaType);
        XmlTypeName xmlTypeName2 = XmlTypeName.forSchemaType((SchemaType)schemaType2);
        BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName2, (XmlTypeName)xmlTypeName2);
        WrappedArrayType wrappedArrayType = new WrappedArrayType(bindingTypeName);
        SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
        QName qName = schemaPropertyArray[0].getName();
        wrappedArrayType.setItemName(qName);
        wrappedArrayType.setItemType(bindingTypeName2);
        wrappedArrayType.setItemNillable(true);
        if (verbose) {
            Verbose.log("\n for BTN '" + bindingTypeName + "' created xbean WrappedArrayType '" + wrappedArrayType + "'  itemQName='" + qName + "' and itemBtn='" + bindingTypeName2 + "'\n");
        }
        bindingFile.addBindingType((BindingType)wrappedArrayType, true, true);
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new WsException("Unexpected Condition while building xmlBeans bindings for arrays.  For java array class '" + clazz.getName() + "' we got a NULL array item java class when we didn't expect one.");
        }
        if (javaTypeName2.getArrayDepth() > 0) {
            this.addLiteralArrayToXBeansBindingFile(bindingFile, clazz2, javaTypeName2, schemaType2);
        } else if (javaTypeName2.getArrayDepth() == 0) {
            this.addXmlObjectToXBeansBindingFile(bindingFile, clazz2, javaTypeName2, schemaType2);
        }
    }

    private void addXmlObjectToXBeansBindingFile(BindingFile bindingFile, Class clazz, JavaTypeName javaTypeName, SchemaType schemaType) {
        if (this.getXmlBeansBuiltinBindings().lookupTypeFor(javaTypeName) != null) {
            if (verbose) {
                Verbose.log(" javaTypeName '" + javaTypeName + "' is an XmlBeans builtin.  Skipping explicit type bind.");
            }
            return;
        }
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        if (XBeanUtil.xmlBeanIsDocumentType(clazz)) {
            if (verbose) {
                Verbose.log("\n adding XmlBeanDocumentType to xbeanBindings for '" + bindingTypeName + "'\n");
            }
            XmlBeanDocumentType xmlBeanDocumentType = new XmlBeanDocumentType(bindingTypeName);
            bindingFile.addBindingType((BindingType)xmlBeanDocumentType, true, true);
        } else if (XBeanUtil.isXmlBean(clazz)) {
            if (verbose) {
                Verbose.log("\n adding XmlBeanType to xbeanBindings for '" + bindingTypeName + "'\n");
            }
            XmlBeanType xmlBeanType = new XmlBeanType(bindingTypeName);
            bindingFile.addBindingType((BindingType)xmlBeanType, true, true);
        } else {
            throw new IllegalArgumentException(" Unexpected type '" + clazz.getName() + "' encountered while building XmlBeansBindings for Xml[Document]Object");
        }
    }

    private Set getAllXmlBeansTypes(WsService wsService) {
        HashSet<WsType> hashSet = new HashSet<WsType>();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            WsEndpoint wsEndpoint = wsPort.getEndpoint();
            if (wsEndpoint == null) continue;
            Iterator iterator2 = wsEndpoint.getMethods();
            while (iterator2.hasNext()) {
                WsMethod wsMethod = (WsMethod)iterator2.next();
                WsReturnType wsReturnType = wsMethod.getReturnType();
                if (wsReturnType != null && wsReturnType.isAnyXmlObject()) {
                    hashSet.add(wsReturnType);
                }
                Iterator iterator3 = wsMethod.getParameters();
                while (iterator3.hasNext()) {
                    WsParameterType wsParameterType = (WsParameterType)iterator3.next();
                    if (!wsParameterType.isAnyXmlObject()) continue;
                    hashSet.add(wsParameterType);
                }
            }
        }
        return hashSet;
    }

    private void verifySEI(WsService wsService, PortComponentBean portComponentBean) throws WsException {
        WsEndpoint wsEndpoint = (WsEndpoint)wsService.getEndpoints().next();
        Class clazz = wsEndpoint.getEndpointInterface();
        if (clazz != null) {
            if (!clazz.getName().equals(portComponentBean.getServiceEndpointInterface())) {
                throw new WsException("Service endpoint inteface " + portComponentBean.getServiceEndpointInterface() + " specified in webservcies.xml is not matched with " + "Jaxrpc mapping file " + clazz.getName());
            }
        } else {
            clazz = WsBuilder.loadClass(portComponentBean.getServiceEndpointInterface());
            if (WsBuilder.isGenericService(clazz)) {
                return;
            }
            ((WsEndpointImpl)wsEndpoint).setEndpointInterface(clazz);
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                WsMethod wsMethod = wsEndpoint.getMethod(methodArray[i].getName());
                if (wsMethod == null) {
                    throw new WsException("Method " + methodArray[i].getName() + " is " + "not found in wsdl");
                }
                this.verifyParamType(wsMethod, methodArray[i]);
            }
        }
    }

    private void verifyParamType(WsMethod wsMethod, Method method) throws WsException {
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        Iterator iterator = wsMethod.getParameters();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            if (n < classArray.length) {
                if (classArray[n] != wsParameterType.getJavaType()) {
                    throw new WsException("Java type mismatch. For method " + method.getName() + " parameter" + wsParameterType.getName() + " SEI's type: " + classArray[n] + " type" + " defered from wsdl:" + wsParameterType.getJavaType());
                }
            } else {
                throw new WsException("For method " + method.getName() + " wsdl has" + " more parts defined than in service endpoint interface.");
            }
            ++n;
        }
        if (n < classArray.length) {
            throw new WsException("For method " + method.getName() + " wsdl has" + " less parts defined than in service endpoint interface.");
        }
    }

    private void addTypesToBuilder(WsService wsService, RuntimeBindingsBuilder runtimeBindingsBuilder) {
        Iterator iterator = wsService.getEndpoints();
        while (iterator.hasNext()) {
            WsEndpoint wsEndpoint = (WsEndpoint)iterator.next();
            Iterator iterator2 = wsEndpoint.getMethods();
            while (iterator2.hasNext()) {
                WsMethod wsMethod = (WsMethod)iterator2.next();
                Object object = wsMethod.getParameters();
                while (object.hasNext()) {
                    WsParameterType wsParameterType = (WsParameterType)object.next();
                    this.addParamType(wsMethod, runtimeBindingsBuilder, wsParameterType);
                }
                object = wsMethod.getReturnType();
                if (object == null || Void.TYPE == ((WsType)object).getJavaType()) continue;
                this.addParamType(wsMethod, runtimeBindingsBuilder, (WsType)object);
            }
        }
    }

    private void addParamType(WsMethod wsMethod, RuntimeBindingsBuilder runtimeBindingsBuilder, WsType wsType) {
        if (wsMethod.isWrapped() && !wsType.isHeader()) {
            runtimeBindingsBuilder.addLocalElementToBind(wsType.getXmlName().getQName(), wsType.getName(), wsType.getJavaType());
        } else {
            com.bea.staxb.buildtime.internal.bts.XmlTypeName xmlTypeName = wsType.getXmlName();
            if (xmlTypeName.isElement()) {
                if (!WsBuilder.isXmlBean(wsType.getJavaType())) {
                    runtimeBindingsBuilder.addGlobalElementToBind(xmlTypeName.getQName(), wsType.getJavaType());
                }
            } else if (!"http://www.bea.com/servers/wls90/wsee/attachment".equals(xmlTypeName.getQName().getNamespaceURI()) && !WsBuilder.isXmlBean(wsType.getJavaType())) {
                runtimeBindingsBuilder.addGlobalTypeToBind(xmlTypeName.getQName(), wsType.getJavaType());
            }
        }
    }

    private static boolean isXmlBean(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            return WsBuilder.isXmlBean(clazz2);
        }
        if (XmlObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            Class<?> clazz3;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null && (clazz3 = classLoader.loadClass(APACHE_XMLOBJECT_CLASSNAME)) != null && clazz3.isAssignableFrom(clazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private void completeTypeInfo(WsServiceImpl wsServiceImpl) throws WsException {
        RuntimeBindings runtimeBindings = wsServiceImpl.getBindingProvider();
        Iterator<WsPort> iterator = wsServiceImpl.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            WsEndpoint wsEndpoint = wsPort.getEndpoint();
            if (wsEndpoint == null) continue;
            Iterator iterator2 = wsEndpoint.getMethods();
            while (iterator2.hasNext()) {
                Object object;
                WsMethod wsMethod = (WsMethod)iterator2.next();
                Object object2 = wsMethod.getParameters();
                while (object2.hasNext()) {
                    object = (WsParameterType)object2.next();
                    this.fillParamType(wsMethod, (WsType)object, runtimeBindings);
                }
                object2 = wsMethod.getReturnType();
                if (object2 != null && Void.TYPE != ((WsType)object2).getJavaType()) {
                    this.fillParamType(wsMethod, (WsType)object2, runtimeBindings);
                }
                object = wsMethod.getExceptions();
                while (object.hasNext()) {
                    WsFault wsFault = (WsFault)object.next();
                    WsdlMessage wsdlMessage = wsFault.getFaultMessage();
                    Iterator<? extends WsdlPart> iterator3 = wsdlMessage.getParts().values().iterator();
                    if (iterator3.hasNext()) {
                        WsdlPart wsdlPart = iterator3.next();
                        if (wsdlPart != null) {
                            QName qName = wsdlPart.getType();
                            if (qName == null) {
                                QName qName2 = wsdlPart.getElement();
                                if (qName2 != null) {
                                    qName = runtimeBindings.getTypeForElement(qName2);
                                } else if (verbose) {
                                    Verbose.log(" WARNING !  In WsService " + wsServiceImpl + "\n, WsEndpoint " + wsEndpoint + "\n, WsMethod " + wsMethod + "\n, WsFault " + wsFault + "\n, WsdlPart " + wsdlPart + "\n  the WSDL fault part has neither an 'element' nor a 'type' attribute !\n");
                                }
                            }
                            if (qName != null) {
                                wsFault.setMarshalPropertyQName(qName);
                                if (runtimeBindings.isSimpleType(qName)) {
                                    wsFault.setIsSimpleType(true);
                                } else {
                                    wsFault.setIsSimpleType(false);
                                }
                                wsFault.computeMarshalProperty();
                                if (!verbose) continue;
                                Verbose.log("+++faultType '" + qName + ", marshalProperty setting is " + wsFault.marshalProperty());
                                continue;
                            }
                            if (!verbose) continue;
                            Verbose.log(" WARNING !  In WsService " + wsServiceImpl + "\n, WsEndpoint " + wsEndpoint + "\n, WsMethod " + wsMethod + "\n, WsFault " + wsFault + "\n, WsdlPart " + wsdlPart + "\n +++  COULD NOT GET QNAME of TYPE for the either " + "the 'element' or 'type' attribute !\n");
                            continue;
                        }
                        if (!verbose) continue;
                        Verbose.log(" WARNING !  In WsService " + wsServiceImpl + "\n, WsEndpoint " + wsEndpoint + "\n, WsMethod " + wsMethod + "\n, WsFault " + wsFault + "+++  COULD NOT FIND a PART for FAULT:  " + wsFault);
                        continue;
                    }
                    if (!verbose) continue;
                    Verbose.log(" WARNING !  In WsService " + wsServiceImpl + "\n, WsEndpoint " + wsEndpoint + "\n, WsMethod " + wsMethod + "\n, WsFault " + wsFault + "+++  COULD NOT FIND a PART for FAULT:  " + wsFault);
                }
            }
        }
        this.createXmlBeansBindings(wsServiceImpl);
    }

    private void fillParamType(WsMethod wsMethod, WsType wsType, RuntimeBindings runtimeBindings) throws WsException {
        if (wsMethod.isWrapped() && !wsType.isHeader()) {
            com.bea.staxb.buildtime.internal.bts.XmlTypeName xmlTypeName = wsType.getXmlName();
            wsType.setOptionalElement(runtimeBindings.isOptionalLocalElement(xmlTypeName, wsType.getName(), wsMethod, wsType));
            if (runtimeBindings.elementIsSingleWildcard(xmlTypeName) == 1) {
                wsType.setXmlName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardType());
                wsType.setElementName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardElement().getQName());
            } else if (runtimeBindings.elementIsSingleWildcard(xmlTypeName) == 2) {
                wsType.setXmlName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardArrayType());
                wsType.setElementName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardArrayElement().getQName());
            } else if (StringUtil.isEmpty(wsType.getName()) && WildcardUtil.WILDCARD_CLASSNAMES.contains(wsType.getJavaType().getCanonicalName())) {
                if (wsType.getJavaType().isArray()) {
                    wsType.setXmlName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardArrayType());
                    wsType.setElementName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardArrayElement().getQName());
                } else {
                    wsType.setXmlName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardType());
                    wsType.setElementName(com.bea.staxb.buildtime.internal.bts.XmlTypeName.forElementWildCardElement().getQName());
                }
            } else {
                try {
                    runtimeBindings.getLocalElementType(xmlTypeName, wsType.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                wsType.setXmlName(runtimeBindings.getLocalElementType(xmlTypeName, wsType.getName()));
                wsType.setElementName(runtimeBindings.getLocalElementName(xmlTypeName, wsType.getName()));
            }
        } else if (wsType.getJavaType() == null) {
            wsType.setJavaType(WsBuilder.loadClass(runtimeBindings.getJavaType(wsType.getXmlName())));
        }
    }

    private void setComponent(WsPort wsPort, ServletDeployInfo servletDeployInfo) throws WsException {
        Class clazz = servletDeployInfo.getJwsClass();
        WsSkel wsSkel = (WsSkel)wsPort.getEndpoint();
        try {
            wsSkel.setComponent(new JavaClassComponent(clazz, servletDeployInfo.getServletContext()));
            if (!WsBuilder.isGenericService(clazz)) {
                this.registerOperation(wsSkel);
            }
            this.setDefaultMethod(clazz);
        }
        catch (ComponentException componentException) {
            throw new WsException("Failed to create component", componentException);
        }
    }

    private void setDefaultMethod(Class clazz) {
        if (WsBuilder.isGenericService(clazz) && verbose) {
            Verbose.log("This is a generic service with default method 'invoke'");
        }
    }

    private static boolean isGenericService(Class clazz) {
        return Provider.class.isAssignableFrom(clazz);
    }

    private void setComponent(WsPort wsPort, EJBDeployInfo eJBDeployInfo) throws WsException {
        WsSkel wsSkel = (WsSkel)wsPort.getEndpoint();
        try {
            Class clazz = wsPort.getEndpoint().getEndpointInterface();
            wsSkel.setComponent(new EjbComponent(eJBDeployInfo.getBeanFactory(), clazz));
            this.registerOperation(wsSkel);
            this.setDefaultMethod(clazz);
        }
        catch (ComponentException componentException) {
            throw new WsException("Failed to create component " + componentException, componentException);
        }
    }

    private void registerOperation(WsSkel wsSkel) throws ComponentException {
        Iterator iterator = wsSkel.getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            wsSkel.getComponent().registerOperation(wsMethod.getOperationName().getLocalPart(), wsMethod.getMethodName(), this.toClassArray(wsMethod.getParameters()));
        }
    }

    private Class[] toClassArray(Iterator iterator) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            arrayList.add(wsParameterType.getJavaType());
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private void setInternalClientHandler(WsService wsService, ServiceRefBean serviceRefBean) throws WsException {
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerListImpl handlerListImpl = new HandlerListImpl();
            try {
                if (serviceRefBean != null) {
                    if (verbose) {
                        Verbose.log("Got Service Ref");
                    }
                    this.checkHandlerPortName(wsService, serviceRefBean.getHandlers());
                    JaxrpcHandlerChain jaxrpcHandlerChain = this.createJaxrpcHandlerChain(serviceRefBean.getHandlers(), wsPort.getWsdlPort().getName().getLocalPart());
                    this.createClientHandlerInfo(jaxrpcHandlerChain, handlerListImpl, wsService.isUsingPolicy());
                } else {
                    this.createClientHandlerInfo(null, handlerListImpl, wsService.isUsingPolicy());
                }
            }
            catch (HandlerException handlerException) {
                throw new WsException("Failed to create handler chain", handlerException);
            }
            wsPort.setInternalHandlerList(handlerListImpl);
        }
    }

    private void checkHandlerPortName(WsService wsService, ServiceRefHandlerBean[] serviceRefHandlerBeanArray) throws WsException {
        if (serviceRefHandlerBeanArray == null) {
            return;
        }
        for (int i = 0; i < serviceRefHandlerBeanArray.length; ++i) {
            String[] stringArray = serviceRefHandlerBeanArray[i].getPortNames();
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (wsService.getPort(stringArray[j]) != null) continue;
                throw new WsException("port name \"" + stringArray[i] + "\" " + "referenced by handler \"" + serviceRefHandlerBeanArray[i].getHandlerName() + "\"" + " is not defined in wsdl");
            }
        }
    }

    private void setInternalServerHandler(WsService wsService, PortComponentBean portComponentBean, DeployInfo deployInfo) throws WsException {
        JaxrpcHandlerChain jaxrpcHandlerChain = null;
        try {
            jaxrpcHandlerChain = this.createJaxrpcHandlerChain(portComponentBean.getHandlers());
        }
        catch (HandlerException handlerException) {
            throw new WsException("Failed to create handler chain", handlerException);
        }
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerListImpl handlerListImpl = null;
            try {
                handlerListImpl = new HandlerListImpl();
                this.createServerHandlerInfo(jaxrpcHandlerChain, handlerListImpl, wsService.isUsingPolicy(), deployInfo);
            }
            catch (HandlerException handlerException) {
                throw new WsException("Failed to create handler chain", handlerException);
            }
            wsPort.setInternalHandlerList(handlerListImpl);
        }
    }

    private JaxrpcHandlerChain createJaxrpcHandlerChain(ServiceRefHandlerBean[] serviceRefHandlerBeanArray, String string) throws WsException, HandlerException {
        Object object;
        if (serviceRefHandlerBeanArray == null || serviceRefHandlerBeanArray.length == 0) {
            if (verbose) {
                Verbose.log("No handler found");
            }
            return null;
        }
        ArrayList<HandlerInfo> arrayList = new ArrayList<HandlerInfo>(serviceRefHandlerBeanArray.length);
        for (int i = 0; i < serviceRefHandlerBeanArray.length; ++i) {
            if (!this.containName(serviceRefHandlerBeanArray[i].getPortNames(), string)) continue;
            String string2 = serviceRefHandlerBeanArray[i].getHandlerClass();
            object = serviceRefHandlerBeanArray[i].getSoapHeaders();
            Object object2 = this.buildInitParams(serviceRefHandlerBeanArray[i].getInitParams());
            arrayList.add(new HandlerInfo(WsBuilder.loadClass(string2), (Map)object2, (QName[])object));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        HandlerListImpl handlerListImpl = new HandlerListImpl();
        int n = 0;
        for (Object object2 : arrayList) {
            handlerListImpl.add("USER-HANDLER[" + n + "]", (HandlerInfo)object2);
            ++n;
        }
        object = new JaxrpcHandlerChain(handlerListImpl);
        ((JaxrpcHandlerChain)object).setServerSide(false);
        return object;
    }

    private boolean containName(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private JaxrpcHandlerChain createJaxrpcHandlerChain(PortComponentHandlerBean[] portComponentHandlerBeanArray) throws WsException, HandlerException {
        ArrayList<HandlerInfo> arrayList;
        HandlerListImpl handlerListImpl = new HandlerListImpl();
        int n = 0;
        List list = GlobalHandlerChainHelper.getInstance().getInboundHandlerInfos();
        for (HandlerInfo handlerInfo : list) {
            handlerListImpl.add("GLOBAL-INBOUND-HANDLER[" + n + "]", handlerInfo);
            ++n;
        }
        if (portComponentHandlerBeanArray != null && portComponentHandlerBeanArray.length > 0) {
            arrayList = new ArrayList<HandlerInfo>(portComponentHandlerBeanArray.length);
            for (int i = 0; i < portComponentHandlerBeanArray.length; ++i) {
                String string = portComponentHandlerBeanArray[i].getHandlerClass();
                QName[] qNameArray = portComponentHandlerBeanArray[i].getSoapHeaders();
                Map map = this.buildInitParams(portComponentHandlerBeanArray[i].getInitParams());
                arrayList.add(new HandlerInfo(WsBuilder.loadClass(string), map, qNameArray));
            }
            n = 0;
            for (HandlerInfo handlerInfo : arrayList) {
                handlerListImpl.add("USER-HANDLER[" + n + "]", handlerInfo);
                ++n;
            }
        }
        if (handlerListImpl.size() == 0) {
            return null;
        }
        arrayList = new JaxrpcHandlerChain(handlerListImpl);
        ((JaxrpcHandlerChain)((Object)arrayList)).setServerSide(false);
        return arrayList;
    }

    private Map buildInitParams(ParamValueBean[] paramValueBeanArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (paramValueBeanArray == null) {
            return hashMap;
        }
        for (int i = 0; i < paramValueBeanArray.length; ++i) {
            String string = paramValueBeanArray[i].getParamName();
            String string2 = paramValueBeanArray[i].getParamValue();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private static boolean isTransactional(Class clazz) {
        Object object;
        boolean bl = false;
        if (clazz == null) {
            return false;
        }
        if (clazz.getAnnotation(Transactional.class) != null && (object = clazz.getAnnotation(Transactional.class)).value()) {
            return true;
        }
        object = clazz.getMethods();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (((Method)object[i]).getAnnotation(Transactional.class) == null) continue;
            bl = true;
        }
        return bl;
    }

    private void createServerHandlerInfo(JaxrpcHandlerChain jaxrpcHandlerChain, HandlerList handlerList, boolean bl, DeployInfo deployInfo) throws HandlerException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (deployInfo.getJwsClass().getAnnotation(WLWRollbackOnCheckedException.class) != null) {
            bl2 = true;
        }
        if (deployInfo instanceof ServletDeployInfo && WsBuilder.isTransactional(deployInfo.getJwsClass())) {
            bl3 = true;
        }
        handlerList.add("MESSAGE_CONTEXT_INIT_HANDLER", new HandlerInfo(MessageContextInitHandler.class, (Map)this.getMessageContextPropsMap(deployInfo), null));
        handlerList.add("CONNECTION_HANDLER", new HandlerInfo(ConnectionHandler.class, null, null));
        handlerList.add("WS_VERSION_REDIRECT_HANDLER", new HandlerInfo(VersionRedirectHandler.class, null, null));
        handlerList.add("DIRECT_INVOKE_HANDLER", new HandlerInfo(DirectInvokeHandler.class, null, null));
        handlerList.add("ADDRESSING_HANDLER", new HandlerInfo(ServerAddressingHandler.class, null, null));
        handlerList.add("OPERATION_LOOKUP_HANDLER", new HandlerInfo(OperationLookupHandler.class, null, null));
        handlerList.add("ONE_WAY_HANDLER", new HandlerInfo(OneWayHandler.class, null, null));
        handlerList.add("PRE_INVOKE_HANDLER", new HandlerInfo(PreinvokeHandler.class, null, null));
        if (jaxrpcHandlerChain != null) {
            handlerList.add("JAX_RPC_CHAIN_HANDLER", new HandlerInfo(JaxrpcChainHandler.class, WsBuilder.createJAXRPCAttributes(jaxrpcHandlerChain, "32"), null));
        }
        handlerList.add("CODEC_HANDLER", new HandlerInfo(weblogic.wsee.ws.dispatch.server.CodecHandler.class, null, null));
        handlerList.add("AUTHORIZATION_HANDLER", new HandlerInfo(AuthorizationHandler.class, null, null));
        if (bl2) {
            handlerList.add("WLW_ROLLBACK_ON_CHECKED_EXCEPTION_HANDLER", new HandlerInfo(WLWRollbackOnCheckedExceptionHandler.class, null, null));
        }
        if (bl3) {
            handlerList.add("POJO_TRANSACTION_HANDLER", new HandlerInfo(PojoTransactionHandler.class, null, null));
        }
        handlerList.add("COMPONENT_HANDLER", new HandlerInfo(ComponentHandler.class, null, null));
    }

    private static Map createJAXRPCAttributes(JaxrpcHandlerChain jaxrpcHandlerChain, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("weblogic.wsee.handler.jaxrpcHandlerChain", jaxrpcHandlerChain);
        hashMap.put("weblogic.wsee.handler.jaxrpcHandlerChainPoolSize", string);
        return hashMap;
    }

    private void createClientHandlerInfo(JaxrpcHandlerChain jaxrpcHandlerChain, HandlerList handlerList, boolean bl) throws HandlerException {
        handlerList.add("CODEC_HANDLER", new HandlerInfo(CodecHandler.class, null, null));
        handlerList.add("ADDRESSING_HANDLER", new HandlerInfo(ClientAddressingHandler.class, null, null));
        if (bl) {
            handlerList.add("POLICY_CLIENT_RT_HANDLER", new HandlerInfo(WsrmPolicyClientRuntimeHandler.class, null, null));
        }
        handlerList.add("JAX_RPC_CHAIN_HANDLER", new HandlerInfo(JaxrpcChainHandler.class, WsBuilder.createJAXRPCAttributes(jaxrpcHandlerChain, "5"), null));
        handlerList.add("MMEHEADER_HANDLER", new HandlerInfo(MimeHeaderHandler.class, null, null));
        handlerList.add("ASYNC_HANDLER", new HandlerInfo(AsyncClientHandler.class, null, null));
        if (KernelStatus.isServer()) {
            List list = GlobalHandlerChainHelper.getInstance().getOutboundHandlerInfos();
            int n = 0;
            for (HandlerInfo handlerInfo : list) {
                handlerList.add("GLOBAL-OUTBOUND-HANDLER[" + n + "]", handlerInfo);
                ++n;
            }
        }
        handlerList.add("CONNECTION_HANDLER", new HandlerInfo(weblogic.wsee.ws.dispatch.client.ConnectionHandler.class, null, null));
    }

    private Tylar getThreadTylar() {
        return null;
    }

    private static Class loadClass(String string) throws WsException {
        try {
            return ClassUtil.loadClass((String)string);
        }
        catch (ClassUtil.ClassUtilException classUtilException) {
            throw new WsException("Failed to load class", classUtilException);
        }
    }

    private HashMap getMessageContextPropsMap(DeployInfo deployInfo) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("weblogic.wsee.context_path", deployInfo.getContextPath());
        hashMap.put("weblogic.wsee.security_realm", deployInfo.getSecurityRealmName());
        hashMap.put("weblogic.wsee.application_id", deployInfo.getApplication());
        hashMap.put("weblogic.wsee.service_name", deployInfo.getServiceName());
        boolean bl = false;
        boolean bl2 = Boolean.getBoolean("weblogic.wsee.validate_request");
        if (deployInfo.getWlPortComp() != null) {
            bl = deployInfo.getWlPortComp().getStreamAttachments();
            bl2 = bl2 || Boolean.valueOf(deployInfo.getWlPortComp().isValidateRequest()) != false;
        }
        hashMap.put("weblogic.wsee.stream_attachments", bl);
        if (verbose) {
            Verbose.log("Request Validation of Webservice PortComponentName= (" + deployInfo.getPortComp().getPortComponentName() + ") is set to " + bl2);
        }
        hashMap.put("weblogic.wsee.validate_request", bl2);
        return hashMap;
    }

    public String toString() {
        return "WsBuilder{}";
    }
}

