/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.util.HashMap;
import java.util.Iterator;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.wsdl.WsdlPortType;

public class WsEndpointImpl
extends WsEndpoint {
    private WsdlPortType portType;
    private HashMap methods = new HashMap();
    private WsService wsService;
    private Class endpointInterface;
    private Class jwsClass;
    private String defaultMethod;

    WsEndpointImpl(WsService wsService, WsdlPortType wsdlPortType) {
        assert (wsdlPortType != null);
        assert (wsService != null);
        this.portType = wsdlPortType;
        this.wsService = wsService;
    }

    public WsService getService() {
        return this.wsService;
    }

    public WsdlPortType getPortType() {
        return this.portType;
    }

    public Class getJwsClass() {
        return this.jwsClass;
    }

    public void setJwsClass(Class clazz) {
        this.jwsClass = clazz;
    }

    public WsMethod getMethod(String string) {
        return (WsMethod)this.methods.get(string);
    }

    public Iterator getMethods() {
        return this.methods.values().iterator();
    }

    public void setDefaultMethod(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null default method");
        }
        this.defaultMethod = string;
    }

    public WsMethod getDefaultMethod() {
        WsMethod wsMethod = null;
        if (this.defaultMethod != null && (wsMethod = this.getMethod(this.defaultMethod)) == null) {
            throw new AssertionError((Object)("got null for defaultMethod" + this.defaultMethod));
        }
        return wsMethod;
    }

    public Class getEndpointInterface() {
        return this.endpointInterface;
    }

    void setEndpointInterface(Class clazz) {
        this.endpointInterface = clazz;
    }

    void addMethod(String string, WsMethod wsMethod) {
        this.methods.put(string, wsMethod);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeMap("methods", this.methods);
        toStringWriter.writeField("portType", this.portType.getName());
        toStringWriter.writeField("endpointInterface", this.endpointInterface);
        toStringWriter.end();
    }
}

