/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.jws.WLDeployment;
import weblogic.wsee.deploy.ClientDeployInfo;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.deploy.ServletDeployInfo;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsBuilder;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.WsServiceImpl;
import weblogic.wsee.ws.init.WsDeploymentChain;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;
import weblogic.wsee.ws.init.WsDeploymentListenerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsFactory {
    private static final boolean verbose = Verbose.isVerbose(WsFactory.class);
    private static final WsFactory instance = new WsFactory();

    private WsFactory() {
    }

    public static WsFactory instance() {
        return instance;
    }

    public WsService createClientService(ClientDeployInfo clientDeployInfo) throws WsException {
        WsService wsService = new WsBuilder().buildService(clientDeployInfo);
        this.callClientListeners(this.buildDeploymentContext(wsService));
        return wsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsService createServerService(ServletDeployInfo servletDeployInfo) throws WsException {
        PortComponentBean portComponentBean = servletDeployInfo.getWlPortComp();
        WsService wsService = new WsBuilder().buildService(servletDeployInfo);
        WsDeploymentContext wsDeploymentContext = this.buildDeploymentContext(wsService, servletDeployInfo.getContextPath(), servletDeployInfo.getServiceURIs(), servletDeployInfo.getServiceName());
        try {
            this.callServerListeners(wsDeploymentContext, portComponentBean);
        }
        finally {
            servletDeployInfo.setDynamicEjbs(wsDeploymentContext.getDynamicEjbs());
            servletDeployInfo.setBufferTargetURIs(wsDeploymentContext.getBufferTargetURIs());
        }
        return wsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsService createServerService(EJBDeployInfo eJBDeployInfo) throws WsException {
        WsServiceImpl wsServiceImpl = new WsBuilder().buildService(eJBDeployInfo);
        WsDeploymentContext wsDeploymentContext = this.buildDeploymentContext(wsServiceImpl, eJBDeployInfo.getContextPath(), eJBDeployInfo.getServiceURIs(), eJBDeployInfo.getServiceName());
        try {
            this.callServerListeners(wsDeploymentContext, eJBDeployInfo.getWlPortComp());
        }
        finally {
            eJBDeployInfo.setDynamicEjbs(wsDeploymentContext.getDynamicEjbs());
            eJBDeployInfo.setBufferTargetURIs(wsDeploymentContext.getBufferTargetURIs());
        }
        return wsServiceImpl;
    }

    public void loadPolicy(WsService wsService) throws WsException {
        this.callClientListeners(this.buildDeploymentContext(wsService));
    }

    private void callServerListeners(WsDeploymentContext wsDeploymentContext, PortComponentBean portComponentBean) throws WsException {
        Iterator iterator = wsDeploymentContext.getWsService().getEndpoints();
        while (iterator.hasNext()) {
            WsEndpoint wsEndpoint = (WsEndpoint)iterator.next();
            List<WsDeploymentListenerConfig> list = this.getCustomListeners(wsEndpoint, portComponentBean);
            if (verbose) {
                Verbose.log("Custom Deployment listener = " + list);
            }
            WsDeploymentListener wsDeploymentListener = WsDeploymentChain.newServerChain(list);
            try {
                wsDeploymentListener.process(wsDeploymentContext);
            }
            catch (WsDeploymentException wsDeploymentException) {
                throw new WsException("Failed to call deployment processor", wsDeploymentException);
            }
        }
    }

    private void callClientListeners(WsDeploymentContext wsDeploymentContext) throws WsException {
        WsDeploymentListener wsDeploymentListener = WsDeploymentChain.newClientChain(Collections.<WsDeploymentListenerConfig>emptyList());
        try {
            wsDeploymentListener.process(wsDeploymentContext);
        }
        catch (WsDeploymentException wsDeploymentException) {
            throw new WsException("Failed to call deployment processor", wsDeploymentException);
        }
    }

    private WsDeploymentContext buildDeploymentContext(WsService wsService) {
        return this.buildDeploymentContext(wsService, null, null, null);
    }

    private WsDeploymentContext buildDeploymentContext(WsService wsService, String string, String[] stringArray, String string2) {
        WsDeploymentContext wsDeploymentContext = new WsDeploymentContext();
        wsDeploymentContext.setWsService(wsService);
        wsDeploymentContext.setServiceURIs(stringArray);
        String string3 = ApplicationVersionUtils.getCurrentVersionId();
        wsDeploymentContext.setVersion(string3);
        wsDeploymentContext.setContextPath(string);
        wsDeploymentContext.setServiceName(string2);
        if (verbose) {
            Verbose.log(wsDeploymentContext);
        }
        return wsDeploymentContext;
    }

    private List<WsDeploymentListenerConfig> getCustomListeners(WsEndpoint wsEndpoint, PortComponentBean portComponentBean) {
        ArrayList<WsDeploymentListenerConfig> arrayList = new ArrayList<WsDeploymentListenerConfig>();
        this.addDeploymentListeners(portComponentBean, arrayList);
        Class clazz = wsEndpoint.getJwsClass();
        if (clazz != null) {
            this.addDeploymentListeners(clazz, arrayList);
        }
        return arrayList;
    }

    private void addDeploymentListeners(Class clazz, List<WsDeploymentListenerConfig> list) {
        String[] stringArray;
        WLDeployment wLDeployment = clazz.getAnnotation(WLDeployment.class);
        if (wLDeployment != null && (stringArray = wLDeployment.deploymentListener()) != null) {
            this.addDeploymentListeners(stringArray, list);
        }
    }

    private void addDeploymentListeners(PortComponentBean portComponentBean, List<WsDeploymentListenerConfig> list) {
        if (portComponentBean != null && portComponentBean.getDeploymentListenerList() != null) {
            String[] stringArray = portComponentBean.getDeploymentListenerList().getDeploymentListeners();
            this.addDeploymentListeners(stringArray, list);
        }
    }

    private void addDeploymentListeners(String[] stringArray, List<WsDeploymentListenerConfig> list) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                list.add(new WsDeploymentListenerConfig(ClassUtil.loadClass(stringArray[i])));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("unable to load " + stringArray[i], classNotFoundException);
            }
        }
    }
}

