/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.monitoring.OperationStats;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.NameValueList;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsFault;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.wsdl.WsdlOperation;

public final class WsMethodImpl
extends WsMethod {
    private WsdlOperation operation;
    private WsEndpoint endpoint;
    private NameValueList parameterList = new NameValueList();
    private WsReturnType returnType;
    private List exceptionList = new ArrayList();
    private String methodName;
    private QName wrapperElement;
    private QName returnWrapperElement;
    private NormalizedExpression cachedEffectiveInboundPolicy;
    private NormalizedExpression cachedEffectiveOutboundPolicy;
    private OperationStats stats;

    WsMethodImpl(WsEndpoint wsEndpoint, WsdlOperation wsdlOperation) {
        this.operation = wsdlOperation;
        this.endpoint = wsEndpoint;
    }

    public WsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public WsReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(WsReturnType wsReturnType) {
        this.returnType = wsReturnType;
    }

    public OperationStats getStats() {
        return this.stats;
    }

    public void setStats(OperationStats operationStats) {
        this.stats = operationStats;
    }

    public boolean isWrapped() {
        return this.wrapperElement != null;
    }

    public QName getWrapperElement() {
        return this.wrapperElement;
    }

    public void setWrapperElement(QName qName) {
        this.wrapperElement = qName;
    }

    public QName getReturnWrapperElement() {
        return this.returnWrapperElement;
    }

    public void setReturnWrapperElement(QName qName) {
        this.returnWrapperElement = qName;
    }

    public void setCachedEffectiveInboundPolicy(NormalizedExpression normalizedExpression) {
        this.cachedEffectiveInboundPolicy = normalizedExpression;
    }

    public NormalizedExpression getCachedEffectiveInboundPolicy() {
        return this.cachedEffectiveInboundPolicy;
    }

    public void setCachedEffectiveOutboundPolicy(NormalizedExpression normalizedExpression) {
        this.cachedEffectiveOutboundPolicy = normalizedExpression;
    }

    public NormalizedExpression getCachedEffectiveOutboundPolicy() {
        return this.cachedEffectiveOutboundPolicy;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("wsdlOperation", this.operation.getName());
        toStringWriter.writeField("parameterList", this.parameterList);
        toStringWriter.writeField("returnType", this.returnType);
        toStringWriter.writeField("faultList", this.exceptionList);
        toStringWriter.end();
    }

    public void addException(WsFault wsFault) {
        this.exceptionList.add(wsFault);
    }

    void addParameter(String string, WsParameterType wsParameterType) {
        assert (string != null);
        assert (wsParameterType != null);
        this.parameterList.put(string, wsParameterType);
    }

    public Iterator getExceptions() {
        return this.exceptionList.iterator();
    }

    public QName getOperationName() {
        return this.operation.getName();
    }

    public WsParameterType getParameter(int n) {
        assert (n < this.parameterList.size());
        return (WsParameterType)this.parameterList.get(n).value();
    }

    public Iterator getParameters() {
        return this.parameterList.values();
    }

    public int getParameterSize() {
        return this.parameterList.size();
    }

    public Object[] getMethodArgs(Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getParameters();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            switch (wsParameterType.getMode()) {
                case 0: {
                    arrayList.add(map.get(wsParameterType.getName()));
                    break;
                }
                case 1: 
                case 2: {
                    Object v = map.get(wsParameterType.getName());
                    Object object = WsMethodImpl.newInstance(wsParameterType.getJavaHolderType());
                    if (v != null && wsParameterType.getMode() == 2) {
                        HolderUtil.setHolderValue(object, v);
                    }
                    arrayList.add(object);
                    map.put(wsParameterType.getName(), object);
                }
            }
        }
        return arrayList.toArray();
    }

    private static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new InvocationException("Failed to create holder instance for: " + clazz, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvocationException("Failed to create holder instance for: " + clazz, illegalAccessException);
        }
    }
}

