/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.HttpRequestParser;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.server.jms.JmsDeploymentListener;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistrationListener;
import weblogic.wsee.ws.init.WsDeploymentException;

public final class WsRegistry {
    private static final boolean verbose = Verbose.isVerbose(WsRegistry.class);
    private static final String DELIMITER = "#";
    private static final String nullVersion = "NONE";
    private Map portList = new HashMap();
    private Map<String, ArrayList> uriVersionMap = new HashMap<String, ArrayList>();
    private List listeners;
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static WsRegistry registry = new WsRegistry();

    private WsRegistry() {
    }

    public static WsRegistry instance() {
        return registry;
    }

    private String getKey(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(DELIMITER).append(string2);
        return stringBuffer.toString();
    }

    public static String getURL(String string) {
        int n = string.indexOf(DELIMITER);
        String string2 = n >= 0 ? string.substring(0, n) : string;
        return string2;
    }

    public static String getVersion(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(DELIMITER);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            if (string2.length() == 0) {
                return null;
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    public WsPort lookup(String string) {
        String string2 = WsRegistry.getVersion(string);
        String string3 = WsRegistry.getURL(string);
        if (string2 == null) {
            ArrayList arrayList = this.uriVersionMap.get(string3);
            if (arrayList != null && arrayList.size() > 0) {
                if (verbose) {
                    Verbose.log("Deployed versions present for " + string);
                }
                string2 = (String)arrayList.get(arrayList.size() - 1);
                if (verbose) {
                    Verbose.log("Picking last version " + string2);
                }
            } else if (verbose) {
                Verbose.log("No deployed versions for " + string);
            }
        } else if (verbose) {
            Verbose.log("Looking up specific version " + string2 + " url " + string);
        }
        if (string2 != null) {
            return this.lookup(string3, string2);
        }
        return this.lookup(string3, null);
    }

    public WsPort lookup(String string, String string2) {
        Object object;
        String string3;
        String string4;
        String string5 = this.getKey(string, string2);
        WsPort wsPort = (WsPort)this.portList.get(string5);
        if (wsPort == null) {
            String string6;
            int n = string.indexOf("/", 1);
            if (n > 0) {
                string6 = string.substring(0, n);
                string4 = string.substring(n);
            } else {
                string6 = string;
                string4 = "/";
            }
            string3 = HttpParsing.unescape((String)string6, (String)HttpRequestParser.getURIDecodeEncoding());
            object = AsyncUtil.calculateServiceTargetURI(string3, string4);
            wsPort = (WsPort)this.portList.get(this.getKey((String)object, string2));
            if (verbose) {
                Verbose.log("lookup port failed with url:" + string + " use decoded url:" + (String)object + " to lookup, result port = " + wsPort);
            }
        }
        if (verbose) {
            Verbose.log("lookup: url " + string + " version " + (string2 == null ? nullVersion : string2) + "port = " + wsPort);
        }
        if (wsPort == null && verbose) {
            new Exception("Port lookup failure from").printStackTrace();
            Verbose.log("----------All the current ports-------------");
            for (String string6 : this.portList.keySet()) {
                string4 = WsRegistry.getURL(string6);
                string3 = WsRegistry.getVersion(string6);
                object = (WsPort)this.portList.get(string6);
                Verbose.log("\nURL: " + string4 + "\n Port " + object + "\nVersion " + string3);
            }
            Verbose.log("----------All the current ports-------------");
        }
        return wsPort;
    }

    public void register(String string, WsPort wsPort) {
        this.register(string, null, wsPort);
    }

    public void register(String string, String string2, WsPort wsPort) {
        String string3 = this.getKey(string, string2);
        if (verbose) {
            Verbose.log("New Web Service registered at " + string + "version = " + WsRegistry.getVersion(string3));
        }
        this.callListeners(string, string2, wsPort);
        this.portList.put(string3, wsPort);
        if (string2 != null) {
            ArrayList<String> arrayList = this.uriVersionMap.get(string);
            if (arrayList == null) {
                if (verbose) {
                    Verbose.log("Creating new version deployment list for " + string);
                }
                arrayList = new ArrayList<String>(2);
                this.uriVersionMap.put(string, arrayList);
            }
            if (verbose) {
                Verbose.log("Adding version " + string2 + " to deployed versions for " + string);
            }
            arrayList.add(string2);
        }
    }

    public void unregister(String string) {
        this.unregister(string, null);
    }

    public void unregister(String string, String string2) {
        ArrayList arrayList;
        WsPort wsPort;
        String string3 = this.getKey(string, string2);
        if (verbose) {
            Verbose.log("Webservice with url " + string + " is unregistered.");
        }
        if ((wsPort = (WsPort)this.portList.remove(string3)) != null) {
            WsRegistry.unregisterMBean(wsPort);
            try {
                JmsDeploymentListener.removeJmsListener(wsPort);
            }
            catch (WsDeploymentException wsDeploymentException) {
                Verbose.log(wsDeploymentException);
            }
        }
        if (string2 != null && (arrayList = this.uriVersionMap.get(string)) != null) {
            arrayList.remove(string2);
            if (arrayList.isEmpty()) {
                this.uriVersionMap.remove(string);
            }
        }
    }

    public void unregisterMBean(String string) {
        this.unregisterMBean(string, null);
    }

    public void unregisterMBean(String string, String string2) {
        ArrayList arrayList;
        String string3 = this.getKey(string, string2);
        WsPort wsPort = (WsPort)this.portList.get(string3);
        if (wsPort != null) {
            WsRegistry.unregisterMBean(wsPort);
        }
        if (string2 != null && (arrayList = this.uriVersionMap.get(string)) != null) {
            arrayList.remove(string2);
            if (arrayList.isEmpty()) {
                this.uriVersionMap.remove(string);
            }
        }
    }

    public static void unregisterMBean(WsPort wsPort) {
        if (wsPort == null || wsPort.getRuntimeMBean() == null) {
            return;
        }
        final RuntimeMBeanDelegate runtimeMBeanDelegate = (RuntimeMBeanDelegate)wsPort.getRuntimeMBean().getParent();
        if (runtimeMBeanDelegate == null) {
            return;
        }
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    runtimeMBeanDelegate.unregister();
                }
                catch (ManagementException managementException) {
                    Verbose.log((Object)managementException);
                }
                return null;
            }
        });
        if (verbose) {
            Verbose.log("Webservice mbean " + runtimeMBeanDelegate.getName() + " unregistered.");
        }
    }

    public void addListener(WsRegistrationListener wsRegistrationListener) {
        assert (wsRegistrationListener != null);
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(wsRegistrationListener);
    }

    public void removeListener(WsRegistrationListener wsRegistrationListener) {
        if (this.listeners != null) {
            this.listeners.remove(wsRegistrationListener);
        }
    }

    private void callListeners(String string, String string2, WsPort wsPort) {
        if (this.listeners != null) {
            for (WsRegistrationListener wsRegistrationListener : this.listeners) {
                wsRegistrationListener.onRegistration(string, string2, wsPort);
            }
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

