/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.configuration.WssConfiguration;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsPortImpl;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsServiceImpl
implements WsService {
    public static final boolean debug = false;
    private WsdlService wsdlService;
    private RuntimeBindings bindings;
    private Map endpointList = new LinkedHashMap();
    private Map<String, WsPort> portList = new HashMap<String, WsPort>();
    private boolean usingPolicy = false;
    private WssPolicyContext wssPolicyCtx;

    WsServiceImpl(WsdlService wsdlService) {
        assert (wsdlService != null);
        this.wsdlService = wsdlService;
    }

    public RuntimeBindings getBindingProvider() {
        if (this.bindings == null) {
            throw new IllegalStateException("Binding provider not set");
        }
        return this.bindings;
    }

    void setBindingProvider(RuntimeBindings runtimeBindings) {
        this.bindings = runtimeBindings;
    }

    @Override
    public WsdlService getWsdlService() {
        return this.wsdlService;
    }

    @Override
    public WsEndpoint getEndpoint(QName qName) {
        return (WsEndpoint)this.endpointList.get(qName);
    }

    @Override
    public Iterator getEndpoints() {
        return this.endpointList.values().iterator();
    }

    @Override
    public WsPort getPort(String string) {
        return this.portList.get(string);
    }

    @Override
    public Iterator<WsPort> getPorts() {
        return this.portList.values().iterator();
    }

    @Override
    public boolean isUsingPolicy() {
        return this.usingPolicy;
    }

    @Override
    public void setUsingPolicy(boolean bl) {
        this.usingPolicy = bl;
    }

    @Override
    public WssPolicyContext getWssPolicyContext() {
        return this.wssPolicyCtx;
    }

    @Override
    public void setWssPolicyContext(WssPolicyContext wssPolicyContext) {
        this.wssPolicyCtx = wssPolicyContext;
    }

    @Override
    public void addEndpoint(QName qName, WsEndpoint wsEndpoint) {
        assert (qName != null);
        assert (wsEndpoint != null);
        this.endpointList.put(qName, wsEndpoint);
    }

    @Override
    public WsPort addPort(String string, WsdlPort wsdlPort, WsEndpoint wsEndpoint) {
        assert (string != null);
        assert (wsdlPort != null);
        assert (wsEndpoint != null);
        WsPortImpl wsPortImpl = new WsPortImpl(wsdlPort, wsEndpoint);
        this.portList.put(string, wsPortImpl);
        return wsPortImpl;
    }

    @Override
    public void initWssConfiguration() throws WssConfigurationException {
        this.wssPolicyCtx.getWssConfiguration().init();
    }

    @Override
    public WssConfiguration getWssConfiguration() {
        return this.wssPolicyCtx.getWssConfiguration();
    }

    @Override
    public PolicyServer getPolicyServer() {
        return this.wssPolicyCtx.getPolicyServer();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("endpointList", this.endpointList);
        toStringWriter.writeField("wsdlService", this.wsdlService);
        toStringWriter.writeField("bindingProvider", this.bindings);
        toStringWriter.end();
    }
}

