/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.handler.JaxrpcHandlerChain;
import weblogic.wsee.jaxrpc.HandlerRegistryImpl;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsEndpointImpl;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.dispatch.client.ClientDispatcher;
import weblogic.wsee.ws.dispatch.server.JaxrpcChainHandler;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;

public class WsStub
extends WsEndpointImpl {
    private static final boolean verbose = Verbose.isVerbose(WsStub.class);

    WsStub(WsService wsService, WsdlPortType wsdlPortType) throws WsException {
        super(wsService, wsdlPortType);
    }

    public Object invoke(String string, String string2, Map map, Map map2, Map map3) throws Throwable {
        Object var13_13;
        WsPort wsPort;
        if (verbose) {
            Verbose.log("invoking method " + string + " with args: " + map);
        }
        if ((wsPort = this.getService().getPort(string2)) == null) {
            throw new WsException("Unable to find port '" + string2 + "'");
        }
        WsdlPort wsdlPort = wsPort.getWsdlPort();
        assert (wsdlPort != null);
        WsMethod wsMethod = this.getMethod(string);
        if (wsMethod == null) {
            throw new WsException("Remote method '" + string + "' not found");
        }
        if (verbose) {
            Verbose.log("Found Webservice method : " + wsMethod.getOperationName());
        }
        String string3 = this.getPortType().getName().getNamespaceURI();
        QName qName = new QName(string3, string);
        WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
        this.updateJaxrpcHandlerChain(wsPort, map3);
        ClientDispatcher clientDispatcher = new ClientDispatcher(wsMethod, wsPort, wsdlBindingOperation, map, map2, map3);
        clientDispatcher.dispatch();
        Object v0 = var13_13 = wsMethod.getReturnType() == null ? null : map2.remove(wsMethod.getReturnType().getName());
        if (verbose) {
            Verbose.log("Return Value = " + var13_13);
            Verbose.log("Out Parameters = " + map2);
        }
        return var13_13;
    }

    public Object _asyncResponse(String string, String string2, Map map, SOAPMessage sOAPMessage, MessageContext messageContext, Map map2) throws Throwable {
        Object var14_14;
        WsPort wsPort;
        if (verbose) {
            Verbose.log("async response " + string);
        }
        if ((wsPort = this.getService().getPort(string2)) == null) {
            throw new WsException("Unable to find port '" + string2 + "'");
        }
        WsdlPort wsdlPort = wsPort.getWsdlPort();
        assert (wsdlPort != null);
        WsMethod wsMethod = this.getMethod(string);
        if (wsMethod == null) {
            throw new WsException("Remote method '" + string + "' not found");
        }
        if (verbose) {
            Verbose.log("Found Webservice method : " + wsMethod.getOperationName());
        }
        String string3 = this.getPortType().getName().getNamespaceURI();
        QName qName = new QName(string3, string);
        WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
        this.updateJaxrpcHandlerChain(wsPort, map2);
        ClientDispatcher clientDispatcher = new ClientDispatcher(wsMethod, wsPort, wsdlBindingOperation, null, map, map2);
        clientDispatcher.handleAsyncResponse(sOAPMessage, messageContext);
        Object v0 = var14_14 = wsMethod.getReturnType() == null ? null : map.remove(wsMethod.getReturnType().getName());
        if (verbose) {
            Verbose.log("Return Value = " + var14_14);
            Verbose.log("Out Parameters = " + map);
        }
        return var14_14;
    }

    private void updateJaxrpcHandlerChain(WsPort wsPort, Map map) throws HandlerException {
        Object object2;
        HandlerRegistryImpl handlerRegistryImpl = (HandlerRegistryImpl)map.get("weblogic.wsee.handler.registry");
        if (handlerRegistryImpl == null || !handlerRegistryImpl.isChanged()) {
            return;
        }
        QName qName = wsPort.getWsdlPort().getName();
        List list = handlerRegistryImpl.getHandlerChain(qName);
        HandlerListImpl handlerListImpl = new HandlerListImpl();
        for (Object object2 : list) {
            handlerListImpl.add("[USER HANDLER]", (HandlerInfo)object2);
        }
        JaxrpcChainHandler jaxrpcChainHandler = this.findJaxrpcChainHandler(wsPort);
        object2 = new JaxrpcHandlerChain(handlerListImpl);
        jaxrpcChainHandler.resetWithNewChain((JaxrpcHandlerChain)object2);
        handlerRegistryImpl.setChanged(false);
    }

    private JaxrpcChainHandler findJaxrpcChainHandler(WsPort wsPort) {
        HandlerListImpl handlerListImpl = (HandlerListImpl)wsPort.getInternalHandlerList();
        String[] stringArray = handlerListImpl.getHandlerNames();
        int n = 0;
        for (n = 0; n < stringArray.length && !"JAX_RPC_CHAIN_HANDLER".equals(stringArray[n]); ++n) {
        }
        if (n == stringArray.length) {
            throw new AssertionError((Object)"Jaxrpc chain handler is not found.");
        }
        JaxrpcChainHandler jaxrpcChainHandler = (JaxrpcChainHandler)handlerListImpl.get(n);
        return jaxrpcChainHandler;
    }
}

