/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.XmlObject;
import javax.xml.namespace.QName;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.XBeanUtil;

public class WsType {
    private String name;
    private int type;
    private XmlTypeName xmlName;
    private QName elementName;
    private Class javaType;
    private boolean isXmlObjectForTypeOrDocument = false;
    private boolean isXmlObjectForDocument = false;
    private boolean isArrayOfXmlObjectForType = false;
    private boolean isArrayOfXmlObjectForDocument = false;
    private Class xmlObjectArrayComponentClass = null;
    protected boolean isHeader = false;
    private boolean isOptionalElement = false;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int IN_OUT = 2;
    public static final int RETURN = 3;

    WsType(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        this.name = string;
        this.setMode(n);
    }

    public void checkAndSetXmlObject(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
            if (XmlObject.class.isAssignableFrom(clazz2)) {
                this.xmlObjectArrayComponentClass = clazz2;
            } else {
                try {
                    Class<?> clazz3;
                    ClassLoader classLoader = clazz2.getClassLoader();
                    if (classLoader != null && (clazz3 = classLoader.loadClass("org.apache.xmlbeans.XmlObject")) != null && clazz3.isAssignableFrom(clazz2)) {
                        this.xmlObjectArrayComponentClass = clazz2;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.xmlObjectArrayComponentClass != null) {
                if (XBeanUtil.xmlBeanIsDocumentType(this.xmlObjectArrayComponentClass)) {
                    this.isArrayOfXmlObjectForDocument = true;
                } else {
                    this.isArrayOfXmlObjectForType = true;
                }
            }
        } else {
            if (XmlObject.class.isAssignableFrom(clazz)) {
                this.isXmlObjectForDocument = XBeanUtil.xmlBeanIsDocumentType(clazz);
                this.isXmlObjectForTypeOrDocument = true;
                return;
            }
            try {
                Class<?> clazz4;
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader != null && (clazz4 = classLoader.loadClass("org.apache.xmlbeans.XmlObject")) != null && clazz4.isAssignableFrom(clazz)) {
                    this.isXmlObjectForDocument = XBeanUtil.xmlBeanIsDocumentType(clazz);
                    this.isXmlObjectForTypeOrDocument = true;
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public boolean isXmlObjectForTypeOrDocument() {
        return this.isXmlObjectForTypeOrDocument;
    }

    public boolean isXmlObjectForDocument() {
        return this.isXmlObjectForDocument;
    }

    public boolean isArrayOfXmlObjectForType() {
        return this.isArrayOfXmlObjectForType;
    }

    public boolean isArrayOfXmlObjectForDocument() {
        return this.isArrayOfXmlObjectForDocument;
    }

    public boolean isAnyXmlObject() {
        return this.isXmlObjectForTypeOrDocument || this.isXmlObjectForDocument || this.isArrayOfXmlObjectForType || this.isArrayOfXmlObjectForDocument;
    }

    public Class getXmlObjectArrayComponentClass() {
        return this.xmlObjectArrayComponentClass;
    }

    public int getMode() {
        return this.type;
    }

    public String getModeAsString() {
        switch (this.type) {
            case 0: {
                return "IN";
            }
            case 1: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
            case 3: {
                return "RETURN";
            }
        }
        return null;
    }

    void setMode(int n) {
        this.type = n;
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalide type value " + n);
    }

    public String getName() {
        return this.name;
    }

    public XmlTypeName getXmlName() {
        return this.xmlName;
    }

    void setXmlName(XmlTypeName xmlTypeName) {
        assert (xmlTypeName != null) : "xmlName can not be null";
        this.xmlName = xmlTypeName;
    }

    public QName getElementName() {
        return this.elementName;
    }

    void setElementName(QName qName) {
        this.elementName = qName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class clazz) {
        assert (clazz != null) : "javaType can not be null";
        this.javaType = HolderUtil.getRealType(clazz);
        this.checkAndSetXmlObject(clazz);
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isOptionalElement() {
        return this.isOptionalElement;
    }

    public void setOptionalElement(boolean bl) {
        this.isOptionalElement = bl;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("type", this.type);
        toStringWriter.writeField("xmlName", this.xmlName);
        toStringWriter.writeField("javaType", this.javaType);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("isHeader", this.isHeader);
        toStringWriter.writeField("isOptionalElement", this.isOptionalElement);
        toStringWriter.end();
    }
}

