/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;

public class DispatchDebugUtil {
    private static Map<String, PrintWriter> _pwMap = new HashMap<String, PrintWriter>();

    public static PrintWriter getPrintWriterForThread() {
        PrintWriter printWriter = _pwMap.get(Thread.currentThread().getName());
        if (printWriter == null) {
            File file = new File("Thread-" + Thread.currentThread().getId() + ".out");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                printWriter = new MyPrintWriter(fileOutputStream, true);
                _pwMap.put(Thread.currentThread().getName(), printWriter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return printWriter;
    }

    public static void dumpRequestContext(String string, WlMessageContext wlMessageContext, HandlerIterator handlerIterator, int n) {
        SoapMessageContext soapMessageContext;
        SOAPMessage sOAPMessage;
        PrintWriter printWriter = DispatchDebugUtil.getPrintWriterForThread();
        DispatchDebugUtil.dumpLoader(printWriter);
        printWriter.println("  **" + string);
        printWriter.println("    opName: " + wlMessageContext.getProperty("weblogic.wsee.ws.server.OperationName"));
        printWriter.println("  SOAPMessage:");
        if (wlMessageContext instanceof SoapMessageContext && (sOAPMessage = (soapMessageContext = (SoapMessageContext)wlMessageContext).getMessage()) != null) {
            try {
                DispatchDebugUtil.dumpSOAPMessage(sOAPMessage, printWriter);
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
        }
        DispatchDebugUtil.dumpMessageContext(wlMessageContext, printWriter);
        DispatchDebugUtil.dumpHandlerChain(handlerIterator, printWriter, n);
        printWriter.flush();
    }

    private static void dumpHandlerChain(HandlerIterator handlerIterator, PrintWriter printWriter, int n) {
        HandlerListImpl handlerListImpl = handlerIterator.getHandlers();
        String[] stringArray = handlerListImpl.getHandlerNames();
        printWriter.println("  Handlers:");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) {
                printWriter.print("     *");
            } else {
                printWriter.print("      ");
            }
            printWriter.println("Handler[" + i + "].name=" + stringArray[i]);
        }
    }

    private static void dumpMessageContext(WlMessageContext wlMessageContext, PrintWriter printWriter) {
        printWriter.println("  Context Props:");
        Iterator iterator = wlMessageContext.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = wlMessageContext.getProperty(string);
            printWriter.println("    " + string + "=" + object);
        }
    }

    private static void dumpLoader(PrintWriter printWriter) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string = classLoader.toString();
        if (classLoader instanceof GenericClassLoader) {
            Annotation annotation = ((GenericClassLoader)classLoader).getAnnotation();
            string = annotation.getApplicationName() + "/" + annotation.getModuleName();
        }
        printWriter.println("\n### Loader: " + string);
        printWriter.println(Thread.currentThread().getName());
    }

    public static void dumpSOAPMessage(SOAPMessage sOAPMessage) {
        PrintWriter printWriter = DispatchDebugUtil.getPrintWriterForThread();
        DispatchDebugUtil.dumpLoader(printWriter);
        printWriter.println("** SOAPMessage just set to:");
        try {
            DispatchDebugUtil.dumpSOAPMessage(sOAPMessage, printWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
        printWriter.println("**\n");
    }

    private static String getTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss.SSS");
        return simpleDateFormat.format(new Date());
    }

    private static void dumpSOAPMessage(SOAPMessage sOAPMessage, PrintWriter printWriter) throws SOAPException {
        if (sOAPMessage != null) {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody.hasFault()) {
                SOAPFault sOAPFault = sOAPBody.getFault();
                SOAPFaultException sOAPFaultException = new SOAPFaultException(sOAPFault.getFaultCodeAsQName(), sOAPFault.getFaultCode(), sOAPFault.getFaultString(), sOAPFault.getDetail());
                sOAPFaultException.printStackTrace(printWriter);
            } else {
                Object object;
                Object object2;
                printWriter.println("HEADER");
                SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
                NodeList nodeList = sOAPHeader.getChildNodes();
                Object object3 = null;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    printWriter.println("SOAP node " + (i + 1) + " of " + nodeList.getLength());
                    Node node = nodeList.item(i);
                    if (object3 == null) {
                        object3 = node;
                    }
                    object2 = new ByteArrayOutputStream();
                    DispatchDebugUtil.serialize(node, (OutputStream)object2);
                    object = new String(((ByteArrayOutputStream)object2).toByteArray());
                    printWriter.println((String)object);
                }
                printWriter.println("BODY");
                NodeList nodeList2 = sOAPBody.getChildNodes();
                object3 = null;
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    printWriter.println("SOAP node " + (i + 1) + " of " + nodeList2.getLength());
                    object2 = nodeList2.item(i);
                    if (object3 == null) {
                        object3 = object2;
                    }
                    object = new ByteArrayOutputStream();
                    DispatchDebugUtil.serialize((Node)object2, (OutputStream)object);
                    String string = new String(((ByteArrayOutputStream)object).toByteArray());
                    printWriter.println(string);
                }
            }
        } else {
            printWriter.println("Null");
        }
    }

    private static void serialize(Node node, OutputStream outputStream) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new RuntimeException(transformerException);
        }
    }

    private static class MyPrintWriter
    extends PrintWriter {
        private boolean _atStartOfLine = true;

        public MyPrintWriter(OutputStream outputStream, boolean bl) {
            super(outputStream, bl);
        }

        public void write(int n) {
            super.write(n);
            this._atStartOfLine = false;
        }

        public void write(char[] cArray) {
            super.write(cArray);
            this._atStartOfLine = false;
        }

        public void write(String string, int n, int n2) {
            super.write(string, n, n2);
            this._atStartOfLine = false;
        }

        public void write(String string) {
            super.write(string);
            this._atStartOfLine = false;
        }

        public void println() {
            super.println();
            this._atStartOfLine = true;
        }

        public void print(String string) {
            if (this._atStartOfLine) {
                super.print(DispatchDebugUtil.getTimestamp());
                super.print(": ");
            }
            super.print(string);
        }

        public void println(String string) {
            if (this._atStartOfLine) {
                super.print(DispatchDebugUtil.getTimestamp());
                super.print(": ");
            }
            super.println(string);
            this._atStartOfLine = true;
        }
    }
}

