/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.codec.Codec;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.soap12.Soap12Codec;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

public abstract class DispatcherImpl
extends Dispatcher {
    private WsMethod wsMethod;
    private WsdlBindingOperation bindingOperation;
    private QName opName;
    private WsdlOperation op;
    private Codec codec;
    private WlMessageContext context;
    private Connection connection;
    private Map inParams;
    private Map outParams;
    private WsPort port;
    private HandlerIterator handlerChain;

    protected DispatcherImpl() {
    }

    public WsdlBindingOperation getBindingOperation() {
        if (this.bindingOperation == null) {
            this.bindingOperation = this.getWsdlPort().getBinding().getOperations().get(this.getOperationName());
        }
        return this.bindingOperation;
    }

    public void setBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        this.bindingOperation = wsdlBindingOperation;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(Codec codec2) {
        this.codec = codec2;
    }

    public boolean isSOAP12() {
        return this.codec instanceof Soap12Codec;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public WlMessageContext getContext() {
        return this.context;
    }

    public void setContext(WlMessageContext wlMessageContext) {
        this.context = wlMessageContext;
    }

    public HandlerIterator getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(HandlerIterator handlerIterator) {
        this.handlerChain = handlerIterator;
    }

    public Map getInParams() {
        return this.inParams;
    }

    public void setInParams(Map map) {
        this.inParams = map;
    }

    public Map getOutParams() {
        return this.outParams;
    }

    public void setOutParams(Map map) {
        this.outParams = map;
    }

    public WsMethod getWsMethod() {
        QName qName;
        if (this.wsMethod == null && (qName = this.getOperationName()) != null) {
            this.wsMethod = this.getWsPort().getEndpoint().getMethod(qName.getLocalPart());
        }
        return this.wsMethod;
    }

    public void setWsMethod(WsMethod wsMethod) {
        this.wsMethod = wsMethod;
    }

    public QName getOperationName() {
        if (this.opName == null) {
            this.opName = (QName)this.getContext().getProperty("weblogic.wsee.ws.server.OperationName");
            if (this.opName == null) {
                try {
                    this.opName = this.getCodec().getOperation(this.getContext());
                }
                catch (CodecException codecException) {
                    throw new JAXRPCException((Throwable)codecException);
                }
            }
        }
        return this.opName;
    }

    public WsdlOperation getOperation() {
        if (this.op == null) {
            QName qName = this.opName;
            if (qName == null && this.getWsMethod() != null) {
                qName = this.wsMethod.getOperationName();
            }
            if (qName == null) {
                return null;
            }
            this.op = this.getWsdlPort().getPortType().getOperations().get(qName);
        }
        return this.op;
    }

    public WsPort getWsPort() {
        return this.port;
    }

    public WsdlPort getWsdlPort() {
        return this.port.getWsdlPort();
    }

    public void setWsPort(WsPort wsPort) {
        this.port = wsPort;
    }

    public QName getPortName() {
        return this.port.getWsdlPort().getName();
    }

    public QName getServiceName() {
        return this.port.getWsdlPort().getService().getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceContext {
        private static ThreadLocal<EndpointReference> endpointRef = new ThreadLocal<EndpointReference>(){

            @Override
            protected synchronized EndpointReference initialValue() {
                return null;
            }
        };
        private static Map<String, Object> stubProps = new HashMap<String, Object>();

        public static EndpointReference get() {
            return endpointRef.get();
        }

        public static void set(EndpointReference endpointReference) {
            endpointRef.set(endpointReference);
        }

        public static Map<String, Object> getStubProperties() {
            return stubProps;
        }

        public static void propagatePropertiesToClient(WlMessageContext wlMessageContext) {
            String[] stringArray;
            for (String string : stringArray = WsrmConstants.PROP_NAMES_FOR_RM_SOURCE) {
                ServiceContext.propagateProperty(string, wlMessageContext);
            }
        }

        public static void acceptPropertiesIntoClient(WlMessageContext wlMessageContext) {
            String[] stringArray;
            for (String string : stringArray = WsrmConstants.PROP_NAMES_FOR_RM_SOURCE) {
                ServiceContext.acceptProperty(string, wlMessageContext);
            }
        }

        private static void propagateProperty(String string, WlMessageContext wlMessageContext) {
            if (wlMessageContext.containsProperty(string)) {
                stubProps.put(string, wlMessageContext.getProperty(string));
            }
        }

        private static void acceptProperty(String string, WlMessageContext wlMessageContext) {
            if (!wlMessageContext.containsProperty(string) && stubProps.containsKey(string)) {
                wlMessageContext.setProperty(string, stubProps.get(string));
            }
        }
    }
}

