/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.client;

import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.CodecFactory;
import weblogic.wsee.connection.ResponseListener;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.DispatcherImpl;
import weblogic.wsee.wsdl.WsdlBindingOperation;

public final class ClientDispatcher
extends DispatcherImpl
implements ResponseListener {
    public static final String OPERATION_NAME_PROPERTY = "weblogic.wsee.ws.dispatch.client.OperationName";
    private static final boolean verbose = Verbose.isVerbose(ClientDispatcher.class);
    private Map properties;

    public ClientDispatcher(WsMethod wsMethod, WsPort wsPort, WsdlBindingOperation wsdlBindingOperation, Map map, Map map2, Map map3) throws CodecException {
        if (verbose) {
            Verbose.logArgs("method", wsMethod.getMethodName(), "wsPort", wsPort.getWsdlPort().getName(), "operation", wsdlBindingOperation.getName(), "input", map);
        }
        this.properties = map3;
        this.setWsMethod(wsMethod);
        this.setWsPort(wsPort);
        this.setBindingOperation(wsdlBindingOperation);
        this.setInParams(map);
        this.setOutParams(map2);
        this.setMessageContext();
        ClientDispatcher.updateEffectivePolicy(wsPort, wsMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() throws Throwable {
        Map map;
        WlMessageContext wlMessageContext = this.getContext();
        if (this.getWsMethod() != null) {
            wlMessageContext.setProperty(OPERATION_NAME_PROPERTY, this.getWsMethod().getOperationName().getLocalPart());
        }
        if ((map = (Map)this.properties.get("weblogic.wsee.invoke_properties")) == null) {
            map = new ConcurrentHashMap();
            this.properties.put("weblogic.wsee.invoke_properties", map);
        }
        if (verbose) {
            Verbose.log("Copy invocation properties");
        }
        this.fillProperties(wlMessageContext, this.properties);
        Object object = map;
        synchronized (object) {
            this.fillProperties(wlMessageContext, map);
        }
        this.setHandlerChain(new HandlerIterator(this.getWsPort().getInternalHandlerList()));
        if (verbose) {
            Verbose.say("Handler chain:");
            object = this.getHandlerChain();
            for (int i = 0; i < ((HandlerIterator)object).getHandlers().size(); ++i) {
                Handler handler = ((HandlerIterator)object).getHandlers().get(i);
                Verbose.say("\tHandler[" + i + "] = " + handler);
            }
        }
        if (verbose) {
            Verbose.log("Invoking handler chain");
        }
        object = this;
        synchronized (object) {
            this.getHandlerChain().handleRequest(wlMessageContext);
        }
        switch (this.getOperation().getType()) {
            case 0: 
            case 2: {
                if (wlMessageContext.getProperty("weblogic.wsee.async.invoke") != null) break;
                if (wlMessageContext.getProperty("weblogic.wsee.ws.dispatch.WLW81compatTxVoidReturn") != null) {
                    this.getHandlerChain().handleClosure(wlMessageContext);
                    break;
                }
                this.handleResponse();
                break;
            }
            case 1: {
                if ("true".equals(wlMessageContext.getProperty("weblogic.wsee.addressing.client.hasexception"))) {
                    this.handleResponse();
                }
            }
            case 3: {
                this.getHandlerChain().handleClosure(wlMessageContext);
            }
        }
        if (verbose) {
            Verbose.log("Dispatch done");
        }
        if (wlMessageContext.hasFault() && wlMessageContext.getFault() != null) {
            throw wlMessageContext.getFault();
        }
    }

    private WlMessageContext setMessageContext() throws CodecException {
        CodecFactory codecFactory = CodecFactory.instance();
        this.setCodec(codecFactory.getCodec(this.getWsdlPort().getBinding()));
        if (verbose) {
            Verbose.log("Creating context");
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(this.getCodec().createContext());
        this.setContext(wlMessageContext);
        wlMessageContext.setDispatcher(this);
        return wlMessageContext;
    }

    private void fillProperties(WlMessageContext wlMessageContext, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            assert (entry.getKey() instanceof String);
            String string = (String)entry.getKey();
            if (wlMessageContext.containsProperty(string)) continue;
            wlMessageContext.setProperty(string, entry.getValue());
        }
        EndpointReference endpointReference = DispatcherImpl.ServiceContext.get();
        if (endpointReference != null && !wlMessageContext.containsProperty("weblogic.wsee.addressing.From")) {
            wlMessageContext.setProperty("weblogic.wsee.addressing.From", endpointReference);
        }
        DispatcherImpl.ServiceContext.acceptPropertiesIntoClient(wlMessageContext);
    }

    private void handleResponse() {
        if (verbose) {
            Verbose.say("handleResponse called");
        }
        this.getHandlerChain().handleResponse(this.getContext());
    }

    public void responseReady() {
    }

    public synchronized void handleAsyncResponse(SOAPMessage sOAPMessage) throws Throwable {
        if (verbose) {
            Verbose.say("handleAsyncResponse for called: msg = " + sOAPMessage);
        }
        WlMessageContext wlMessageContext = this.getContext();
        this.handleResponse();
        if (verbose) {
            Verbose.log("Dispatch done");
        }
        if (wlMessageContext.hasFault() && wlMessageContext.getFault() != null) {
            throw wlMessageContext.getFault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAsyncResponse(SOAPMessage sOAPMessage, MessageContext messageContext) throws Throwable {
        if (verbose) {
            Verbose.say("handleAsyncResponse for called: msg = " + sOAPMessage + " mc = " + messageContext);
        }
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        this.setContext(wlMessageContext);
        wlMessageContext.setDispatcher(this);
        Map map = (Map)this.properties.get("weblogic.wsee.invoke_properties");
        if (map == null) {
            map = new ConcurrentHashMap();
            this.properties.put("weblogic.wsee.invoke_properties", map);
        }
        if (verbose) {
            Verbose.log("Copy invocation properties");
        }
        this.fillProperties(wlMessageContext, this.properties);
        Map map2 = map;
        synchronized (map2) {
            this.fillProperties(wlMessageContext, map);
        }
        this.setHandlerChain(new HandlerIterator(this.getWsPort().getInternalHandlerList()));
        this.getHandlerChain().handleAsyncResponse(this.getContext());
        if (verbose) {
            Verbose.log("Dispatch done");
        }
        if (wlMessageContext.hasFault() && wlMessageContext.getFault() != null) {
            throw wlMessageContext.getFault();
        }
    }

    private static void updateEffectivePolicy(WsPort wsPort, WsMethod wsMethod) {
        if (wsMethod != null) {
            Iterator iterator = wsPort.getEndpoint().getMethods();
            while (iterator.hasNext()) {
                WsMethod wsMethod2 = (WsMethod)iterator.next();
                if (!wsMethod2.getMethodName().equals(wsMethod.getMethodName())) continue;
                wsMethod.setCachedEffectiveInboundPolicy(wsMethod2.getCachedEffectiveInboundPolicy());
                wsMethod.setCachedEffectiveOutboundPolicy(wsMethod2.getCachedEffectiveOutboundPolicy());
                break;
            }
        }
    }
}

