/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import weblogic.transaction.TransactionHelper;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.http.HTTPClientTransport;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.message.UnknownMsgHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.ControlAPIUtil;
import weblogic.wsee.util.EndpointAddressUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.ws.dispatch.DispatcherImpl;

public class ConnectionHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(ConnectionHandler.class);
    public static final String OUTPUT_HEADERS = "weblogic.wsee.OutputHeaders";
    public static final String INPUT_HEADERS = "weblogic.wsee.InputHeaders";
    private static ConnectionFactory factory = ConnectionFactory.instance();
    public static final String WLW81_COMPAT_TX_VOID_RETURN = "weblogic.wsee.ws.dispatch.WLW81compatTxVoidReturn";

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        this.writeOutputHeaders(wlMessageContext);
        this.checkPossibleBlockingCondition(wlMessageContext);
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        try {
            ((DispatcherImpl)dispatcher).setConnection(factory.createClientConnection(EndpointAddressUtil.getProtocolFromEndpointAddress(wlMessageContext), dispatcher.getWsdlPort().getBinding().getBindingType()));
        }
        catch (ConnectionException connectionException) {
            throw new InvocationException("Failed to create a connection", connectionException);
        }
        if (verbose) {
            Verbose.log(messageContext);
        }
        try {
            dispatcher.getConnection().send(messageContext);
        }
        catch (IOException iOException) {
            throw new InvocationException("Failed to send message using connection:" + dispatcher.getConnection(), iOException);
        }
        if (dispatcher.getOperation().getType() == 1 || dispatcher.getOperation().getType() == 3 || messageContext.getProperty("weblogic.wsee.async.invoke") != null) {
            try {
                int n;
                if ("true".equalsIgnoreCase((String)messageContext.getProperty("weblogic.wsee.complex")) && dispatcher.getConnection().getTransport() instanceof HTTPClientTransport && (n = ((HTTPClientTransport)dispatcher.getConnection().getTransport()).getResponseCode()) == 500) {
                    messageContext.setProperty("weblogic.wsee.addressing.client.hasexception", (Object)"true");
                    return true;
                }
                dispatcher.getConnection().getTransport().confirmOneway();
            }
            catch (IOException iOException) {
                throw new InvocationException("Oneway failed", iOException);
            }
        }
        return true;
    }

    private void checkPossibleBlockingCondition(WlMessageContext wlMessageContext) {
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        if ("jms".equalsIgnoreCase(dispatcher.getWsdlPort().getTransport()) && (dispatcher.getOperation().getType() == 0 || dispatcher.getOperation().getType() == 2) && !wlMessageContext.containsProperty("weblogic.wsee.async.invoke") && !wlMessageContext.containsProperty(WLW81_COMPAT_TX_VOID_RETURN) && this.isInTransaction()) {
            System.err.println("Potential blocking operation " + dispatcher.getOperation().getName() + ": a synchronous request/response invocation within a transaction " + "using the JMS transport can cause deadlocks.  Please refer to WebLogic documentation for details.");
        }
    }

    private boolean isInTransaction() {
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
        return transaction != null;
    }

    private void writeOutputHeaders(WlMessageContext wlMessageContext) {
        List list = (List)wlMessageContext.getProperty(OUTPUT_HEADERS);
        if (list != null) {
            for (Element element : list) {
                wlMessageContext.getHeaders().addHeader(new UnknownMsgHeader(element));
            }
            ControlAPIUtil.unsetOutputHeaders(wlMessageContext);
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        if (messageContext.getProperty("weblogic.wsee.async.invoke") != null) {
            return true;
        }
        try {
            dispatcher.getConnection().receive(messageContext);
        }
        catch (IOException iOException) {
            throw new InvocationException("Failed to receive message " + iOException, iOException);
        }
        if (verbose) {
            Verbose.log(messageContext);
        }
        this.setInputHeaders(messageContext);
        if ("true".equals((String)wlMessageContext.getProperty("weblogic.wsee.addressing.client.hasexception")) && !wlMessageContext.hasFault()) {
            try {
                dispatcher.getConnection().getTransport().confirmOneway();
            }
            catch (IOException iOException) {
                throw new InvocationException("Oneway failed", iOException);
            }
        }
        return true;
    }

    private void setInputHeaders(MessageContext messageContext) {
        ((Map)messageContext.getProperty("weblogic.wsee.invoke_properties")).put(INPUT_HEADERS, ControlAPIUtil.getInputHeaders(messageContext));
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start((Object)this);
        toStringWriter.end();
    }
}

