/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.buffer.BufferHelper;
import weblogic.wsee.component.Component;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.jws.RetryException;
import weblogic.wsee.jws.wlw.SoapFaultException;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsMethodImpl;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.ws.WsSkel;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.ws.dispatch.DispatcherImpl;

public class ComponentHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(ComponentHandler.class);
    public static final String APP_EXCEPTION = "weblogic.wsee.component.AppException";
    private static final boolean dumpException = Boolean.getBoolean("weblogic.wsee.component.exception");

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        String string = dispatcher.getWsMethod().getOperationName().getLocalPart();
        Map map = dispatcher.getInParams();
        Component component = ((WsSkel)dispatcher.getWsPort().getEndpoint()).getComponent();
        try {
            Object[] objectArray = ((WsMethodImpl)dispatcher.getWsMethod()).getMethodArgs(map);
            if (verbose) {
                Verbose.log("Going to invoke method: " + string);
            }
            EndpointReference endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.ServerEndpoint");
            DispatcherImpl.ServiceContext.set(endpointReference);
            DispatcherImpl.ServiceContext.propagatePropertiesToClient(wlMessageContext);
            Object object = component.invoke(string, objectArray, messageContext);
            WsReturnType wsReturnType = dispatcher.getWsMethod().getReturnType();
            if (wsReturnType != null) {
                dispatcher.getOutParams().put(wsReturnType.getName(), object);
            }
            this.putHolderValues(dispatcher.getWsMethod(), map, dispatcher.getOutParams());
        }
        catch (ComponentException componentException) {
            Exception exception;
            Throwable throwable;
            Throwable throwable2 = throwable = componentException.getCause();
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            if (throwable2 != null) {
                wlMessageContext.setProperty(APP_EXCEPTION, throwable2);
                if (throwable2 instanceof RetryException && BufferHelper.isRuntimeRetryExceptionEnabled(messageContext)) {
                    if (verbose) {
                        Verbose.say("Throw RetryException");
                    }
                    throw (RetryException)throwable2;
                }
            }
            if (throwable2 instanceof SoapFaultException) {
                wlMessageContext.setProperty("weblogic.wsee.service_specific_exception", throwable2);
                return true;
            }
            if (throwable2 instanceof EJBException && (exception = ((EJBException)throwable2).getCausedByException()) instanceof SOAPFaultException) {
                throw (SOAPFaultException)((Object)exception);
            }
            if (throwable2 instanceof SOAPFaultException) {
                throw (SOAPFaultException)throwable2;
            }
            if (verbose || dumpException) {
                Verbose.log((Object)("\n Error invoking " + component + ": " + throwable2.getClass().getName()), throwable2);
            }
            if (this.isAppDefinedException(throwable2)) {
                wlMessageContext.setProperty("weblogic.wsee.service_specific_exception", throwable2);
                return true;
            }
            throw new InvocationException("Failed to invoke end component " + component + ", operation=" + string, componentException);
        }
        catch (Throwable throwable) {
            throw new JAXRPCException("ComponentHandler request failed", throwable);
        }
        return true;
    }

    private boolean isAppDefinedException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return false;
        }
        if (throwable instanceof RemoteException) {
            return false;
        }
        if (!(throwable instanceof Exception)) {
            return false;
        }
        if (throwable.getClass().getName().equals(Exception.class.getName())) {
            return false;
        }
        return !throwable.getClass().getName().startsWith("java.sql");
    }

    private void putHolderValues(WsMethod wsMethod, Map map, Map map2) {
        Iterator iterator = wsMethod.getParameters();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            if (wsParameterType.getMode() != 1 && wsParameterType.getMode() != 2) continue;
            Object v = map.get(wsParameterType.getName());
            map2.put(wsParameterType.getName(), HolderUtil.getHolderValue(v));
        }
    }

    public QName[] getHeaders() {
        return new QName[0];
    }
}

