/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.MBeanKeyStoreConfiguration;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.https.WlsSSLAdapter;
import weblogic.wsee.connection.transport.jms.JmsServerQueueTransport;
import weblogic.wsee.connection.transport.servlet.HttpServerTransport;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.message.UnknownMsgHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.WsrmClientHandler;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.server.servlet.SecurityHelper;
import weblogic.wsee.util.ControlAPIUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.xml.saaj.VersionMismatchException;

public class ConnectionHandler
extends GenericHandler
implements WLHandler {
    private static final boolean verbose;
    static final long serialVersionUID = -3051027421965256288L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public boolean handleResponse(MessageContext messageContext) {
        if (verbose) {
            Verbose.log("Sending response: " + messageContext);
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        this.writeOutputHeaders(wlMessageContext);
        if (messageContext.getProperty("weblogic.wsee.addressing.ReplyTo") == null || messageContext.getProperty("weblogic.wsee.reply.anonymous") != null || messageContext.getProperty("weblogic.wsee.reliable.oneway.reply") != null) {
            this.send(messageContext);
            return true;
        }
        return this.handleAsync(messageContext);
    }

    private void writeOutputHeaders(WlMessageContext wlMessageContext) {
        List list = (List)wlMessageContext.getProperty("weblogic.wsee.OutputHeaders");
        if (list != null) {
            for (Element element : list) {
                wlMessageContext.getHeaders().addHeader(new UnknownMsgHeader(element));
            }
            ControlAPIUtil.unsetOutputHeaders(wlMessageContext);
        }
    }

    private boolean handleAsync(MessageContext messageContext) {
        long l = System.nanoTime();
        if (verbose) {
            Verbose.log(l + " :Entering ConnectionHandler.handleAsync(MessageContext)");
        }
        if (messageContext.getProperty("weblogic.wsee.oneway.confirmed") == null) {
            try {
                ((WlMessageContext)messageContext).getDispatcher().getConnection().getTransport().confirmOneway();
            }
            catch (IOException iOException) {
                throw new InvocationException("Failed to confirm oneway", iOException);
            }
            messageContext.setProperty("weblogic.wsee.oneway.confirmed", (Object)"true");
        }
        if (!((WlMessageContext)messageContext).hasFault() && messageContext.getProperty("weblogic.wsee.queued.invoke") != null) {
            return true;
        }
        String string = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        if (string == null) {
            string = ((EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.ReplyTo")).getAddress();
            messageContext.setProperty("javax.xml.rpc.service.endpoint.address", (Object)string);
        }
        boolean bl = false;
        String string2 = (String)messageContext.getProperty("weblogic.wsee.async.res.sequence.id");
        if ((string2 != null || messageContext.getProperty("weblogic.wsee.conversation.AsyncConvId") != null && (string2 = (String)messageContext.getProperty("weblogic.wsee.convid.sequence.id")) != null) && messageContext.getProperty("weblogic.wsee.reliability.asyncfault") == null) {
            bl = true;
        }
        if (bl) {
            messageContext.setProperty("weblogic.wsee.sequenceid", (Object)string2);
            messageContext.setProperty("weblogic.wsee.async.res", (Object)"true");
            messageContext.removeProperty("weblogic.wsee.handler.jaxrpcHandlerChain");
            messageContext.removeProperty("weblogic.wsee.conversation.Lock");
            if (verbose) {
                Verbose.say(l + " :Inside ConnectionHandler.handleAsync(MessageContext) == 1");
            }
            WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_BEFORE_RES_TO_SAF);
            if (verbose) {
                Verbose.say(l + " :Inside ConnectionHandler.handleAsync(MessageContext) == 2");
            }
            new WsrmClientHandler().handleRequest(messageContext);
        } else {
            Connection connection;
            Dispatcher dispatcher = ((WlMessageContext)messageContext).getDispatcher();
            int n = string.indexOf(58);
            String string3 = n < 0 ? "http" : string.substring(0, n);
            ConnectionHandler.verifySSLAdapterOnMessageContextIfNeeded(messageContext);
            try {
                connection = ConnectionFactory.instance().createClientConnection(string3, dispatcher.getWsdlPort().getBinding().getBindingType());
            }
            catch (ConnectionException connectionException) {
                throw new InvocationException("Failed to create a connection", connectionException);
            }
            Transport transport = dispatcher.getConnection().getTransport();
            if (transport instanceof JmsServerQueueTransport && ((JmsServerQueueTransport)transport).isBytesMessage()) {
                messageContext.setProperty("weblogic.wsee.transport.jms.messagetype", (Object)"BytesMessage");
            }
            try {
                SOAPMessage sOAPMessage = ((SoapMessageContext)messageContext).getMessage();
                MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
                mimeHeaders.removeHeader("Content-Length");
                connection.send(messageContext);
            }
            catch (IOException iOException) {
                throw new InvocationException("Failed to send message using connection:" + connection, iOException);
            }
            try {
                connection.getTransport().confirmOneway();
            }
            catch (IOException iOException) {
                throw new InvocationException("Oneway failed", iOException);
            }
            messageContext.setProperty("weblogic.wsee.oneway.confirmed", (Object)"true");
        }
        if (verbose) {
            Verbose.log(l + " :Exiting ConnectionHandler.handleAsync(MessageContext)");
        }
        return true;
    }

    public static void verifySSLAdapterOnMessageContextIfNeeded(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        if (string == null) {
            return;
        }
        if (string.startsWith("https:")) {
            KeyStoreConfigurationHelper keyStoreConfigurationHelper;
            KeyStoreInfo keyStoreInfo;
            if (verbose) {
                Verbose.log("Server ConnectionHandler verifying we have an SSLAdapter to handle an HTTPS connection for delivering a message (async response or RM protocol message");
            }
            if (messageContext.getProperty("weblogic.wsee.client.ssladapter") != null) {
                if (verbose) {
                    Verbose.log("Server ConnectionHandler found an existing SSLAdapter to handle an HTTPS connection for delivering a message (async response or RM protocol message)");
                }
                return;
            }
            if (verbose) {
                Verbose.log("Server ConnectionHandler will *ADD* a new SSLAdapter to handle an HTTPS connection for delivering a message (async response or RM protocol message)");
            }
            if ((keyStoreInfo = (keyStoreConfigurationHelper = new KeyStoreConfigurationHelper(MBeanKeyStoreConfiguration.getInstance())).getIdentityKeyStore()) == null) {
                throw new JAXRPCException("Couldn't get KeyStoreConfigurationHelper");
            }
            String string2 = keyStoreInfo.getFileName();
            if (string2 == null || string2.length() == 0) {
                throw new JAXRPCException("KeyStoreFilename not supplied");
            }
            String string3 = keyStoreInfo.getType();
            char[] cArray = keyStoreInfo.getPassPhrase();
            String string4 = keyStoreConfigurationHelper.getIdentityAlias();
            char[] cArray2 = keyStoreConfigurationHelper.getIdentityPrivateKeyPassPhrase();
            if (string4 == null || string4.length() == 0) {
                throw new JAXRPCException("Certificate Alias not supplied");
            }
            if (cArray2 == null) {
                throw new JAXRPCException("PassPhrase not supplied");
            }
            if (verbose) {
                Verbose.log("KeyStore File:  " + string2);
                Verbose.log("KeyStore Type:  " + string3);
                Verbose.log("KeyStore Alias: " + string4);
            }
            WlsSSLAdapter wlsSSLAdapter = new WlsSSLAdapter();
            try {
                wlsSSLAdapter.setKeystore(string2, cArray, string3);
                wlsSSLAdapter.setClientCert(string4, cArray2);
            }
            catch (Exception exception) {
                throw new JAXRPCException((Throwable)exception);
            }
            messageContext.setProperty("weblogic.wsee.client.ssladapter", (Object)wlsSSLAdapter);
        }
    }

    public boolean handleClosure(MessageContext messageContext) {
        if (messageContext.containsProperty("weblogic.wsee.conversation.id.msg")) {
            return this.handleResponse(messageContext);
        }
        if (messageContext.getProperty("weblogic.wsee.reliable.oneway.reply") != null) {
            this.send(messageContext);
        }
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        if (messageContext.getProperty("weblogic.wsee.security.fault") != null && Boolean.TRUE.equals(messageContext.getProperty("weblogic.wsee.security.fault")) && (messageContext.getProperty("weblogic.wsee.addressing.ReplyTo") == null || messageContext.getProperty("weblogic.wsee.reply.anonymous") != null) && wlMessageContext.getDispatcher().getOperation().getType() != 1 && wlMessageContext.getDispatcher().getOperation().getType() != 3) {
            this.send(messageContext);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (verbose && wlMessageContext.getFault() != null) {
            Verbose.log((Object)"Webservice invoke failed", wlMessageContext.getFault());
        }
        if (messageContext.getProperty("weblogic.wsee.reliable.oneway.reply") != null) {
            this.send(messageContext);
            return true;
        }
        EndpointReference endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.faultto.override");
        if (endpointReference == null) {
            endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.FaultTo");
        }
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        if (endpointReference != null && !addressingProvider.isAnonymousReferenceURI(endpointReference.getAddress())) {
            return this.handleAsync(messageContext);
        }
        this.send(messageContext);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleRequest(MessageContext messageContext) {
        boolean bl = _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var12_5 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            String string;
            Object object;
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            Dispatcher dispatcher = wlMessageContext.getDispatcher();
            try {
                dispatcher.getConnection().receive(messageContext);
            }
            catch (IOException iOException) {
                object = iOException.getCause();
                if (object == null || !(object instanceof VersionMismatchException)) throw SOAPFaultUtil.newWLSOAPFaultException(messageContext, "Client", "Sender", "Unable to parse the incoming request", null, (Throwable)iOException, SOAPFaultUtil.SOAP12_FC_CLIENT_QNAME);
                VersionMismatchException versionMismatchException = (VersionMismatchException)object;
                SOAPFaultUtil.throwVersionMismatchException(versionMismatchException.getMessage());
            }
            if (((SoapMessageContext)messageContext).hasFault()) {
                messageContext.setProperty("weblogic.wsee.ignore.fault", (Object)"true");
            }
            if ((string = dispatcher.getConnection().getTransport().getServiceURI()) != null) {
                wlMessageContext.setProperty("weblogic.wsee.connection.end_point_uri", string);
            }
            if ((object = dispatcher.getConnection().getTransport().getEndpointAddress()) != null) {
                wlMessageContext.setProperty("weblogic.wsee.connection.end_point_address", object);
            }
            this.populateTransportInfo(wlMessageContext, dispatcher.getConnection().getTransport());
            if (verbose) {
                Verbose.log("Processing request " + messageContext);
            }
            Object var10_15 = null;
            if (!bl) return true;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return true;
    }

    private void populateTransportInfo(WlMessageContext wlMessageContext, Transport transport) {
        HttpServerTransport httpServerTransport;
        HttpServletRequest httpServletRequest;
        if (transport instanceof HttpServerTransport && (httpServletRequest = (httpServerTransport = (HttpServerTransport)transport).getRequest()) != null) {
            wlMessageContext.setProperty("weblogic.wsee.transport.servlet.request.secure", httpServletRequest.isSecure());
            wlMessageContext.setProperty("weblogic.wsee.transport.client.cert.required", SecurityHelper.isClientCertPresent(httpServletRequest));
        }
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    private void send(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        try {
            dispatcher.getConnection().send(messageContext);
        }
        catch (IOException iOException) {
            throw new InvocationException("Failed to send message", iOException);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.wsee.ws.dispatch.server.ConnectionHandler");
        _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Webservices_JAXRPC_Diagnostic_Request_Action_Around_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ConnectionHandler.java", (String)"weblogic.wsee.ws.dispatch.server.ConnectionHandler", (String)"handleRequest", (String)"(Ljavax/xml/rpc/handler/MessageContext;)Z", (int)384, null, (boolean)false);
        verbose = Verbose.isVerbose(ConnectionHandler.class);
    }
}

