/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import weblogic.utils.collections.StackPool;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.handler.JaxrpcHandlerChain;
import weblogic.wsee.message.soap.SoapMessageContext;

public class JaxrpcChainHandler
extends GenericHandler {
    public static final String JAXRPC_HANDLER_CHAIN = "weblogic.wsee.handler.jaxrpcHandlerChain";
    public static final String HANDLER_CHAIN_POOLSIZE = "weblogic.wsee.handler.jaxrpcHandlerChainPoolSize";
    private static boolean freeModify = Boolean.getBoolean("weblogic.wsee.handler.allowAllModification");
    private StackPool handlerChainPool;
    private JaxrpcHandlerChain theChain;

    public void init(HandlerInfo handlerInfo) {
        Map map = handlerInfo.getHandlerConfig();
        this.theChain = (JaxrpcHandlerChain)map.get(JAXRPC_HANDLER_CHAIN);
        String string = (String)map.get(HANDLER_CHAIN_POOLSIZE);
        assert (string != null);
        int n = Integer.parseInt(string);
        this.handlerChainPool = n > 1 ? new StackPool(n) : null;
    }

    public JaxrpcHandlerChain getBaseChain() {
        return this.theChain;
    }

    public void prepareForFirstHandleResponse(MessageContext messageContext) {
        JaxrpcHandlerChain jaxrpcHandlerChain = this.getHandlerChain();
        messageContext.setProperty(JAXRPC_HANDLER_CHAIN, (Object)jaxrpcHandlerChain);
    }

    public void resetWithNewChain(JaxrpcHandlerChain jaxrpcHandlerChain) {
        this.theChain = jaxrpcHandlerChain;
        if (this.handlerChainPool != null) {
            while (this.handlerChainPool.remove() != null) {
            }
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (this.theChain == null) {
            return true;
        }
        JaxrpcHandlerChain jaxrpcHandlerChain = this.getHandlerChain();
        messageContext.setProperty(JAXRPC_HANDLER_CHAIN, (Object)jaxrpcHandlerChain);
        boolean bl = true;
        try {
            if (freeModify) {
                bl = jaxrpcHandlerChain.handleRequest(messageContext);
            } else {
                RequestMessage requestMessage;
                String string;
                RequestMessage requestMessage2 = RequestMessage.recordMessage(messageContext);
                bl = jaxrpcHandlerChain.handleRequest(messageContext);
                if (bl && (string = requestMessage2.checkChange(requestMessage = RequestMessage.recordMessage(messageContext))) != null) {
                    throw new JAXRPCException(string);
                }
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException(sOAPException.getMessage(), (Throwable)sOAPException);
        }
        return bl;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (this.theChain == null) {
            return true;
        }
        JaxrpcHandlerChain jaxrpcHandlerChain = (JaxrpcHandlerChain)messageContext.getProperty(JAXRPC_HANDLER_CHAIN);
        assert (jaxrpcHandlerChain != null);
        jaxrpcHandlerChain.handleResponse(messageContext);
        this.freeHandlerChain(jaxrpcHandlerChain);
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        if (this.theChain == null) {
            return true;
        }
        JaxrpcHandlerChain jaxrpcHandlerChain = (JaxrpcHandlerChain)messageContext.getProperty(JAXRPC_HANDLER_CHAIN);
        if (jaxrpcHandlerChain == null) {
            return true;
        }
        jaxrpcHandlerChain.handleResponse(messageContext);
        this.freeHandlerChain(jaxrpcHandlerChain);
        return true;
    }

    private JaxrpcHandlerChain getHandlerChain() {
        JaxrpcHandlerChain jaxrpcHandlerChain = null;
        try {
            if (this.handlerChainPool == null) {
                jaxrpcHandlerChain = JaxrpcHandlerChain.cloneChain(this.theChain);
                jaxrpcHandlerChain.init();
            } else {
                jaxrpcHandlerChain = (JaxrpcHandlerChain)this.handlerChainPool.remove();
                if (jaxrpcHandlerChain == null) {
                    jaxrpcHandlerChain = JaxrpcHandlerChain.deepCloneChain(this.theChain);
                    jaxrpcHandlerChain.init();
                }
            }
        }
        catch (HandlerException handlerException) {
            throw new JAXRPCException("Failed to initialize Jaxrpc handler chain " + handlerException, (Throwable)handlerException);
        }
        return jaxrpcHandlerChain;
    }

    private void freeHandlerChain(JaxrpcHandlerChain jaxrpcHandlerChain) {
        if (this.handlerChainPool == null) {
            return;
        }
        if (jaxrpcHandlerChain.hasRuntimeException()) {
            jaxrpcHandlerChain.destroy();
        } else if (!this.handlerChainPool.add((Object)jaxrpcHandlerChain)) {
            jaxrpcHandlerChain.destroy();
        }
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public void destroy() {
        if (this.theChain != null) {
            this.theChain.destroy();
        }
        if (this.handlerChainPool != null) {
            JaxrpcHandlerChain jaxrpcHandlerChain = null;
            while ((jaxrpcHandlerChain = (JaxrpcHandlerChain)this.handlerChainPool.remove()) != null) {
                jaxrpcHandlerChain.destroy();
            }
        }
        this.theChain = null;
        this.handlerChainPool = null;
    }

    private static class RequestMessage {
        private Name topElemement;
        private List params = new ArrayList();

        private RequestMessage() {
        }

        static RequestMessage recordMessage(MessageContext messageContext) throws SOAPException {
            RequestMessage requestMessage = new RequestMessage();
            if (messageContext instanceof SoapMessageContext) {
                SoapMessageContext soapMessageContext = (SoapMessageContext)messageContext;
                SOAPBody sOAPBody = soapMessageContext.getMessage().getSOAPBody();
                if (sOAPBody == null) {
                    throw new InvocationException("Unable to find SOAP Body");
                }
                Iterator iterator = sOAPBody.getChildElements();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof SOAPElement)) continue;
                    SOAPElement sOAPElement = (SOAPElement)e;
                    requestMessage.topElemement = sOAPElement.getElementName();
                    RequestMessage.fillinParams(requestMessage, sOAPElement);
                }
            }
            return requestMessage;
        }

        private static void fillinParams(RequestMessage requestMessage, SOAPElement sOAPElement) {
            Iterator iterator = sOAPElement.getChildElements();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SOAPElement)) continue;
                SOAPElement sOAPElement2 = (SOAPElement)e;
                requestMessage.params.add(sOAPElement2.getElementName());
            }
        }

        String checkChange(RequestMessage requestMessage) {
            if (this.topElemement != null && !this.nameEquals(this.topElemement, requestMessage.topElemement)) {
                return "First child element of SOAP body is changed from " + this.topElemement + " to " + requestMessage.topElemement;
            }
            if (this.params.size() != requestMessage.params.size()) {
                return "The number of parameters is changed from " + this.params.size() + " to " + requestMessage.params.size();
            }
            int n = 0;
            for (Name name : this.params) {
                if (!this.nameEquals(name, (Name)requestMessage.params.get(n))) {
                    return "Parameter in position " + n + " is changed from " + name + " to " + requestMessage.params.get(n);
                }
                ++n;
            }
            return null;
        }

        private boolean nameEquals(Name name, Name name2) {
            if (name == null) {
                return name2 == null;
            }
            if (name.getURI() == null) {
                return name2.getURI() == null;
            }
            return name.getURI().equals(name2.getURI()) && name.getLocalName().equals(name2.getLocalName());
        }
    }
}

