/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.HeaderUtil;
import weblogic.wsee.ws.dispatch.Dispatcher;

public class OperationLookupHandler
extends GenericHandler {
    public static final String OPERATION_NAME_PROPERTY = "weblogic.wsee.ws.server.OperationName";

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        AddressingHelper.validateAction(wlMessageContext, true);
        QName qName = this.getOperationName(wlMessageContext);
        if (qName == null) {
            AddressingHelper.checkFaultAction(wlMessageContext);
            String string = "Failed to get operation name from incoming request";
            try {
                HeaderUtil.throwMustUnderstand(messageContext);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.throwMustUnderstand(sOAPFaultException, string);
            }
            this.throwOperationNotFound(string);
        }
        this.findBindingOperation(wlMessageContext.getDispatcher(), qName, messageContext);
        this.findWsMethod(wlMessageContext.getDispatcher(), qName);
        return true;
    }

    private void throwOperationNotFound(String string) {
        QName qName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client", "SOAP-ENV");
        throw new SOAPFaultException(qName, string, null, null);
    }

    private void throwMustUnderstand(SOAPFaultException sOAPFaultException, String string) {
        String string2 = sOAPFaultException.getFaultString() + " " + string;
        throw new SOAPFaultException(sOAPFaultException.getFaultCode(), string2, sOAPFaultException.getFaultActor(), sOAPFaultException.getDetail());
    }

    private QName getOperationName(WlMessageContext wlMessageContext) {
        QName qName = (QName)wlMessageContext.getProperty(OPERATION_NAME_PROPERTY);
        if (qName == null) {
            qName = wlMessageContext.getDispatcher().getOperationName();
            wlMessageContext.setProperty(OPERATION_NAME_PROPERTY, qName);
        }
        return qName;
    }

    private void findWsMethod(Dispatcher dispatcher, QName qName) {
        if (dispatcher.getWsMethod() == null) {
            this.throwOperationNotFound("Unable to find method with name:" + qName + " method available are -- " + dispatcher.getWsPort().getEndpoint());
        }
    }

    private void findBindingOperation(Dispatcher dispatcher, QName qName, MessageContext messageContext) {
        if (dispatcher.getBindingOperation() == null) {
            String string = "Unable to find operation with name:" + qName + " in the corresponding WSDL binding " + dispatcher.getWsdlPort().getBinding();
            try {
                HeaderUtil.throwMustUnderstand(messageContext);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.throwMustUnderstand(sOAPFaultException, string);
            }
            this.throwOperationNotFound(string);
        }
    }
}

