/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.component.Component;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.ws.WsSkel;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.ws.dispatch.server.SecurityHelper;

public class PreinvokeHandler
extends GenericHandler
implements WLHandler {
    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        QName qName = dispatcher.getWsMethod().getOperationName();
        Component component = ((WsSkel)dispatcher.getWsPort().getEndpoint()).getComponent();
        SecurityHelper.setSubject(messageContext);
        try {
            component.preinvoke(qName.getLocalPart(), messageContext);
        }
        catch (ComponentException componentException) {
            throw new InvocationException("Failed to preinvoke end component " + componentException, componentException);
        }
        wlMessageContext.setProperty("weblogic.wsee.preinvoked", "true");
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        boolean bl = this.finish(messageContext);
        SecurityHelper.resetSubject(messageContext);
        return bl;
    }

    public boolean handleClosure(MessageContext messageContext) {
        boolean bl = this.finish(messageContext);
        SecurityHelper.resetSubject(messageContext);
        return bl;
    }

    private boolean finish(MessageContext messageContext) {
        if (messageContext.getProperty("weblogic.wsee.preinvoked") != null) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            Dispatcher dispatcher = wlMessageContext.getDispatcher();
            QName qName = dispatcher.getWsMethod().getOperationName();
            Component component = ((WsSkel)dispatcher.getWsPort().getEndpoint()).getComponent();
            try {
                component.postinvoke(qName.getLocalPart(), messageContext);
            }
            catch (ComponentException componentException) {
                throw new InvocationException("Failed to postinvoke end component " + componentException, componentException);
            }
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        boolean bl = this.finish(messageContext);
        SecurityHelper.resetSubject(messageContext);
        return bl;
    }

    public QName[] getHeaders() {
        return new QName[0];
    }
}

