/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.security.AccessController;
import javax.xml.rpc.handler.MessageContext;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

class SecurityHelper {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    SecurityHelper() {
    }

    protected static void setSubject(MessageContext messageContext) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)messageContext.getProperty("weblogic.wsee.wss.subject");
        if (authenticatedSubject != null) {
            AuthenticatedSubject authenticatedSubject2 = SecurityHelper.switchSubject(authenticatedSubject);
            messageContext.setProperty("weblogic.wsee.subject", (Object)authenticatedSubject2);
        }
    }

    protected static void resetSubject(MessageContext messageContext) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)messageContext.getProperty("weblogic.wsee.subject");
        if (authenticatedSubject != null) {
            SecurityHelper.switchSubject(authenticatedSubject);
            messageContext.removeProperty("weblogic.wsee.subject");
        }
    }

    private static AuthenticatedSubject switchSubject(AuthenticatedSubject authenticatedSubject) {
        AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
        SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject);
        return authenticatedSubject2;
    }
}

