/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPBody;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.CodecFactory;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.jws.RetryException;
import weblogic.wsee.jws.container.ServerResponsePathDispatcher;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.monitoring.OperationStats;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.dispatch.DispatcherImpl;
import weblogic.wsee.ws.dispatch.server.OperationLookupHandler;

public class ServerDispatcher
extends DispatcherImpl {
    public static final String ABORT_REQUEST_ON_FAULT = "weblogic.wsee.ws.dispatch.server.AbortRequestOnFault";
    private static final boolean verbose;
    static final long serialVersionUID = 6505747173496609555L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public ServerDispatcher() {
        this.setInParams(new LinkedHashMap());
        this.setOutParams(new LinkedHashMap());
    }

    public ServerDispatcher(WlMessageContext wlMessageContext) {
        this();
        this.setContext(wlMessageContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch() throws WsException {
        boolean bl = _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var20_4 = null;
        if (bl) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            block38: {
                Throwable throwable;
                block39: {
                    OperationStats operationStats;
                    WsMethod wsMethod;
                    long l = System.nanoTime();
                    CodecFactory codecFactory = CodecFactory.instance();
                    try {
                        this.setCodec(codecFactory.getCodec(this.getWsdlPort().getBinding()));
                    }
                    catch (CodecException codecException) {
                        throw new WsException("Unable to dispatch", codecException);
                    }
                    if (this.getContext() == null) {
                        this.setContext(WlMessageContext.narrow(this.getCodec().createContext()));
                        this.getContext().setDispatcher(this);
                    } else {
                        this.getContext().setDispatcher(this);
                        if (this.getContext().getProperty("weblogic.wsee.ws.server.OperationName") != null) {
                            new OperationLookupHandler().handleRequest(this.getContext());
                        }
                    }
                    this.setHandlerChain(new HandlerIterator(this.getWsPort().getInternalHandlerList()));
                    long l2 = System.nanoTime();
                    int n = 0;
                    Integer n2 = (Integer)this.getContext().getProperty("weblogic.wsee.handler.index");
                    if (n2 != null) {
                        n = n2 + 1;
                    }
                    this.getHandlerChain().handleRequest(this.getContext(), n);
                    if (this.getContext().containsProperty(ABORT_REQUEST_ON_FAULT) && this.getContext().hasFault()) {
                        Throwable throwable2;
                        if (verbose) {
                            Verbose.say("Request generated a fault, and we've got ABORT_REQUEST_ON_FAULT set on the context. Aborting this request, no response path will be dispatched");
                        }
                        if ((throwable2 = this.getContext().getFault()) != null) {
                            throw new WsException(throwable2.toString(), throwable2);
                        }
                        if (this.getContext() instanceof SOAPMessageContext) {
                            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)this.getContext();
                            wsMethod = null;
                            try {
                                SOAPBody sOAPBody = sOAPMessageContext.getMessage().getSOAPBody();
                                if (sOAPBody.hasFault()) {
                                    wsMethod = sOAPBody.getFault();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (wsMethod != null) {
                                SOAPFaultException sOAPFaultException = new SOAPFaultException(wsMethod.getFaultCodeAsQName(), wsMethod.getFaultString(), wsMethod.getFaultActor(), wsMethod.getDetail());
                                sOAPFaultException.fillInStackTrace();
                                throw new WsException(sOAPFaultException.toString(), sOAPFaultException);
                            }
                        }
                    }
                    long l3 = System.nanoTime();
                    if (this.getContext().getProperty("weblogic.wsee.cluster.routed") == null && this.getContext().getProperty("weblogic.wsee.util.VersionRedirectUtil.redirected") == null) {
                        if (this.getOperation() == null) {
                            if (this.getContext().getProperty("weblogic.wsee.oneway.confirmed") != null) {
                                this.getHandlerChain().handleClosure(this.getContext());
                            } else if (this.getContext().getProperty("weblogic.jws.AsyncTransactionalInvoke") != null) {
                                ServerResponsePathDispatcher.saveContextForResponsePath(this.getContext());
                            } else {
                                this.getHandlerChain().handleResponse(this.getContext());
                            }
                        } else if (this.getContext().getProperty("weblogic.jws.AsyncTransactionalInvoke") != null && !this.getContext().hasFault()) {
                            ServerResponsePathDispatcher.saveContextForResponsePath(this.getContext());
                        } else {
                            this.callHandleResponse();
                        }
                    }
                    if ((wsMethod = this.getWsMethod()) != null && (operationStats = wsMethod.getStats()) != null) {
                        operationStats.reportInvocation(l2 - l, l3 - l2, System.nanoTime() - l3);
                        if (this.getContext().hasFault()) {
                            Throwable throwable3 = this.getContext().getFault();
                            operationStats.reportResponseError(throwable3);
                            if (throwable3 instanceof RetryException) {
                                throw new WsException("RetryException", throwable3);
                            }
                        }
                    }
                    if (this.getContext().getFault() == null) break block38;
                    throwable = this.getContext().getFault();
                    if (this.getOperation() == null) break block39;
                    switch (this.getOperation().getType()) {
                        case 1: {
                            if (verbose) {
                                Verbose.logException(throwable);
                                break;
                            }
                            break block38;
                        }
                        default: {
                            if (this.getContext() instanceof SOAPMessageContext) {
                                SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)this.getContext();
                                SOAPBody sOAPBody = null;
                                try {
                                    sOAPBody = sOAPMessageContext.getMessage().getSOAPBody();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if ((sOAPMessageContext.getMessage() == null || sOAPBody == null || !sOAPBody.hasFault()) && verbose) {
                                    Verbose.logException(throwable);
                                    break;
                                }
                            }
                            break block38;
                        }
                    }
                    break block38;
                }
                if (verbose) {
                    Verbose.logException(throwable);
                }
            }
            Object var18_27 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    public void dispatchResponsePath() throws WsException {
        OperationStats operationStats;
        WsMethod wsMethod;
        Integer n;
        long l = System.nanoTime();
        CodecFactory codecFactory = CodecFactory.instance();
        try {
            this.setCodec(codecFactory.getCodec(this.getWsdlPort().getBinding()));
        }
        catch (CodecException codecException) {
            throw new WsException("Unable to dispatch", codecException);
        }
        if (this.getContext() == null) {
            throw new WsException("No WLMessageContext in dispatchResponsePath. This context should have been saved during the request path, and used to construct the dispatcher for the response path");
        }
        this.getContext().setDispatcher(this);
        if (this.getContext().getProperty("weblogic.wsee.ws.server.OperationName") != null) {
            new OperationLookupHandler().handleRequest(this.getContext());
        }
        int n2 = (n = (Integer)this.getContext().getProperty("weblogic.wsee.handler.index")) != null ? n : 0;
        HandlerIterator handlerIterator = new HandlerIterator(this.getWsPort().getInternalHandlerList());
        this.setHandlerChain(handlerIterator);
        handlerIterator.setIndex(n2);
        long l2 = System.nanoTime();
        long l3 = System.nanoTime();
        if (this.getContext().getProperty("weblogic.wsee.cluster.routed") == null && this.getContext().getProperty("weblogic.wsee.util.VersionRedirectUtil.redirected") == null) {
            if (this.getOperation() == null) {
                if (this.getContext().getProperty("weblogic.wsee.oneway.confirmed") != null) {
                    this.getHandlerChain().handleClosure(this.getContext());
                } else {
                    this.getHandlerChain().handleAsyncResponse(this.getContext());
                }
            } else {
                this.callHandleResponse();
            }
        }
        if ((wsMethod = this.getWsMethod()) != null && (operationStats = wsMethod.getStats()) != null) {
            operationStats.reportInvocation(l2 - l, l3 - l2, System.nanoTime() - l3);
            if (this.getContext().hasFault()) {
                operationStats.reportResponseError(this.getContext().getFault());
            }
        }
    }

    private void callHandleResponse() {
        switch (this.getOperation().getType()) {
            case 0: 
            case 2: {
                this.getHandlerChain().handleResponse(this.getContext());
                break;
            }
            case 1: {
                if (this.getContext().getProperty("weblogic.wsee.reliable.oneway.reply") == null) {
                    if (this.getContext().hasFault() && this.getContext().getProperty("weblogic.wsee.oneway.confirmed") == null) {
                        this.getHandlerChain().handleResponse(this.getContext());
                        break;
                    }
                    if (this.getContext().getProperty("weblogic.wsee.oneway.confirmed") == null) {
                        try {
                            this.getContext().getDispatcher().getConnection().getTransport().confirmOneway();
                        }
                        catch (IOException iOException) {
                            throw new InvocationException("Failed to confirm oneway", iOException);
                        }
                        this.getContext().setProperty("weblogic.wsee.oneway.confirmed", "true");
                    }
                }
                this.getHandlerChain().handleClosure(this.getContext());
                break;
            }
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.wsee.ws.dispatch.server.ServerDispatcher");
        _WLDF$INST_FLD_Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Webservices_JAXRPC_Diagnostic_Dispatch_Action_Around_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ServerDispatcher.java", (String)"weblogic.wsee.ws.dispatch.server.ServerDispatcher", (String)"dispatch", (String)"()V", (int)77, null, (boolean)false);
        verbose = Verbose.isVerbose(ServerDispatcher.class);
    }
}

