/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServletEndpointContext;
import weblogic.wsee.connection.transport.servlet.HttpTransportUtils;
import weblogic.wsee.jws.context.WebSecurityContext;
import weblogic.wsee.message.WlMessageContext;

public class ServletEndpointContextImpl
implements ServletEndpointContext {
    private static ThreadLocal msgCtx = new ThreadLocal();
    private ServletContext servletContext;
    private WebSecurityContext securityCtx;

    public static MessageContext getMessageContextStatic() {
        return (MessageContext)msgCtx.get();
    }

    public ServletEndpointContextImpl(ServletContext servletContext, Class clazz) {
        this.servletContext = servletContext;
        this.securityCtx = new WebSecurityContext(null, clazz);
    }

    public void setMessageContext(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        msgCtx.set(wlMessageContext);
        this.securityCtx.setMessageContext(wlMessageContext);
    }

    public void unSetMessageContext() {
        msgCtx.set(null);
    }

    public MessageContext getMessageContext() {
        return (MessageContext)msgCtx.get();
    }

    public void setSecurityContext(WebSecurityContext webSecurityContext) {
        this.securityCtx = webSecurityContext;
    }

    public WebSecurityContext getSecurityContext() {
        return this.securityCtx;
    }

    public Principal getUserPrincipal() {
        return this.securityCtx.getCallerPrincipal();
    }

    public HttpSession getHttpSession() {
        HttpServletRequest httpServletRequest = HttpTransportUtils.getHttpServletRequest(this.getMessageContext());
        if (httpServletRequest != null) {
            return httpServletRequest.getSession();
        }
        return null;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isUserInRole(String string) {
        return this.securityCtx.isCallerInRole(string);
    }
}

