/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.dispatch.server;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.WsrmPermanentTransportException;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.faults.CreateSequenceRefusedFaultMsg;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgFactory;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.reliability.handshake.WsrmServerHandshakeHandler;
import weblogic.wsee.security.wssp.handlers.WssServerHandler;
import weblogic.wsee.util.Verbose;

public class SoapFaultHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(SoapFaultHandler.class);

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (messageContext.getProperty("weblogic.wsee.ignore.fault") != null) {
            List<QName> list;
            Object object;
            block20: {
                try {
                    object = ((SoapMessageContext)messageContext).getMessage().getSOAPBody().getFault();
                    assert (object != null);
                    list = WsrmFaultMsg.getSubCodeQNames(CreateSequenceRefusedFaultMsg.class);
                    if (list.contains(object.getFaultCodeAsQName())) {
                        RelatesToHeader relatesToHeader = (RelatesToHeader)WlMessageContext.narrow(messageContext).getHeaders().getHeader(RelatesToHeader.TYPE);
                        if (relatesToHeader == null) {
                            throw new JAXRPCException("No relates to header found");
                        }
                        String string = relatesToHeader.getRelatedMessageId();
                        boolean bl = WsrmServerHandshakeHandler.isRMSequenceSecure(true, string);
                        if (bl) {
                            if (!AsyncUtil.getWssServerHandler(WsrmServerHandshakeHandler.getRMSequenceContext(true, string)).handleRequest(messageContext)) {
                                return true;
                            }
                            if (!this.validateSecurityPolicy(messageContext, true, string)) {
                                return true;
                            }
                        }
                        if (verbose) {
                            Verbose.log("Create sequence refused with: " + object.getFaultString());
                        }
                        this.handlePermanentException(messageContext, string, "-1");
                        WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleCreateSequenceRefusedError(string);
                        return false;
                    }
                }
                catch (SOAPException sOAPException) {
                    if (!verbose) break block20;
                    Verbose.logException(sOAPException);
                }
            }
            try {
                boolean bl;
                boolean bl2;
                if (!new WssServerHandler().handleRequest(messageContext)) {
                    return true;
                }
                object = SequenceFaultMsgFactory.getInstance().parseSoapFault(((SoapMessageContext)messageContext).getMessage());
                list = ((SequenceFaultMsg)object).getSequenceId();
                RelatesToHeader relatesToHeader = (RelatesToHeader)WlMessageContext.narrow(messageContext).getHeaders().getHeader(RelatesToHeader.TYPE);
                boolean bl3 = bl2 = object instanceof IllegalRMVersionFaultMsg && "New".equals(list);
                if (bl2) {
                    if (relatesToHeader == null) {
                        throw new JAXRPCException("No relates to header found");
                    }
                    list = relatesToHeader.getRelatedMessageId();
                    ((SequenceFaultMsg)object).setSequenceId((String)((Object)list));
                }
                if (bl = WsrmServerHandshakeHandler.isRMSequenceSecure(true, (String)((Object)list))) {
                    if (!this.validateSecurityPolicy(messageContext, true, (String)((Object)list))) {
                        return true;
                    }
                    WsrmServerHandshakeHandler.validateCredential(true, (String)((Object)list), null, messageContext);
                }
                if (relatesToHeader != null) {
                    String string = relatesToHeader.getRelatedMessageId();
                    if (bl2) {
                        this.handlePermanentException(messageContext, string, "-1");
                    } else {
                        this.handlePermanentException(messageContext, (String)((Object)list), string);
                    }
                }
                WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleFault((SequenceFaultMsg)object);
                return false;
            }
            catch (SequenceFaultException sequenceFaultException) {
                return true;
            }
        }
        return true;
    }

    private void handlePermanentException(MessageContext messageContext, String string, String string2) {
        try {
            SOAPFault sOAPFault = ((SoapMessageContext)messageContext).getMessage().getSOAPBody().getFault();
            SOAPFaultException sOAPFaultException = new SOAPFaultException(sOAPFault.getFaultCodeAsQName(), sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
            WsrmPermanentTransportException wsrmPermanentTransportException = new WsrmPermanentTransportException(sOAPFaultException.toString(), sOAPFaultException);
            WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleAsyncFault(string, string2, wsrmPermanentTransportException);
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    private boolean validateSecurityPolicy(MessageContext messageContext, boolean bl, String string) {
        messageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)WsrmServerHandshakeHandler.getAsyncResponseEndpointSecurityPolicy(bl, string));
        return AsyncUtil.getWssServerPolicyHandler(WsrmServerHandshakeHandler.getRMSequenceContext(bl, string)).handleRequest(messageContext);
    }
}

